/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import io.crate.replication.logical.exceptions.MissingShardOperationsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.MissingHistoryOperationsException;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.GlobalCheckpointListeners;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class ShardChangesAction
extends ActionType<Response> {
    public static final String NAME = "internal:crate:replication/logical/shard/changes";
    public static final ShardChangesAction INSTANCE = new ShardChangesAction();

    public ShardChangesAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<Response> getResponseReader() {
        return Response::new;
    }

    public static class Response
    extends TransportResponse {
        private final List<Translog.Operation> changes;
        private final long fromSeqNo;
        private final long maxSeqNoOfUpdatesOrDeletes;
        private final long lastSyncedGlobalCheckpoint;
        private final long version;

        public Response(List<Translog.Operation> changes, long fromSeqNo, long maxSeqNoOfUpdatesOrDeletes, long lastSyncedGlobalCheckpoint, long version) {
            this.changes = changes;
            this.fromSeqNo = fromSeqNo;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
            this.lastSyncedGlobalCheckpoint = lastSyncedGlobalCheckpoint;
            this.version = version;
        }

        public Response(StreamInput in) throws IOException {
            this.changes = in.readList(Translog.Operation::readOperation);
            this.fromSeqNo = in.readVLong();
            this.maxSeqNoOfUpdatesOrDeletes = in.readLong();
            this.lastSyncedGlobalCheckpoint = in.readLong();
            this.version = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.changes, Translog.Operation::writeOperation);
            out.writeVLong(this.fromSeqNo);
            out.writeLong(this.maxSeqNoOfUpdatesOrDeletes);
            out.writeLong(this.lastSyncedGlobalCheckpoint);
            out.writeVLong(this.version);
        }

        public List<Translog.Operation> changes() {
            return this.changes;
        }

        public long fromSeqNo() {
            return this.fromSeqNo;
        }

        public long maxSeqNoOfUpdatesOrDeletes() {
            return this.maxSeqNoOfUpdatesOrDeletes;
        }

        public long lastSyncedGlobalCheckpoint() {
            return this.lastSyncedGlobalCheckpoint;
        }

        public long version() {
            return this.version;
        }
    }

    public static class Request
    extends SingleShardRequest {
        private final ShardId shardId;
        private final long fromSeqNo;
        private final long toSeqNo;

        public Request(ShardId shardId, long fromSeqNo, long toSeqNo) {
            super(shardId.getIndexName());
            this.shardId = shardId;
            this.fromSeqNo = fromSeqNo;
            this.toSeqNo = toSeqNo;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.fromSeqNo = in.readLong();
            this.toSeqNo = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeLong(this.fromSeqNo);
            out.writeVLong(this.toSeqNo);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public long fromSeqNo() {
            return this.fromSeqNo;
        }

        public long toSeqNo() {
            return this.toSeqNo;
        }

        public String toString() {
            return "Request{shardId=" + String.valueOf(this.shardId) + ", fromSeqNo=" + this.fromSeqNo + ", toSeqNo=" + this.toSeqNo + "}";
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        public static final TimeValue WAIT_FOR_NEW_OPS_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
        private static final Logger LOGGER = LogManager.getLogger(TransportAction.class);
        private final IndicesService indicesService;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
            super(ShardChangesAction.NAME, threadPool, clusterService, transportService, Request::new, "search");
            this.indicesService = indicesService;
            TransportActionProxy.registerProxyAction(transportService, ShardChangesAction.NAME, Response::new);
        }

        @Override
        protected Response shardOperation(Request request, ShardId shardId) throws IOException {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            IndexShard indexShard = indexService.getShard(shardId.id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            long toSeqNo = Math.min(seqNoStats.getGlobalCheckpoint(), request.toSeqNo());
            long fromSeqNo = request.fromSeqNo();
            ArrayList<Translog.Operation> ops = new ArrayList<Translog.Operation>();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.info("[{}] Fetching changes from lucene for {} - from:{}, to:{}", (Object)shardId, (Object)request.shardId(), (Object)request.fromSeqNo(), (Object)toSeqNo);
            }
            String source = "logical-replication";
            try (Translog.Snapshot snapshot = indexShard.newChangesSnapshot(source, fromSeqNo, toSeqNo, true);){
                Translog.Operation op = snapshot.next();
                while (op != null) {
                    ops.add(op);
                    op = snapshot.next();
                }
            }
            catch (MissingHistoryOperationsException e) {
                Collection<RetentionLease> retentionLeases = indexShard.getRetentionLeases().leases();
                String message = "Operations are no longer available for replicating. Existing retention leases [" + String.valueOf(retentionLeases) + "]; maybe increase the retention lease period setting [" + IndexSettings.INDEX_SOFT_DELETES_RETENTION_LEASE_PERIOD_SETTING.getKey() + "]?";
                throw new MissingShardOperationsException(RelationName.fromIndexName(shardId.getIndexName()), message);
            }
            return new Response(ops, fromSeqNo, indexShard.getMaxSeqNoOfUpdatesOrDeletes(), seqNoStats.getGlobalCheckpoint(), indexService.getMetadata().getVersion());
        }

        @Override
        protected void asyncShardOperation(final Request request, final ShardId shardId, final ActionListener<Response> listener) throws IOException {
            final IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            if (seqNoStats.getGlobalCheckpoint() < request.fromSeqNo()) {
                if (this.logger.isTraceEnabled()) {
                    LOGGER.trace("[{}] Waiting for globalCheckpoint to advance from {} to {}", (Object)shardId, (Object)seqNoStats.getGlobalCheckpoint(), (Object)request.fromSeqNo());
                }
                indexShard.addGlobalCheckpointListener(request.fromSeqNo(), new GlobalCheckpointListeners.GlobalCheckpointListener(){
                    final /* synthetic */ TransportAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public Executor executor() {
                        return this.this$0.threadPool.executor("listener");
                    }

                    @Override
                    public void accept(long globalCheckpoint, Exception e) {
                        if (globalCheckpoint != -2L) {
                            if (globalCheckpoint < request.fromSeqNo()) {
                                assert (globalCheckpoint > indexShard.getLastSyncedGlobalCheckpoint()) : "Checkpoint didn't advance at all";
                                listener.onFailure(new ElasticsearchTimeoutException("global checkpoint not synced.", new Object[0]));
                                return;
                            }
                            try {
                                TransportAction.super.asyncShardOperation(request, shardId, listener);
                            }
                            catch (IOException ioException) {
                                listener.onFailure(ioException);
                            }
                        } else {
                            assert (e != null) : "Exception expected if globalCheckout != -2";
                            if (e instanceof TimeoutException) {
                                LOGGER.trace("Waiting for advanced globalCheckpoint timed out", (Throwable)e);
                                SeqNoStats latestSeqNoStats = indexShard.seqNoStats();
                                IndexService indexService = this.this$0.indicesService.indexServiceSafe(shardId.getIndex());
                                Response response = new Response(List.of(), request.fromSeqNo(), indexShard.getMaxSeqNoOfUpdatesOrDeletes(), latestSeqNoStats.getGlobalCheckpoint(), indexService.getMetadata().getVersion());
                                listener.onResponse(response);
                            } else {
                                listener.onFailure(e);
                            }
                        }
                    }
                }, WAIT_FOR_NEW_OPS_TIMEOUT);
            } else {
                super.asyncShardOperation(request, shardId, listener);
            }
        }

        @Override
        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        @Override
        @Nullable
        protected ShardsIterator shards(ClusterState state, Request request) {
            return state.routingTable().shardRoutingTable(request.shardId().getIndexUUID(), request.shardId().id()).activeInitializingShardsRandomIt();
        }
    }
}

