/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import io.crate.replication.logical.action.CreatePublicationRequest;
import io.crate.replication.logical.exceptions.PublicationAlreadyExistsException;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import io.crate.role.Roles;
import java.util.Locale;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreatePublication
extends AbstractDDLTransportAction<CreatePublicationRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final Roles roles;

    @Inject
    public TransportCreatePublication(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Roles roles) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreatePublicationRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "create-publication");
        this.roles = roles;
    }

    @Override
    public ClusterStateTaskExecutor<CreatePublicationRequest> clusterStateTaskExecutor(CreatePublicationRequest request) {
        return new DDLClusterStateTaskExecutor<CreatePublicationRequest>(){

            @Override
            protected ClusterState execute(ClusterState currentState, CreatePublicationRequest request) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                PublicationsMetadata oldMetadata = (PublicationsMetadata)mdBuilder.getCustom("publications");
                if (oldMetadata != null && oldMetadata.publications().containsKey(request.name())) {
                    throw new PublicationAlreadyExistsException(request.name());
                }
                if (TransportCreatePublication.this.roles.findUser(request.owner()) == null) {
                    throw new IllegalStateException(String.format(Locale.ENGLISH, "Publication '%s' cannot be created as the user '%s' owning the publication has been dropped.", request.name(), request.owner()));
                }
                for (RelationName relation : request.tables()) {
                    RelationMetadata.Table table = (RelationMetadata.Table)currentMetadata.getRelation(relation);
                    if (table != null) continue;
                    throw new RelationUnknown(relation);
                }
                PublicationsMetadata newMetadata = PublicationsMetadata.newInstance(oldMetadata);
                newMetadata.publications().put(request.name(), new Publication(request.owner(), request.isForAllTables(), request.tables()));
                assert (!newMetadata.equals(oldMetadata)) : "must not be equal to guarantee the cluster change action";
                mdBuilder.putCustom("publications", newMetadata);
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }
        };
    }

    @Override
    protected ClusterBlockException checkBlock(CreatePublicationRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:replication/logical/publication/create";

        private Action() {
            super(NAME);
        }
    }
}

