/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.engine;

import io.crate.exceptions.UnsupportedFeatureException;
import java.io.IOException;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.InternalEngine;
import org.jetbrains.annotations.VisibleForTesting;

public class SubscriberEngine
extends InternalEngine {
    public SubscriberEngine(EngineConfig engineConfig) {
        super(engineConfig);
    }

    @Override
    protected long generateSeqNoForOperationOnPrimary(Engine.Operation operation) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY);
        assert (operation.seqNo() >= 0L) : "replicated operation should have an assigned seq no. but was: " + operation.seqNo();
        this.markSeqNoAsSeen(operation.seqNo());
        return operation.seqNo();
    }

    @Override
    protected boolean assertPrimaryIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        assert (origin == Engine.Operation.Origin.PRIMARY) : "Expected origin PRIMARY for replicated operations, but was: " + String.valueOf((Object)origin);
        assert (seqNo != -2L) : "Expected valid sequence number for replicated op but was unassigned";
        return true;
    }

    @VisibleForTesting
    static void validate(Engine.Operation operation) {
        if (operation.seqNo() == -2L) {
            throw new UnsupportedFeatureException("A subscriber engine does not accept operations without an assigned sequence number");
        }
        if (operation.origin() == Engine.Operation.Origin.PRIMARY != (operation.versionType() == VersionType.EXTERNAL)) {
            throw new IllegalStateException("Invalid version_type in a subscriber engine; version_type=" + String.valueOf((Object)operation.versionType()) + " origin=" + String.valueOf((Object)operation.origin()));
        }
    }

    @Override
    protected InternalEngine.IndexingStrategy indexingStrategyForOperation(Engine.Index index) throws IOException {
        SubscriberEngine.validate(index);
        return this.planIndexingAsNonPrimary(index);
    }

    @Override
    protected InternalEngine.DeletionStrategy deletionStrategyForOperation(Engine.Delete delete) throws IOException {
        SubscriberEngine.validate(delete);
        return super.deletionStrategyForOperation(delete);
    }

    @Override
    protected boolean assertNonPrimaryOrigin(Engine.Operation operation) {
        return true;
    }
}

