/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.metadata.pgcatalog;

import io.crate.execution.engine.collect.sources.InformationSchemaIterables;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.SystemTable;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.metadata.Publication;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.stream.Stream;

public class PgPublicationTablesTable {
    public static final RelationName IDENT = new RelationName("pg_catalog", "pg_publication_tables");
    public static SystemTable<PublicatedTableRow> INSTANCE = ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("pubname", (DataType)DataTypes.STRING, p -> p.publicationName)).add("schemaname", (DataType)DataTypes.STRING, p -> p.relationName.schema())).add("tablename", (DataType)DataTypes.STRING, p -> p.relationName.name())).build();

    public static Iterable<PublicatedTableRow> rows(LogicalReplicationService logicalReplicationService, Schemas schemas) {
        return () -> {
            Stream s = logicalReplicationService.publications().entrySet().stream().mapMulti((e, c) -> {
                Publication pub = (Publication)e.getValue();
                List<RelationName> tables = pub.tables();
                if (pub.isForAllTables()) {
                    InformationSchemaIterables.tablesStream(schemas).filter(t -> t instanceof DocTableInfo).forEach(t -> c.accept(new PublicatedTableRow((String)e.getKey(), t.ident(), pub.owner())));
                } else {
                    tables.forEach(t -> c.accept(new PublicatedTableRow((String)e.getKey(), (RelationName)t, pub.owner())));
                }
            });
            return s.iterator();
        };
    }

    public record PublicatedTableRow(String publicationName, RelationName relationName, String owner) {
    }
}

