/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.repository;

import io.crate.common.collections.Sets;
import io.crate.common.io.IOUtils;
import io.crate.replication.logical.action.RestoreShardRequest;
import io.crate.replication.logical.seqno.RetentionLeaseHelper;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.IndicesService;

public class PublisherRestoreService
extends AbstractLifecycleComponent {
    private final IndicesService indicesService;
    private final NodeClient nodeClient;
    private final Map<String, RestoreContext> onGoingRestores = new ConcurrentHashMap<String, RestoreContext>();
    private final Set<Closeable> closableResources = Sets.newConcurrentHashSet();

    @Inject
    public PublisherRestoreService(IndicesService indicesService, NodeClient nodeClient) {
        this.indicesService = indicesService;
        this.nodeClient = nodeClient;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
        IOUtils.close(this.closableResources);
    }

    public void createRestoreContext(String restoreUUID, RestoreShardRequest request, Consumer<RestoreContext> onSuccess, Consumer<Exception> onFailure) {
        this.constructRestoreContext(restoreUUID, request, context -> {
            this.onGoingRestores.putIfAbsent(restoreUUID, (RestoreContext)context);
            onSuccess.accept((RestoreContext)context);
        }, onFailure);
    }

    private RestoreContext getRestoreContextSafe(String restoreUUID) {
        RestoreContext restoreContext = this.onGoingRestores.get(restoreUUID);
        if (restoreContext == null) {
            throw new IllegalStateException("missing restoreContext");
        }
        return restoreContext;
    }

    public InputStreamIndexInput openInputStream(String restoreUUID, RestoreShardRequest request, String fileName, long length) {
        IndexShard leaderIndexShard = this.indicesService.getShardOrNull(request.shardId());
        if (leaderIndexShard == null) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Shard [%s] missing", request.shardId()));
        }
        RestoreContext restoreContext = this.getRestoreContextSafe(restoreUUID);
        final IndexInput indexInput = restoreContext.openInput(fileName);
        return new InputStreamIndexInput(this, indexInput, length){

            @Override
            public void close() throws IOException {
                super.close();
                IOUtils.close((Closeable[])new Closeable[]{indexInput});
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructRestoreContext(String restoreUUID, RestoreShardRequest request, Consumer<RestoreContext> onSuccess, Consumer<Exception> onFailure) {
        IndexShard leaderIndexShard = this.indicesService.getShardOrNull(request.shardId());
        if (leaderIndexShard == null) {
            onFailure.accept(new UnsupportedOperationException(String.format(Locale.ENGLISH, "Shard [%s] missing", request.shardId())));
            return;
        }
        Closeable retentionLock = leaderIndexShard.acquireHistoryRetentionLock(Engine.HistorySource.INDEX);
        this.closableResources.add(retentionLock);
        Engine.IndexCommitRef indexCommitRef = leaderIndexShard.acquireSafeIndexCommit();
        Store store = leaderIndexShard.store();
        Store.MetadataSnapshot metadataSnapshot = Store.MetadataSnapshot.EMPTY;
        store.incRef();
        try {
            metadataSnapshot = store.getMetadata(indexCommitRef.getIndexCommit());
        }
        catch (IOException e2) {
            if (this.closeRetentionLock(retentionLock, onFailure)) {
                onFailure.accept(new UncheckedIOException(e2));
            }
            return;
        }
        finally {
            store.decRef();
        }
        long fromSeqNo = -1L;
        Store.MetadataSnapshot finalMetadataSnapshot = metadataSnapshot;
        RetentionLeaseHelper.addRetentionLease(request.shardId(), fromSeqNo, request.subscriberClusterName(), this.nodeClient, ActionListener.wrap(r -> {
            if (this.closeRetentionLock(retentionLock, onFailure)) {
                RestoreContext restoreContext = new RestoreContext(indexCommitRef, finalMetadataSnapshot);
                this.onGoingRestores.put(restoreUUID, restoreContext);
                this.closableResources.add(restoreContext);
                onSuccess.accept(restoreContext);
            }
        }, e -> {
            if (this.closeRetentionLock(retentionLock, onFailure)) {
                onFailure.accept((Exception)e);
            }
        }));
    }

    private boolean closeRetentionLock(Closeable retentionLock, Consumer<Exception> onFailure) {
        try {
            retentionLock.close();
            return true;
        }
        catch (IOException e) {
            onFailure.accept(new UncheckedIOException(e));
            return false;
        }
    }

    public void removeRestoreContext(String restoreUUID) {
        RestoreContext restoreContext = this.onGoingRestores.remove(restoreUUID);
        if (restoreContext != null) {
            restoreContext.close();
        }
    }

    public static class RestoreContext
    implements Closeable {
        private final Engine.IndexCommitRef indexCommitRef;
        private final Store.MetadataSnapshot metadataSnapshot;

        public RestoreContext(Engine.IndexCommitRef indexCommitRef, Store.MetadataSnapshot metadataSnapshot) {
            this.indexCommitRef = indexCommitRef;
            this.metadataSnapshot = metadataSnapshot;
        }

        public IndexInput openInput(String fileName) {
            IndexInput currentIndexInput;
            try {
                currentIndexInput = this.indexCommitRef.getIndexCommit().getDirectory().openInput(fileName, IOContext.READONCE);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return currentIndexInput;
        }

        @Override
        public void close() {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.indexCommitRef});
        }

        public Store.MetadataSnapshot metadataSnapshot() {
            return this.metadataSnapshot;
        }
    }
}

