/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.AmbiguousColumnAliasException;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.AnalyzerInvalidException;
import io.crate.exceptions.AnalyzerUnknownException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.ColumnValidationException;
import io.crate.exceptions.DuplicateKeyException;
import io.crate.exceptions.InvalidRelationName;
import io.crate.exceptions.InvalidSchemaNameException;
import io.crate.exceptions.PartitionAlreadyExistsException;
import io.crate.exceptions.PartitionUnknownException;
import io.crate.exceptions.ReadOnlyException;
import io.crate.exceptions.RelationValidationException;
import io.crate.exceptions.RelationsUnknown;
import io.crate.exceptions.RepositoryAlreadyExistsException;
import io.crate.exceptions.SQLExceptions;
import io.crate.exceptions.SQLParseException;
import io.crate.exceptions.UnsupportedFunctionException;
import io.crate.rest.action.HttpErrorStatus;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.jetbrains.annotations.Nullable;

public class HttpError {
    private final HttpResponseStatus httpResponseStatus;
    private final int errorCode;
    private final String message;
    @Nullable
    private final Throwable t;

    public HttpError(HttpErrorStatus status, String message, @Nullable Throwable t) {
        this(status.httpResponseStatus(), status.errorCode(), message, t);
    }

    public HttpError(HttpResponseStatus httpResponseStatus, int errorCode, String message, @Nullable Throwable t) {
        this.httpResponseStatus = httpResponseStatus;
        this.errorCode = errorCode;
        this.message = message;
        this.t = t;
    }

    public HttpResponseStatus httpResponseStatus() {
        return this.httpResponseStatus;
    }

    public int errorCode() {
        return this.errorCode;
    }

    public String message() {
        return this.message;
    }

    public ByteBuf toXContent(boolean includeErrorTrace, ByteBuf resultBuffer) throws IOException {
        try (XContentBuilder builder = new XContentBuilder((XContent)JsonXContent.JSON_XCONTENT, (OutputStream)new ByteBufOutputStream(resultBuffer));){
            builder.startObject();
            builder.startObject("error");
            builder.field("message", Exceptions.userFriendlyMessage((Throwable)this.t));
            builder.field("code", this.errorCode);
            builder.endObject();
            if (includeErrorTrace) {
                builder.field("error_trace", Exceptions.stackTrace((Throwable)this.t));
            }
            builder.endObject();
            builder.flush();
            ByteBuf byteBuf = resultBuffer;
            return byteBuf;
        }
    }

    public String toString() {
        return "HttpError{httpResponseStatus=" + String.valueOf(this.httpResponseStatus) + ", errorCode=" + this.errorCode + ", message='" + this.message + "', t=" + String.valueOf(this.t) + "}";
    }

    public static HttpError fromThrowable(Throwable throwable) {
        HttpErrorStatus httpErrorStatus = HttpErrorStatus.UNHANDLED_SERVER_ERROR;
        if (throwable instanceof AmbiguousColumnAliasException) {
            httpErrorStatus = HttpErrorStatus.COLUMN_ALIAS_IS_AMBIGUOUS;
        } else if (throwable instanceof AmbiguousColumnException) {
            httpErrorStatus = HttpErrorStatus.COLUMN_ALIAS_IS_AMBIGUOUS;
        } else if (throwable instanceof AnalyzerInvalidException) {
            httpErrorStatus = HttpErrorStatus.STATEMENT_INVALID_ANALYZER_DEFINITION;
        } else if (throwable instanceof ColumnValidationException) {
            httpErrorStatus = HttpErrorStatus.FIELD_VALIDATION_FAILED;
        } else if (throwable instanceof InvalidRelationName) {
            httpErrorStatus = HttpErrorStatus.RELATION_INVALID_NAME;
        } else if (throwable instanceof InvalidSchemaNameException) {
            httpErrorStatus = HttpErrorStatus.RELATION_INVALID_NAME;
        } else if (throwable instanceof RelationValidationException) {
            httpErrorStatus = HttpErrorStatus.FIELD_VALIDATION_FAILED;
        } else if (throwable instanceof SQLParseException) {
            httpErrorStatus = HttpErrorStatus.STATEMENT_INVALID_OR_UNSUPPORTED_SYNTAX;
        } else if (throwable instanceof UnsupportedFunctionException) {
            httpErrorStatus = HttpErrorStatus.POSSIBLE_FEATURE_NOT_SUPPROTED_YET;
        } else if (throwable instanceof AnalyzerUnknownException) {
            httpErrorStatus = HttpErrorStatus.STATEMENT_INVALID_ANALYZER_DEFINITION;
        } else if (throwable instanceof ColumnUnknownException) {
            httpErrorStatus = HttpErrorStatus.COLUMN_UNKNOWN;
        } else if (throwable instanceof PartitionUnknownException) {
            httpErrorStatus = HttpErrorStatus.PARTITION_UNKNOWN;
        } else if (throwable instanceof RelationsUnknown) {
            httpErrorStatus = HttpErrorStatus.RELATION_UNKNOWN;
        } else if (throwable instanceof ReadOnlyException) {
            httpErrorStatus = HttpErrorStatus.ONLY_READ_OPERATION_ALLOWED_ON_THIS_NODE;
        } else if (throwable instanceof DuplicateKeyException) {
            httpErrorStatus = HttpErrorStatus.DOCUMENT_WITH_THE_SAME_PRIMARY_KEY_EXISTS_ALREADY;
        } else if (throwable instanceof PartitionAlreadyExistsException) {
            httpErrorStatus = HttpErrorStatus.PARTITION_FOR_THE_SAME_VALUE_EXISTS_ALREADY;
        } else if (throwable instanceof RepositoryAlreadyExistsException) {
            httpErrorStatus = HttpErrorStatus.REPOSITORY_WITH_SAME_NAME_EXISTS_ALREADY;
        } else if (throwable instanceof InvalidSnapshotNameException) {
            httpErrorStatus = HttpErrorStatus.SNAPSHOT_WITH_SAME_NAME_EXISTS_ALREADY;
        } else if (throwable instanceof ElasticsearchException) {
            ElasticsearchException ex = (ElasticsearchException)throwable;
            httpErrorStatus = ex.httpErrorStatus();
        }
        return new HttpError(httpErrorStatus, SQLExceptions.messageOf(throwable), throwable);
    }
}

