/*
 * Decompiled with CFR 0.152.
 */
package io.crate.rest.action;

import io.crate.data.Row;
import io.crate.rest.action.ResultToXContentBuilder;
import io.crate.session.ResultReceiver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.jetbrains.annotations.Nullable;

class RestRowCountReceiver
implements ResultReceiver<XContentBuilder> {
    private final long startTimeNs;
    private final boolean includeTypes;
    private final ResultToXContentBuilder builder;
    private final CompletableFuture<XContentBuilder> result = new CompletableFuture();
    private long rowCount;

    RestRowCountReceiver(ByteBuf resultBuffer, long startTimeNs, boolean includeTypes) throws IOException {
        this.startTimeNs = startTimeNs;
        this.includeTypes = includeTypes;
        this.builder = ResultToXContentBuilder.builder(new XContentBuilder((XContent)JsonXContent.JSON_XCONTENT, (OutputStream)new ByteBufOutputStream(resultBuffer)));
    }

    @Override
    @Nullable
    public CompletableFuture<Void> setNextRow(Row row) {
        this.rowCount = (Long)row.get(0);
        return null;
    }

    @Override
    public void batchFinished() {
        this.fail(new IllegalStateException("Incremental result streaming not supported via HTTP"));
    }

    XContentBuilder finishBuilder() throws IOException {
        this.builder.cols(Collections.emptyList());
        if (this.includeTypes) {
            this.builder.colTypes(Collections.emptyList());
        }
        this.builder.startRows().addRow(Row.EMPTY, 0).finishRows().rowCount(this.rowCount).duration(this.startTimeNs);
        return this.builder.build();
    }

    @Override
    public void allFinished() {
        try {
            this.result.complete(this.finishBuilder());
        }
        catch (IOException e) {
            this.result.completeExceptionally(e);
        }
    }

    @Override
    public void fail(Throwable t) {
        this.result.completeExceptionally(t);
    }

    @Override
    public CompletableFuture<XContentBuilder> completionFuture() {
        return this.result;
    }
}

