/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.common.collections.Maps;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public record JwtProperties(String iss, String username, @Nullable String aud) implements Writeable
{
    public static JwtProperties readFrom(StreamInput in) throws IOException {
        return new JwtProperties(in.readString(), in.readString(), in.readOptionalString());
    }

    @Nullable
    public static JwtProperties fromMap(@Nullable Map<String, Object> jwtPropertiesMap) {
        if (jwtPropertiesMap != null && !jwtPropertiesMap.isEmpty()) {
            String iss = (String)Maps.get(jwtPropertiesMap, (String)"iss");
            JwtProperties.ensureNotNull("iss", iss);
            String username = (String)Maps.get(jwtPropertiesMap, (String)"username");
            JwtProperties.ensureNotNull("username", username);
            String aud = (String)Maps.get(jwtPropertiesMap, (String)"aud");
            if (jwtPropertiesMap.size() > 3 || jwtPropertiesMap.size() == 3 && aud == null) {
                throw new IllegalArgumentException("Only 'iss', 'username' and 'aud' JWT properties are allowed");
            }
            return new JwtProperties(iss, username, aud);
        }
        return null;
    }

    private static void ensureNotNull(String propertyName, @Nullable String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "JWT property '%s' must have a non-null value", propertyName));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.iss);
        out.writeString(this.username);
        out.writeOptionalString(this.aud);
    }

    public static JwtProperties fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token currentToken;
        String iss = null;
        String username = null;
        String aud = null;
        block10: while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (currentToken != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            currentToken = parser.nextToken();
            switch (currentFieldName) {
                case "iss": {
                    if (currentToken != XContentParser.Token.VALUE_STRING) {
                        throw new ElasticsearchParseException("failed to parse jwt, 'iss' value is not a string [{}]", currentToken);
                    }
                    iss = parser.text();
                    continue block10;
                }
                case "username": {
                    if (currentToken != XContentParser.Token.VALUE_STRING) {
                        throw new ElasticsearchParseException("failed to parse jwt, 'username' value is not a string [{}]", currentToken);
                    }
                    username = parser.text();
                    continue block10;
                }
                case "aud": {
                    if (currentToken != XContentParser.Token.VALUE_STRING) {
                        throw new ElasticsearchParseException("failed to parse jwt, 'aud' value is not a string [{}]", currentToken);
                    }
                    aud = parser.text();
                    continue block10;
                }
            }
            throw new ElasticsearchParseException("failed to parse jwt, unknown property '{}'", currentFieldName);
        }
        return new JwtProperties(iss, username, aud);
    }

    @Nullable
    public boolean match(@Nullable String iss, @Nullable String username) {
        return this.iss.equals(iss) && this.username.equals(username);
    }
}

