/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.role.Permission;
import io.crate.role.Policy;
import io.crate.role.Securable;
import io.crate.role.Subject;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

public class Privilege
implements Writeable {
    private final Policy policy;
    private final Subject subject;
    private final String grantor;

    public static Privilege fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token currentToken;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse privilege, expected a START_OBJECT token but got [{}]", parser.currentToken());
        }
        Policy policy = null;
        Permission permission = null;
        Securable securable = null;
        String ident = null;
        String grantor = null;
        block17: while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (currentToken != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            currentToken = parser.nextToken();
            switch (currentFieldName) {
                case "policy": 
                case "state": {
                    if (currentToken != XContentParser.Token.VALUE_NUMBER) {
                        throw new ElasticsearchParseException("failed to parse privilege, 'state' value is not a number [{}]", currentToken);
                    }
                    policy = Policy.VALUES.get(parser.intValue());
                    continue block17;
                }
                case "permission": 
                case "type": {
                    if (currentToken != XContentParser.Token.VALUE_NUMBER) {
                        throw new ElasticsearchParseException("failed to parse privilege, 'permission' value is not a number [{}]", currentToken);
                    }
                    permission = Permission.VALUES.get(parser.intValue());
                    continue block17;
                }
                case "securable": 
                case "class": {
                    if (currentToken != XContentParser.Token.VALUE_NUMBER) {
                        throw new ElasticsearchParseException("failed to parse privilege, 'securable' value is not a number [{}]", currentToken);
                    }
                    securable = Securable.VALUES.get(parser.intValue());
                    continue block17;
                }
                case "ident": {
                    if (currentToken != XContentParser.Token.VALUE_STRING && currentToken != XContentParser.Token.VALUE_NULL) {
                        throw new ElasticsearchParseException("failed to parse privilege, 'ident' value is not a string or null [{}]", currentToken);
                    }
                    ident = parser.textOrNull();
                    continue block17;
                }
                case "grantor": {
                    if (currentToken != XContentParser.Token.VALUE_STRING) {
                        throw new ElasticsearchParseException("failed to parse privilege, 'grantor' value is not a string [{}]", currentToken);
                    }
                    grantor = parser.text();
                    continue block17;
                }
            }
            throw new ElasticsearchParseException("failed to parse privilege", new Object[0]);
        }
        return new Privilege(policy, permission, securable, ident, grantor);
    }

    public Privilege(Policy policy, Permission permission, Securable securable, @Nullable String subject, String grantor) {
        this.policy = policy;
        this.subject = new Subject(permission, securable, subject);
        this.grantor = grantor;
    }

    public Privilege(StreamInput in) throws IOException {
        this.policy = Policy.VALUES.get(in.readInt());
        this.subject = new Subject(in);
        this.grantor = in.readString();
    }

    public Policy policy() {
        return this.policy;
    }

    public Subject subject() {
        return this.subject;
    }

    public String grantor() {
        return this.grantor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return this.policy == privilege.policy && Objects.equals(this.subject, privilege.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy, this.subject});
    }

    public String toString() {
        return "Privilege{policy=" + String.valueOf((Object)this.policy) + ", subject=" + String.valueOf(this.subject) + ", grantor=" + this.grantor + "}";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.policy.ordinal());
        this.subject.writeTo(out);
        out.writeString(this.grantor);
    }
}

