/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.auth.AccessControl;
import io.crate.auth.AccessControlImpl;
import io.crate.common.FourFunction;
import io.crate.exceptions.RoleUnknownException;
import io.crate.metadata.pgcatalog.OidHash;
import io.crate.role.Permission;
import io.crate.role.Policy;
import io.crate.role.Role;
import io.crate.role.Securable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public interface Roles {
    @Nullable
    default public Role findRole(String roleName) {
        for (Role role : this.roles()) {
            if (!role.name().equals(roleName)) continue;
            return role;
        }
        return null;
    }

    @Nullable
    default public Role findUser(String userName) {
        Role role = this.findRole(userName);
        if (role != null && role.isUser()) {
            return role;
        }
        return null;
    }

    default public Role getUser(String userName) {
        Role user = this.findUser(userName);
        if (user == null) {
            throw new RoleUnknownException(userName);
        }
        return user;
    }

    @Nullable
    default public Role findUser(Predicate<Role> predicate) {
        for (Role role : this.roles()) {
            if (!role.isUser() || !predicate.test(role)) continue;
            return role;
        }
        return null;
    }

    @Nullable
    default public Role findUser(int userOid) {
        for (Role role : this.roles()) {
            if (!role.isUser() || userOid != OidHash.userOid(role.name())) continue;
            return role;
        }
        return null;
    }

    default public boolean hasALPrivileges(Role role) {
        return this.hasPrivilege(role, Permission.AL, Securable.CLUSTER, null);
    }

    default public boolean hasPrivilege(Role user, Permission permission, Securable securable, @Nullable String ident) {
        return user.isSuperUser() || this.hasPrivilege(user, permission, securable, ident, (FourFunction<Role, Permission, Securable, Object, Policy>)((FourFunction)(r, t, c, o) -> r.privileges().matchPrivilege((Permission)((Object)t), (Securable)((Object)c), (String)o))) == Policy.GRANT;
    }

    default public boolean hasSchemaPrivilege(Role user, Permission permission, Integer schemaOid) {
        return user.isSuperUser() || this.hasPrivilege(user, permission, null, schemaOid, (FourFunction<Role, Permission, Securable, Object, Policy>)((FourFunction)(r, p, s, o) -> r.matchSchema((Permission)((Object)p), (Integer)o))) == Policy.GRANT;
    }

    default public boolean hasAnyPrivilege(Role user, Securable securable, @Nullable String ident) {
        return user.isSuperUser() || this.hasPrivilege(user, null, securable, ident, (FourFunction<Role, Permission, Securable, Object, Policy>)((FourFunction)(r, p, s, o) -> r.privileges().matchPrivilegeOfAnyType((Securable)((Object)s), (String)o))) == Policy.GRANT;
    }

    default public AccessControl getAccessControl(Role authenticatedUser, Role sessionUser) {
        return new AccessControlImpl(this, authenticatedUser, sessionUser);
    }

    public Collection<Role> roles();

    default public Set<String> findAllParents(String roleName) {
        HashSet<String> allParents = new HashSet<String>();
        Role role = this.findRole(roleName);
        if (!1.$assertionsDisabled && role == null) {
            throw new AssertionError((Object)"role must exist");
        }
        this.findParents(role, allParents);
        return allParents;
    }

    private void findParents(Role role, Set<String> allParents) {
        allParents.addAll(role.grantedRoleNames());
        for (String grantedRoleName : role.grantedRoleNames()) {
            Role parentRole = this.findRole(grantedRoleName);
            if (!1.$assertionsDisabled && parentRole == null) {
                throw new AssertionError((Object)"parent role must exist");
            }
            this.findParents(parentRole, allParents);
        }
    }

    private Policy hasPrivilege(Role role, Permission permission, @Nullable Securable securable, @Nullable Object object, FourFunction<Role, Permission, Securable, Object, Policy> function) {
        if (role.isSuperUser()) {
            return Policy.GRANT;
        }
        Policy resolution = (Policy)((Object)function.apply((Object)role, (Object)permission, (Object)securable, object));
        if (resolution == Policy.DENY || resolution == Policy.GRANT) {
            return resolution;
        }
        Policy result = Policy.REVOKE;
        for (String parentRoleName : role.grantedRoleNames()) {
            Role parentRole = this.findRole(parentRoleName);
            if (!1.$assertionsDisabled && parentRole == null) {
                throw new AssertionError((Object)"role must exist");
            }
            Policy partialResult = this.hasPrivilege(parentRole, permission, securable, object, function);
            if (partialResult == Policy.DENY) {
                return Policy.DENY;
            }
            if (result != Policy.REVOKE) continue;
            result = partialResult;
        }
        return result;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

