/*
 * Decompiled with CFR 0.152.
 */
package io.crate.role;

import io.crate.exceptions.RoleAlreadyExistsException;
import io.crate.role.CreateRoleRequest;
import io.crate.role.JwtProperties;
import io.crate.role.Role;
import io.crate.role.SecureHash;
import io.crate.role.WriteRoleResponse;
import io.crate.role.metadata.RolesMetadata;
import io.crate.role.metadata.UsersMetadata;
import io.crate.role.metadata.UsersPrivilegesMetadata;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportCreateRole
extends TransportMasterNodeAction<CreateRoleRequest, WriteRoleResponse> {
    public static final Action ACTION = new Action();

    @Inject
    public TransportCreateRole(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreateRoleRequest::new);
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected WriteRoleResponse read(StreamInput in) throws IOException {
        return new WriteRoleResponse(in);
    }

    @Override
    protected void masterOperation(final CreateRoleRequest request, ClusterState state, ActionListener<WriteRoleResponse> listener) throws Exception {
        if (!state.nodes().getMinNodeVersion().onOrAfter(Version.V_5_6_0)) {
            throw new IllegalStateException("Cannot create new users/roles until all nodes are upgraded to 5.6");
        }
        this.clusterService.submitStateUpdateTask("create_role [" + request.roleName() + "]", new AckedClusterStateUpdateTask<WriteRoleResponse>(this, Priority.IMMEDIATE, (AckedRequest)request, listener){
            private boolean alreadyExists;
            {
                super(priority, request2, listener);
                this.alreadyExists = false;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Metadata currentMetadata = currentState.metadata();
                Metadata.Builder mdBuilder = Metadata.builder(currentMetadata);
                this.alreadyExists = TransportCreateRole.putRole(mdBuilder, request.roleName(), request.isUser(), request.secureHash(), request.jwtProperties(), Map.of());
                return ClusterState.builder(currentState).metadata(mdBuilder).build();
            }

            @Override
            protected WriteRoleResponse newResponse(boolean acknowledged) {
                return new WriteRoleResponse(acknowledged, this.alreadyExists);
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(CreateRoleRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @VisibleForTesting
    static boolean putRole(Metadata.Builder mdBuilder, String roleName, boolean isUser, @Nullable SecureHash secureHash, @Nullable JwtProperties jwtProperties, Map<String, Object> sessionSettings) {
        RolesMetadata oldRolesMetadata = (RolesMetadata)mdBuilder.getCustom("roles");
        UsersMetadata oldUsersMetadata = (UsersMetadata)mdBuilder.getCustom("users");
        UsersPrivilegesMetadata oldUserPrivilegesMetadata = (UsersPrivilegesMetadata)mdBuilder.getCustom("users_privileges");
        RolesMetadata newMetadata = RolesMetadata.of(mdBuilder, oldUsersMetadata, oldUserPrivilegesMetadata, oldRolesMetadata);
        boolean exists = true;
        if (newMetadata.contains(jwtProperties)) {
            throw new RoleAlreadyExistsException("Another role with the same combination of iss/username jwt properties already exists");
        }
        if (!newMetadata.contains(roleName)) {
            newMetadata.roles().put(roleName, new Role(roleName, isUser, Set.of(), Set.of(), secureHash, jwtProperties, sessionSettings));
            exists = false;
        } else if (newMetadata.equals(oldRolesMetadata)) {
            return exists;
        }
        assert (!newMetadata.equals(oldRolesMetadata)) : "must not be equal to guarantee the cluster change action";
        mdBuilder.putCustom("roles", newMetadata);
        return exists;
    }

    public static class Action
    extends ActionType<WriteRoleResponse> {
        private static String NAME = "internal:crate:sql/user/create";

        private Action() {
            super(NAME);
        }
    }
}

