/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.data.Row;
import io.crate.session.ResultReceiver;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.jetbrains.annotations.Nullable;

public final class CollectingResultReceiver<A, R>
implements ResultReceiver<R> {
    private final BiConsumer<A, Row> accumulator;
    private final Function<A, R> finisher;
    private final CompletableFuture<R> result;
    private A state;

    public CollectingResultReceiver(Collector<Row, A, R> collector) {
        this.state = collector.supplier().get();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
        this.result = new CompletableFuture();
    }

    @Override
    public CompletableFuture<R> completionFuture() {
        return this.result;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> setNextRow(Row row) {
        this.accumulator.accept(this.state, row);
        return null;
    }

    @Override
    public void batchFinished() {
    }

    @Override
    public void allFinished() {
        this.result.complete(this.finisher.apply(this.state));
    }

    @Override
    public void fail(Throwable t) {
        this.result.completeExceptionally(t);
    }
}

