/*
 * Decompiled with CFR 0.152.
 */
package io.crate.session;

import io.crate.analyze.Analyzer;
import io.crate.common.unit.TimeValue;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.jobs.transport.CancelRequest;
import io.crate.execution.jobs.transport.TransportCancelAction;
import io.crate.metadata.NodeContext;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.settings.session.SessionSetting;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Planner;
import io.crate.planner.optimizer.LoadedRules;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.protocols.postgres.KeyData;
import io.crate.role.Role;
import io.crate.session.Cursor;
import io.crate.session.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.jetbrains.annotations.Nullable;

@Singleton
public class Sessions {
    public static final String MEMORY_LIMIT_KEY = "memory.operation_limit";
    public static final String NODE_READ_ONLY_SETTING_KEY = "node.sql.read_only";
    public static final String STATEMENT_TIMEOUT_KEY = "statement_timeout";
    public static final Setting<Boolean> NODE_READ_ONLY_SETTING = Setting.boolSetting("node.sql.read_only", false, Setting.Property.NodeScope);
    public static final Setting<TimeValue> STATEMENT_TIMEOUT = Setting.timeSetting("statement_timeout", TimeValue.timeValueMillis((long)0L), Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<Integer> STATEMENT_MAX_LENGTH = Setting.intSetting("statement_max_length", 262144, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<Integer> TEMP_ERROR_RETRY_COUNT = Setting.intSetting("node.sql.num_temp_error_retries", 3, Setting.Property.NodeScope);
    public static final Setting<Integer> MEMORY_LIMIT = Setting.intSetting("memory.operation_limit", 0, Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    private static final Logger LOGGER = LogManager.getLogger(Sessions.class);
    private final NodeContext nodeCtx;
    private final Analyzer analyzer;
    private final Planner planner;
    private final Provider<DependencyCarrier> executorProvider;
    private final JobsLogs jobsLogs;
    private final ClusterService clusterService;
    private final SessionSettingRegistry sessionSettingRegistry;
    private final boolean isReadOnly;
    private final AtomicInteger nextSessionId = new AtomicInteger();
    private final ConcurrentMap<Integer, Session> sessions = new ConcurrentHashMap<Integer, Session>();
    private final int tempErrorRetryCount;
    private final int statementMaxLength;
    private volatile boolean disabled;
    private volatile TimeValue defaultStatementTimeout;
    private volatile int memoryLimit;

    public Sessions(NodeContext nodeCtx, Analyzer analyzer, Planner planner, Provider<DependencyCarrier> executorProvider, JobsLogs jobsLogs, Settings settings, ClusterService clusterService, SessionSettingRegistry sessionSettingRegistry) {
        this.nodeCtx = nodeCtx;
        this.analyzer = analyzer;
        this.planner = planner;
        this.executorProvider = executorProvider;
        this.jobsLogs = jobsLogs;
        this.clusterService = clusterService;
        this.isReadOnly = NODE_READ_ONLY_SETTING.get(settings);
        this.defaultStatementTimeout = STATEMENT_TIMEOUT.get(settings);
        this.memoryLimit = MEMORY_LIMIT.get(settings);
        this.tempErrorRetryCount = TEMP_ERROR_RETRY_COUNT.get(settings);
        this.statementMaxLength = STATEMENT_MAX_LENGTH.get(settings);
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(STATEMENT_TIMEOUT, statementTimeout -> {
            this.defaultStatementTimeout = statementTimeout;
        });
        clusterSettings.addSettingsUpdateConsumer(MEMORY_LIMIT, newLimit -> {
            this.memoryLimit = newLimit;
        });
        this.sessionSettingRegistry = sessionSettingRegistry;
    }

    private Session newSession(@Nullable ConnectionProperties connectionProperties, CoordinatorSessionSettings sessionSettings) {
        if (this.disabled) {
            throw new NodeDisconnectedException(this.clusterService.localNode(), "sql");
        }
        int sessionId = this.nextSessionId.incrementAndGet();
        Session session = new Session(sessionId, connectionProperties, this.analyzer, this.planner, this.jobsLogs, this.isReadOnly, (DependencyCarrier)this.executorProvider.get(), sessionSettings, () -> this.sessions.remove(sessionId), this.tempErrorRetryCount, this.statementMaxLength);
        this.sessions.put(sessionId, session);
        return session;
    }

    public Session newSession(ConnectionProperties connectionProperties, @Nullable String defaultSchema, Role authenticatedUser) {
        CoordinatorSessionSettings sessionSettings = defaultSchema == null ? new CoordinatorSessionSettings(authenticatedUser, authenticatedUser, LoadedRules.INSTANCE.disabledRules(), new String[0]) : new CoordinatorSessionSettings(authenticatedUser, authenticatedUser, LoadedRules.INSTANCE.disabledRules(), defaultSchema);
        sessionSettings.statementTimeout(this.defaultStatementTimeout);
        sessionSettings.memoryLimit(this.memoryLimit);
        for (Map.Entry<String, Object> entry : authenticatedUser.sessionSettings().entrySet()) {
            SessionSetting<?> setting = this.sessionSettingRegistry.settings().get(entry.getKey());
            assert (setting != null) : "setting would be null only if it's been removed from the registry";
            setting.apply(sessionSettings, entry.getValue());
        }
        return this.newSession(connectionProperties, sessionSettings);
    }

    public Session newSystemSession() {
        return this.newSession(null, CoordinatorSessionSettings.systemDefaults());
    }

    public void disable() {
        this.disabled = true;
    }

    public void enable() {
        this.disabled = false;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public boolean cancelLocally(KeyData keyData) {
        Session session = (Session)this.sessions.get(keyData.pid());
        if (session != null && session.secret() == keyData.secretKey()) {
            session.cancelCurrentJob();
            return true;
        }
        return false;
    }

    public void cancel(KeyData keyData) {
        boolean cancelled = this.cancelLocally(keyData);
        if (!cancelled) {
            Client client = ((DependencyCarrier)this.executorProvider.get()).client();
            CancelRequest request = new CancelRequest(keyData);
            client.execute(TransportCancelAction.ACTION, request).whenComplete((acknowledgedResponse, err) -> {
                if (err != null) {
                    LOGGER.error("Error during cancel broadcast", err);
                }
            });
        }
    }

    public Iterable<Session> getActive() {
        return this.sessions.values();
    }

    public Iterable<Cursor> getCursors(Role user) {
        return () -> this.sessions.values().stream().filter(session -> this.nodeCtx.roles().hasALPrivileges(user) || session.sessionSettings().sessionUser().equals(user)).flatMap(session -> StreamSupport.stream(session.cursors.spliterator(), false)).iterator();
    }
}

