/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.Streamer;
import io.crate.statistics.MostCommonValues;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class ColumnStats<T>
implements Writeable {
    private final double nullFraction;
    private final double averageSizeInBytes;
    private final double approxDistinct;
    private final DataType<T> type;
    private final MostCommonValues<T> mostCommonValues;
    private final List<T> histogram;

    public ColumnStats(double nullFraction, double averageSizeInBytes, double approxDistinct, DataType<T> type, MostCommonValues<T> mostCommonValues, List<T> histogram) {
        this.nullFraction = nullFraction;
        this.averageSizeInBytes = averageSizeInBytes;
        this.approxDistinct = approxDistinct;
        this.type = type;
        this.mostCommonValues = mostCommonValues;
        this.histogram = histogram;
    }

    public ColumnStats(StreamInput in) throws IOException {
        this.type = DataTypes.fromStream(in);
        this.nullFraction = in.readDouble();
        this.averageSizeInBytes = in.readDouble();
        this.approxDistinct = in.readDouble();
        Streamer<T> streamer = this.type.streamer();
        this.mostCommonValues = new MostCommonValues<T>(streamer, in);
        int numHistogramValues = in.readVInt();
        ArrayList<T> histogram = new ArrayList<T>(numHistogramValues);
        for (int i = 0; i < numHistogramValues; ++i) {
            histogram.add(streamer.readValueFrom(in));
        }
        this.histogram = histogram;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Streamer<T> streamer = this.type.streamer();
        DataTypes.toStream(this.type, out);
        out.writeDouble(this.nullFraction);
        out.writeDouble(this.averageSizeInBytes);
        out.writeDouble(this.approxDistinct);
        this.mostCommonValues.writeTo(this.type.streamer(), out);
        out.writeVInt(this.histogram.size());
        for (T o : this.histogram) {
            streamer.writeValueTo(out, o);
        }
    }

    public DataType<T> type() {
        return this.type;
    }

    public double averageSizeInBytes() {
        return this.averageSizeInBytes;
    }

    public double nullFraction() {
        return this.nullFraction;
    }

    public double approxDistinct() {
        return this.approxDistinct;
    }

    public MostCommonValues<T> mostCommonValues() {
        return this.mostCommonValues;
    }

    public List<T> histogram() {
        return this.histogram;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStats that = (ColumnStats)o;
        if (Double.compare(that.nullFraction, this.nullFraction) != 0) {
            return false;
        }
        if (Double.compare(that.averageSizeInBytes, this.averageSizeInBytes) != 0) {
            return false;
        }
        if (Double.compare(that.approxDistinct, this.approxDistinct) != 0) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.mostCommonValues.equals(that.mostCommonValues)) {
            return false;
        }
        return this.histogram.equals(that.histogram);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.nullFraction);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.averageSizeInBytes);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.approxDistinct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.mostCommonValues.hashCode();
        result = 31 * result + this.histogram.hashCode();
        return result;
    }

    public String toString() {
        return "ColumnStats{nullFraction=" + this.nullFraction + ", approxDistinct=" + this.approxDistinct + ", mcv=" + this.mostCommonValues.values().toString() + ", frequencies=" + Arrays.toString(this.mostCommonValues.frequencies()) + "}";
    }
}

