/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.metadata.RelationName;
import io.crate.statistics.Stats;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public final class PublishTableStatsRequest
extends TransportRequest {
    private final Map<RelationName, Stats> statsByRelation;

    public PublishTableStatsRequest(Map<RelationName, Stats> statsByRelation) {
        this.statsByRelation = statsByRelation;
    }

    public PublishTableStatsRequest(StreamInput in) throws IOException {
        int numRelations = in.readVInt();
        this.statsByRelation = HashMap.newHashMap(numRelations);
        for (int i = 0; i < numRelations; ++i) {
            this.statsByRelation.put(new RelationName(in), Stats.readFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.statsByRelation.size());
        for (Map.Entry<RelationName, Stats> entry : this.statsByRelation.entrySet()) {
            entry.getKey().writeTo(out);
            entry.getValue().writeTo(out);
        }
    }

    public Map<RelationName, Stats> tableStats() {
        return this.statsByRelation;
    }
}

