/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.common.collections.Maps;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.statistics.ColumnStats;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public record Stats(long numDocs, long sizeInBytes, Map<ColumnIdent, ColumnStats<?>> statsByColumn) implements Writeable
{
    public static final Stats EMPTY = new Stats(-1L, -1L, Map.of());

    public static Stats readFrom(StreamInput in) throws IOException {
        long numDocs = in.readLong();
        long sizeInBytes = in.readLong();
        int numColumnStats = in.readVInt();
        HashMap<ColumnIdent, ColumnStats<?>> statsByColumn = HashMap.newHashMap(numColumnStats);
        for (int i = 0; i < numColumnStats; ++i) {
            statsByColumn.put(ColumnIdent.of(in), new ColumnStats(in));
        }
        return new Stats(numDocs, sizeInBytes, statsByColumn);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.numDocs);
        out.writeLong(this.sizeInBytes);
        out.writeVInt(this.statsByColumn.size());
        for (Map.Entry<ColumnIdent, ColumnStats<?>> entry : this.statsByColumn.entrySet()) {
            entry.getKey().writeTo(out);
            entry.getValue().writeTo(out);
        }
    }

    public boolean isEmpty() {
        return this.numDocs == -1L && this.sizeInBytes == -1L && this.statsByColumn.isEmpty();
    }

    public Stats withNumDocs(long numDocs) {
        long sizePerRow = this.averageSizePerRowInBytes();
        if (sizePerRow < 1L) {
            return new Stats(numDocs, -1L, this.statsByColumn);
        }
        return new Stats(numDocs, sizePerRow * numDocs, this.statsByColumn);
    }

    public Stats add(Stats other) {
        return new Stats(this.numDocs == -1L || other.numDocs == -1L ? -1L : this.numDocs + other.numDocs, this.sizeInBytes == -1L || other.sizeInBytes == -1L ? -1L : this.sizeInBytes + other.sizeInBytes, Maps.concat(this.statsByColumn, other.statsByColumn));
    }

    public long averageSizePerRowInBytes() {
        if (this.numDocs == -1L) {
            return -1L;
        }
        if (this.numDocs == 0L) {
            return 0L;
        }
        return this.sizeInBytes / this.numDocs;
    }

    @Nullable
    public ColumnStats<?> getColumnStats(ColumnIdent column) {
        return this.statsByColumn.get(column);
    }

    /*
     * WARNING - void declaration
     */
    public long estimateSizeForColumns(Iterable<? extends Symbol> toCollect) {
        long sum = 0L;
        for (Symbol symbol : toCollect) {
            void var5_4;
            ColumnStats<?> columnStats = null;
            while (var5_4 instanceof AliasSymbol) {
                AliasSymbol alias = (AliasSymbol)var5_4;
                Symbol symbol2 = alias.symbol();
            }
            if (var5_4 instanceof Reference) {
                Reference ref = (Reference)var5_4;
                columnStats = this.statsByColumn.get(ref.column());
            } else if (var5_4 instanceof ScopedSymbol) {
                ScopedSymbol scopedSymbol = (ScopedSymbol)var5_4;
                columnStats = this.statsByColumn.get(scopedSymbol.column());
            }
            if (columnStats == null) {
                DataType<?> dataType = var5_4.valueType();
                if (dataType instanceof FixedWidthType) {
                    FixedWidthType fixedWidthType = (FixedWidthType)((Object)dataType);
                    sum += (long)fixedWidthType.fixedSize();
                    continue;
                }
                sum += 256L;
                continue;
            }
            sum += (long)columnStats.averageSizeInBytes();
        }
        return sum;
    }
}

