/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import io.crate.common.collections.Iterables;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.TableInfo;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.ColumnStatsEntry;
import io.crate.statistics.Stats;
import java.util.function.Function;
import java.util.stream.Stream;

public class TableStats {
    private volatile Function<RelationName, Stats> tableStats = x -> null;

    public void updateTableStats(Function<RelationName, Stats> tableStats) {
        this.tableStats = tableStats;
    }

    public long numDocs(RelationName relationName) {
        return this.getStats(relationName).numDocs();
    }

    public long estimatedSizePerRow(RelationName relationName) {
        return this.getStats(relationName).averageSizePerRowInBytes();
    }

    public long estimatedSizePerRow(TableInfo tableInfo) {
        Stats stats = this.tableStats.apply(tableInfo.ident());
        if (stats == null) {
            return Stats.EMPTY.estimateSizeForColumns(tableInfo);
        }
        return stats.averageSizePerRowInBytes();
    }

    public Iterable<ColumnStatsEntry> statsEntries(Iterable<RelationName> relationNames) {
        return () -> Iterables.sequentialStream((Iterable)relationNames).flatMap(relationName -> {
            Stats stats = this.getStats((RelationName)relationName);
            if (stats == Stats.EMPTY) {
                return Stream.empty();
            }
            return stats.statsByColumn().entrySet().stream().map(columnEntry -> new ColumnStatsEntry((RelationName)relationName, (ColumnIdent)columnEntry.getKey(), (ColumnStats)columnEntry.getValue()));
        }).iterator();
    }

    public Stats getStats(RelationName relationName) {
        Stats stats = this.tableStats.apply(relationName);
        return stats == null ? Stats.EMPTY : stats;
    }
}

