/*
 * Decompiled with CFR 0.152.
 */
package io.crate.statistics;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.crate.Streamer;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.crate.data.Row;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.session.BaseResultReceiver;
import io.crate.session.Session;
import io.crate.session.Sessions;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.MostCommonValues;
import io.crate.statistics.Stats;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class TableStatsService
extends AbstractLifecycleComponent
implements Runnable,
ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(TableStatsService.class);
    public static final Setting<TimeValue> STATS_SERVICE_REFRESH_INTERVAL_SETTING = Setting.timeSetting("stats.service.interval", TimeValue.timeValueHours((long)24L), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    public static final Setting<ByteSizeValue> STATS_SERVICE_THROTTLING_SETTING = Setting.byteSizeSetting("stats.service.max_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Exposed);
    static final String STMT = "ANALYZE";
    private static final String TABLES_STATS = "_stats_tables";
    private static final String COLS_STATS = "_stats_cols";
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Sessions sessions;
    private final Directory tablesDirectory;
    private final Directory colsDirectory;
    private final IndexWriter tablesWriter;
    private final IndexWriter colsWriter;
    private final SearcherManager tablesSearcherManager;
    private final SearcherManager colsSearcherManager;
    private final LoadingCache<RelationName, Stats> cache;
    private Session session;
    @VisibleForTesting
    volatile TimeValue refreshInterval;
    @VisibleForTesting
    volatile Scheduler.ScheduledCancellable scheduledRefresh;

    public TableStatsService(Settings settings, ThreadPool threadPool, ClusterService clusterService, Sessions sessions, Path dataPath) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.sessions = sessions;
        this.refreshInterval = STATS_SERVICE_REFRESH_INTERVAL_SETTING.get(settings);
        this.scheduledRefresh = this.scheduleNextRefresh(this.refreshInterval);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(STATS_SERVICE_REFRESH_INTERVAL_SETTING, this::setRefreshInterval);
        this.cache = Caffeine.newBuilder().executor((Executor)threadPool.generic()).maximumWeight(10000L).weigher((relationName, s) -> s.statsByColumn().size()).build(this::loadFromDisk);
        try {
            this.tablesDirectory = MMapDirectory.open((Path)dataPath.resolve(TABLES_STATS));
            this.colsDirectory = MMapDirectory.open((Path)dataPath.resolve(COLS_STATS));
            IndexWriterConfig tablesIndexWriterConfig = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
            tablesIndexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            tablesIndexWriterConfig.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
            IndexWriterConfig colsIndexWriterConfig = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
            colsIndexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            colsIndexWriterConfig.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
            this.tablesWriter = new IndexWriter(this.tablesDirectory, tablesIndexWriterConfig);
            this.tablesSearcherManager = new SearcherManager(this.tablesWriter, null);
            this.colsWriter = new IndexWriter(this.colsDirectory, colsIndexWriterConfig);
            this.colsSearcherManager = new SearcherManager(this.colsWriter, null);
            this.update(Map.of());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() throws IOException {
        this.cache.invalidateAll();
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.tablesSearcherManager, this.colsSearcherManager, this.tablesWriter, this.colsWriter, this.tablesDirectory, this.colsDirectory});
    }

    @Override
    public void run() {
        this.updateStats();
    }

    public void updateStats() {
        if (this.clusterService.localNode() == null) {
            LOGGER.debug("Could not retrieve table stats. localNode is not fully available yet.");
            return;
        }
        if (this.clusterService.state().nodes().getMinNodeVersion().before(Version.V_5_7_0)) {
            LOGGER.debug("Could not retrieve table stats.  Cluster not fully updated yet");
            return;
        }
        if (!this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        try {
            BaseResultReceiver resultReceiver = new BaseResultReceiver();
            resultReceiver.completionFuture().whenComplete((void_, err) -> {
                this.scheduledRefresh = this.scheduleNextRefresh(this.refreshInterval);
                if (err != null) {
                    LOGGER.error("Error running periodic ANALYZE", err);
                }
            });
            if (this.session == null) {
                this.session = this.sessions.newSystemSession();
            }
            this.session.quickExec(STMT, resultReceiver, Row.EMPTY);
        }
        catch (Throwable t) {
            LOGGER.error("error retrieving table stats", t);
        }
    }

    @Nullable
    private Scheduler.ScheduledCancellable scheduleNextRefresh(TimeValue refreshInterval) {
        if (refreshInterval.millis() > 0L) {
            return this.threadPool.schedule(this, refreshInterval, "refresh");
        }
        return null;
    }

    private void setRefreshInterval(TimeValue newRefreshInterval) {
        if (this.scheduledRefresh != null) {
            this.scheduledRefresh.cancel();
            this.scheduledRefresh = null;
        }
        this.refreshInterval = newRefreshInterval;
        this.scheduledRefresh = this.scheduleNextRefresh(newRefreshInterval);
    }

    @Nullable
    public Stats get(RelationName relationName) {
        return (Stats)this.cache.get((Object)relationName);
    }

    public void remove(RelationName relationName) {
        try {
            String relNameFqn = relationName.fqn();
            this.tablesWriter.deleteDocuments(new Term[]{new Term("relation", relNameFqn)});
            this.colsWriter.deleteDocuments(new Term[]{new Term("relation", relNameFqn)});
            this.tablesWriter.commit();
            this.colsWriter.commit();
            this.cache.invalidate((Object)relationName);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't delete TableStats from disk", e);
        }
    }

    public void clear() {
        try {
            this.tablesWriter.deleteAll();
            this.colsWriter.deleteAll();
            this.tablesWriter.commit();
            this.colsWriter.commit();
            this.cache.invalidateAll();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't delete TableStats from disk", e);
        }
    }

    /*
     * Loose catch block
     */
    @VisibleForTesting
    @Nullable
    Stats loadFromDisk(RelationName relationName) {
        TopDocs versionTopDoc;
        IndexReader reader;
        Weight weight;
        boolean match;
        IndexSearcher searcher;
        long sizeInBytes;
        long numDocs;
        HashMap columnStatsMap;
        String relNameFqn;
        block14: {
            relNameFqn = relationName.fqn();
            columnStatsMap = new HashMap();
            numDocs = 0L;
            sizeInBytes = 0L;
            searcher = null;
            match = false;
            this.tablesSearcherManager.maybeRefreshBlocking();
            searcher = (IndexSearcher)this.tablesSearcherManager.acquire();
            searcher.setQueryCache(null);
            TermQuery query = new TermQuery(new Term("relation", relNameFqn));
            weight = searcher.createWeight((Query)query, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
            reader = searcher.getIndexReader();
            versionTopDoc = searcher.search((Query)new FieldExistsQuery("version"), 1);
            if (versionTopDoc.totalHits.value() == 1L) break block14;
            Stats stats = null;
            try {
                this.tablesSearcherManager.release((Object)searcher);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Can't load TableStats from disk", ex);
            }
            return stats;
        }
        int versionDocId = versionTopDoc.scoreDocs[0].doc;
        Document versionDoc = reader.storedFields().document(versionDocId);
        int internalVersion = versionDoc.getField("version").storedValue().getIntValue();
        Version version = Version.fromId(internalVersion);
        for (LeafReaderContext leafReaderContext : reader.leaves()) {
            Scorer scorer = weight.scorer(leafReaderContext);
            if (scorer == null) continue;
            DocIdSetIterator docIdSetIterator = scorer.iterator();
            StoredFields storedFields = leafReaderContext.reader().storedFields();
            while (docIdSetIterator.nextDoc() != Integer.MAX_VALUE) {
                match = true;
                Document doc = storedFields.document(docIdSetIterator.docID());
                numDocs = doc.getField("numDocs").storedValue().getLongValue();
                sizeInBytes = doc.getField("size").storedValue().getLongValue();
            }
            this.loadColStatsFromDisk(relNameFqn, columnStatsMap, version);
        }
        try {
            this.tablesSearcherManager.release((Object)searcher);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Can't load TableStats from disk", ex);
        }
        catch (IOException ex) {
            try {
                throw new UncheckedIOException("Can't load TableStats from disk", ex);
            }
            catch (Throwable throwable) {
                try {
                    this.tablesSearcherManager.release(searcher);
                }
                catch (IOException ex2) {
                    throw new UncheckedIOException("Can't load TableStats from disk", ex2);
                }
                throw throwable;
            }
        }
        if (!match) {
            return null;
        }
        return new Stats(numDocs, sizeInBytes, columnStatsMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadColStatsFromDisk(String relNameFqn, Map<ColumnIdent, ColumnStats<?>> columnStatsMap, Version version) {
        IndexSearcher searcher = null;
        try {
            this.colsSearcherManager.maybeRefreshBlocking();
            searcher = (IndexSearcher)this.colsSearcherManager.acquire();
            searcher.setQueryCache(null);
            TermQuery query = new TermQuery(new Term("relation", relNameFqn));
            Weight weight = searcher.createWeight((Query)query, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
            IndexReader reader = searcher.getIndexReader();
            for (LeafReaderContext leafReaderContext : reader.leaves()) {
                Scorer scorer = weight.scorer(leafReaderContext);
                if (scorer == null) continue;
                DocIdSetIterator docIdSetIterator = scorer.iterator();
                StoredFields storedFields = leafReaderContext.reader().storedFields();
                while (docIdSetIterator.nextDoc() != Integer.MAX_VALUE) {
                    Document doc = storedFields.document(docIdSetIterator.docID());
                    String columnName = doc.getField("column").stringValue();
                    ColumnIdent column = ColumnIdent.of(columnName);
                    DataType valueType = TableStatsService.decode(version, DataTypes::fromStream, doc.getBinaryValue("valueType"));
                    columnStatsMap.put(column, TableStatsService.readColumnStats(version, doc, valueType));
                }
            }
        }
        catch (IOException ex) {
            try {
                throw new UncheckedIOException("Can't load TableStats from disk", ex);
            }
            catch (Throwable throwable) {
                try {
                    this.colsSearcherManager.release(searcher);
                    throw throwable;
                }
                catch (IOException ex2) {
                    throw new UncheckedIOException("Can't load TableStats from disk", ex2);
                }
            }
        }
        try {
            this.colsSearcherManager.release((Object)searcher);
            return;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Can't load TableStats from disk", ex);
        }
    }

    private static <T> ColumnStats<T> readColumnStats(Version version, Document doc, DataType<T> type) throws IOException {
        double nullFraction = doc.getField("nullFraction").storedValue().getDoubleValue();
        double avgSizeInBytes = doc.getField("avgSize").storedValue().getDoubleValue();
        double approxDistinct = doc.getField("approxDistinct").storedValue().getDoubleValue();
        Streamer streamer = type.streamer();
        MostCommonValues mostCommonValues = TableStatsService.decode(version, in -> new MostCommonValues(streamer, in), doc.getBinaryValue("mcv"));
        List histogram = TableStatsService.decode(version, in -> in.readList(streamer::readValueFrom), doc.getBinaryValue("histogram"));
        return new ColumnStats<T>(nullFraction, avgSizeInBytes, approxDistinct, type, mostCommonValues, histogram);
    }

    public void update(Map<RelationName, Stats> relationsStats) {
        try {
            this.tablesWriter.deleteAll();
            this.colsWriter.deleteAll();
            Document metaDoc = new Document();
            metaDoc.add((IndexableField)new IntField("version", Version.CURRENT.internalId, Field.Store.YES));
            this.tablesWriter.addDocument((Iterable)metaDoc);
            for (Map.Entry<RelationName, Stats> entry : relationsStats.entrySet()) {
                RelationName relationName = entry.getKey();
                Stats stats = entry.getValue();
                Document tableDoc = new Document();
                String fqTableName = relationName.fqn();
                tableDoc.add((IndexableField)new StringField("relation", fqTableName, Field.Store.NO));
                tableDoc.add((IndexableField)new StoredField("numDocs", stats.numDocs()));
                tableDoc.add((IndexableField)new StoredField("size", stats.sizeInBytes()));
                this.tablesWriter.addDocument((Iterable)tableDoc);
                for (Map.Entry<ColumnIdent, ColumnStats<?>> columnEntry : stats.statsByColumn().entrySet()) {
                    ColumnIdent column = columnEntry.getKey();
                    ColumnStats<?> columnStats = columnEntry.getValue();
                    this.colsWriter.addDocument((Iterable)TableStatsService.createColDoc(fqTableName, column, columnStats));
                }
            }
            this.tablesWriter.commit();
            this.colsWriter.commit();
            this.tablesSearcherManager.maybeRefresh();
            this.colsSearcherManager.maybeRefresh();
            this.cache.invalidateAll(relationsStats.keySet());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Can't write TableStats to disk", e);
        }
    }

    private static <T> Document createColDoc(String fqTableName, ColumnIdent column, ColumnStats<T> columnStats) throws IOException {
        String sqlFqn = column.sqlFqn();
        Document colDoc = new Document();
        colDoc.add((IndexableField)new StringField("relation", fqTableName, Field.Store.YES));
        colDoc.add((IndexableField)new StringField("column", sqlFqn, Field.Store.YES));
        colDoc.add((IndexableField)new StoredField("nullFraction", columnStats.nullFraction()));
        colDoc.add((IndexableField)new StoredField("avgSize", columnStats.averageSizeInBytes()));
        colDoc.add((IndexableField)new StoredField("approxDistinct", columnStats.approxDistinct()));
        Streamer<T> streamer = columnStats.type().streamer();
        try (BytesStreamOutput out = new BytesStreamOutput();){
            DataTypes.toStream(columnStats.type(), (StreamOutput)out);
            colDoc.add((IndexableField)new StoredField("valueType", out.bytes().toBytesRef()));
        }
        out = new BytesStreamOutput();
        try {
            columnStats.mostCommonValues().writeTo(streamer, out);
            BytesRef bytesRef = out.bytes().toBytesRef();
            colDoc.add((IndexableField)new StoredField("mcv", bytesRef));
        }
        finally {
            out.close();
        }
        out = new BytesStreamOutput();
        try {
            List<T> histogram = columnStats.histogram();
            out.writeVInt(histogram.size());
            for (T value : histogram) {
                streamer.writeValueTo(out, value);
            }
            BytesRef bytesRef = out.bytes().toBytesRef();
            colDoc.add((IndexableField)new StoredField("histogram", bytesRef));
        }
        finally {
            out.close();
        }
        return colDoc;
    }

    private static <T> T decode(Version version, Writeable.Reader<T> reader, BytesRef bytesRef) throws IOException {
        try (StreamInput in = StreamInput.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length);){
            in.setVersion(version);
            T t = reader.read(in);
            return t;
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.metadataChanged() || event.isNewCluster()) {
            return;
        }
        Metadata oldMetadata = event.previousState().metadata();
        Metadata newMetadata = event.state().metadata();
        for (RelationMetadata oldRelation : oldMetadata.relations(RelationMetadata.class)) {
            RelationName name = oldRelation.name();
            if (newMetadata.contains(name)) continue;
            this.remove(name);
        }
    }

    private static class TableDocFields {
        static final String NAME = "relation";
        static final String NUM_DOCS = "numDocs";
        static final String SIZE_IN_BYTES = "size";

        private TableDocFields() {
        }
    }

    private static class ColumnDocFields {
        private static final String REL_NAME = "relation";
        private static final String COLUMN = "column";
        private static final String VALUE_TYPE = "valueType";
        private static final String NULL_FRACTION = "nullFraction";
        private static final String AVG_SIZE_IN_BYTES = "avgSize";
        private static final String APPROX_DISTINCT = "approxDistinct";
        private static final String MOST_COMMON_VALUES = "mcv";
        private static final String HISTOGRAM = "histogram";

        private ColumnDocFields() {
        }
    }

    private static class MetaDocFields {
        static final String VERSION = "version";

        private MetaDocFields() {
        }
    }
}

