/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.common.collections.Lists;
import io.crate.exceptions.ConversionException;
import io.crate.execution.dml.ObjectIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.SessionSettings;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.MapComparator;
import io.crate.types.ParameterTypeSignature;
import io.crate.types.StorageSupport;
import io.crate.types.StringType;
import io.crate.types.TypeSignature;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.jetbrains.annotations.Nullable;

public class ObjectType
extends DataType<Map<String, Object>>
implements Streamer<Map<String, Object>> {
    public static final ObjectType UNTYPED = new ObjectType(Map.of(), ColumnPolicy.DYNAMIC);
    public static final int ID = 12;
    public static final String NAME = "object";
    private static final StorageSupport<Map<String, Object>> STORAGE = new StorageSupport<Map<String, Object>>(false, false, null){

        @Override
        public ValueIndexer<Map<String, Object>> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new ObjectIndexer(table, ref, getRef);
        }

        @Override
        public Map<String, Object> decode(ColumnIdent column, SourceParser sourceParser, Version tableVersion, byte[] bytes) {
            Map<String, Object> map;
            ByteBufferStreamInput in = new ByteBufferStreamInput(ByteBuffer.wrap(bytes));
            try {
                in.setVersion(tableVersion);
                map = in.readMap(StreamInput::readString, StreamInput::readGenericValue);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((StreamInput)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((StreamInput)in).close();
            return map;
        }
    };
    private final Map<String, DataType<?>> innerTypes;
    private final ColumnPolicy columnPolicy;

    public static Builder of(ColumnPolicy columnPolicy) {
        return new Builder(columnPolicy, new LinkedHashMap());
    }

    public static Builder of(ColumnPolicy columnPolicy, int numMappings) {
        return new Builder(columnPolicy, LinkedHashMap.newLinkedHashMap(numMappings));
    }

    private ObjectType(Map<String, DataType<?>> innerTypes, ColumnPolicy columnPolicy) {
        this.innerTypes = innerTypes;
        this.columnPolicy = Objects.requireNonNull(columnPolicy);
    }

    public Map<String, DataType<?>> innerTypes() {
        return this.innerTypes;
    }

    public DataType<?> innerType(String key) {
        return this.innerTypes.getOrDefault(key, UndefinedType.INSTANCE);
    }

    public DataType<?> innerType(List<String> path) {
        int i;
        if (path.isEmpty()) {
            return DataTypes.UNDEFINED;
        }
        DataType innerType = DataTypes.UNDEFINED;
        ObjectType currentObject = this;
        int arrayNesting = 0;
        for (i = 0; i < path.size(); ++i) {
            innerType = currentObject.innerType(path.get(i));
            while (innerType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)innerType;
                ++arrayNesting;
                innerType = arrayType.innerType();
            }
            if (innerType instanceof ObjectType) {
                ObjectType objectType;
                currentObject = objectType = (ObjectType)innerType;
                continue;
            }
            if (i >= path.size() - 1) continue;
            return DataTypes.UNDEFINED;
        }
        for (i = 0; i < arrayNesting; ++i) {
            innerType = new ArrayType<Object>(innerType);
        }
        return innerType;
    }

    @Override
    public int id() {
        return 12;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.OBJECT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Streamer<Map<String, Object>> streamer() {
        return this;
    }

    @Override
    public Map<String, Object> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.convert(value, DataType::implicitCast);
    }

    @Override
    public Map<String, Object> explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        return this.convert(value, (dataType, val) -> dataType.explicitCast(val, sessionSettings));
    }

    @Override
    public Map<String, Object> sanitizeValue(Object value) {
        return this.convert(value, DataType::sanitizeValue);
    }

    @Override
    public Map<String, Object> sanitizeValueLenient(Object value) {
        try {
            return this.convert(value, DataType::sanitizeValueLenient);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Map<String, Object> valueForInsert(Map<String, Object> value) {
        return this.convert(value, (dataType, v) -> dataType.valueForInsert(v));
    }

    private Map<String, Object> convert(Object value, BiFunction<DataType<?>, Object, Object> innerType) {
        Map map;
        if (value instanceof String) {
            String str = (String)((Object)value);
            value = ObjectType.mapFromJSON(str);
        }
        if ((map = (Map)value) == null || this.innerTypes == null) {
            return map;
        }
        LinkedHashMap<String, Object> newMap = map instanceof LinkedHashMap ? new LinkedHashMap(map) : new HashMap(map);
        for (Map.Entry entry : map.entrySet()) {
            Object convertedInnerValue;
            String key = (String)entry.getKey();
            DataType<?> targetType = this.innerType(key);
            Object sourceValue = entry.getValue();
            try {
                convertedInnerValue = innerType.apply(targetType, sourceValue);
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw ConversionException.forObjectChild(key, sourceValue, targetType);
            }
            newMap.put(key, convertedInnerValue);
        }
        return newMap;
    }

    private static Map<String, Object> mapFromJSON(String value) {
        try {
            XContentParser parser = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, value);
            return parser.map();
        }
        catch (IOException e) {
            ConversionException conversionException = new ConversionException((Object)value, UNTYPED);
            conversionException.addSuppressed(e);
            throw conversionException;
        }
    }

    @Override
    public int compare(Map<String, Object> val1, Map<String, Object> val2) {
        return MapComparator.compareMaps(val1, val2);
    }

    @Override
    public Map<String, Object> readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            int size = in.readInt();
            LinkedHashMap<String, Object> m = LinkedHashMap.newLinkedHashMap(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                DataType<?> innerType = this.innerType(key);
                Object val = innerType.streamer().readValueFrom(in);
                m.put(key, val);
            }
            return m;
        }
        return null;
    }

    @Override
    public boolean isConvertableTo(DataType<?> o, boolean explicitCast) {
        Set conversions = DataTypes.ALLOWED_CONVERSIONS.getOrDefault(this.id(), Set.of());
        if (conversions.contains(o.id())) {
            return true;
        }
        if (explicitCast && o.id() == DataTypes.STRING.id()) {
            return true;
        }
        if (ArrayType.unnest(o) == DataTypes.UNDEFINED) {
            return true;
        }
        return o.id() == this.id();
    }

    @Override
    DataType<?> merge(DataType<?> other, ColumnPolicy columnPolicy) {
        if (other instanceof ObjectType) {
            ObjectType o = (ObjectType)other;
            return ObjectType.merge(this, o, DataTypes::merge, columnPolicy);
        }
        return super.merge(other, columnPolicy);
    }

    public static ObjectType merge(ObjectType left, ObjectType right, BiFunction<DataType<?>, DataType<?>, DataType<?>> remappingFunction, ColumnPolicy columnPolicy) {
        Builder mergedObjectBuilder = ObjectType.of(columnPolicy);
        for (Map.Entry<String, DataType<?>> e : left.innerTypes().entrySet()) {
            mergedObjectBuilder.setInnerType(e.getKey(), e.getValue().withColumnPolicy(columnPolicy));
        }
        for (Map.Entry<String, DataType<?>> e : right.innerTypes().entrySet()) {
            mergedObjectBuilder.mergeInnerType(e.getKey(), e.getValue(), remappingFunction);
        }
        return mergedObjectBuilder.build();
    }

    public ObjectType withoutChild(String childColumn) {
        LinkedHashMap newInnerTypes = new LinkedHashMap(this.innerTypes);
        newInnerTypes.remove(childColumn);
        return new ObjectType(Collections.unmodifiableMap(newInnerTypes), this.columnPolicy);
    }

    public ObjectType withChild(String childColumn, DataType<?> type) {
        LinkedHashMap newInnerTypes = new LinkedHashMap(this.innerTypes);
        newInnerTypes.put(childColumn, type);
        return new ObjectType(Collections.unmodifiableMap(newInnerTypes), this.columnPolicy);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        if (!Objects.equals(this.innerTypes, that.innerTypes)) {
            return false;
        }
        return this.columnPolicy == that.columnPolicy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.innerTypes.hashCode();
        return 31 * result + this.columnPolicy.hashCode();
    }

    @Override
    public void writeValueTo(StreamOutput out, Map<String, Object> v) throws IOException {
        if (v == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(v.size());
            for (Map.Entry<String, Object> entry : v.entrySet()) {
                String key = entry.getKey();
                out.writeString(key);
                DataType innerType = this.innerTypes.getOrDefault(key, UndefinedType.INSTANCE);
                innerType.streamer().writeValueTo(out, innerType.implicitCast(entry.getValue()));
            }
        }
    }

    public ObjectType(StreamInput in) throws IOException {
        int numTypes = in.readVInt();
        LinkedHashMap<String, DataType<?>> builder = LinkedHashMap.newLinkedHashMap(numTypes);
        for (int i = 0; i < numTypes; ++i) {
            String key = in.readString();
            DataType<?> type = DataTypes.fromStream(in);
            builder.put(key, type);
        }
        this.innerTypes = Collections.unmodifiableMap(builder);
        this.columnPolicy = in.getVersion().onOrAfter(Version.V_5_10_0) ? in.readEnum(ColumnPolicy.class) : ColumnPolicy.DYNAMIC;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.innerTypes.size());
        for (Map.Entry<String, DataType<?>> entry : this.innerTypes.entrySet()) {
            out.writeString(entry.getKey());
            DataTypes.toStream(entry.getValue(), out);
        }
        if (out.getVersion().onOrAfter(Version.V_5_10_0)) {
            out.writeEnum(this.columnPolicy);
        }
    }

    @Override
    public TypeSignature getTypeSignature() {
        TypeSignature stringTypeSignature = StringType.INSTANCE.getTypeSignature();
        ArrayList<TypeSignature> parameters = new ArrayList<TypeSignature>(this.innerTypes.size() * 2);
        for (Map.Entry<String, DataType<?>> innerTypeKeyValue : this.innerTypes.entrySet()) {
            parameters.add(stringTypeSignature);
            DataType<?> innerType = innerTypeKeyValue.getValue();
            parameters.add(new ParameterTypeSignature(innerTypeKeyValue.getKey(), innerType.getTypeSignature()));
        }
        return new TypeSignature(NAME, parameters);
    }

    @Override
    public List<DataType<?>> getTypeParameters() {
        ArrayList parameters = new ArrayList(this.innerTypes.size() * 2);
        for (DataType<?> type : this.innerTypes.values()) {
            parameters.add(StringType.INSTANCE);
            parameters.add(type);
        }
        return parameters;
    }

    @Override
    public ColumnType<Expression> toColumnType(@Nullable Supplier<List<ColumnDefinition<Expression>>> convertChildColumn) {
        if (convertChildColumn == null) {
            return new ObjectColumnType(this.columnPolicy, Lists.map(this.innerTypes.entrySet(), e -> new ColumnDefinition((String)e.getKey(), ((DataType)e.getValue()).toColumnType(convertChildColumn), List.of())));
        }
        return new ObjectColumnType(this.columnPolicy, convertChildColumn.get());
    }

    @Override
    public StorageSupport<Map<String, Object>> storageSupport() {
        return STORAGE;
    }

    @Override
    public long valueBytes(Map<String, Object> map) {
        if (map == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
        return ObjectType.sizeOfMap(map);
    }

    private static long sizeOfMap(Map<?, ?> map) {
        if (map == null) {
            return 0L;
        }
        long size = RamUsageEstimator.shallowSizeOf(map);
        long sizeOfEntry = -1L;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sizeOfEntry == -1L) {
                sizeOfEntry = RamUsageEstimator.shallowSizeOf(entry);
            }
            size += sizeOfEntry;
            size += ObjectType.sizeOfObject(entry.getKey());
            size += ObjectType.sizeOfObject(entry.getValue());
        }
        return RamUsageEstimator.alignObjectSize((long)size);
    }

    private static long sizeOfObject(Object o) {
        long size;
        if (o == null) {
            return 0L;
        }
        if (o instanceof Accountable) {
            size = ((Accountable)o).ramBytesUsed();
        } else if (o instanceof String) {
            size = RamUsageEstimator.sizeOf((String)((String)o));
        } else if (o instanceof boolean[]) {
            size = RamUsageEstimator.sizeOf((boolean[])((boolean[])o));
        } else if (o instanceof byte[]) {
            size = RamUsageEstimator.sizeOf((byte[])((byte[])o));
        } else if (o instanceof char[]) {
            size = RamUsageEstimator.sizeOf((char[])((char[])o));
        } else if (o instanceof double[]) {
            size = RamUsageEstimator.sizeOf((double[])((double[])o));
        } else if (o instanceof float[]) {
            size = RamUsageEstimator.sizeOf((float[])((float[])o));
        } else if (o instanceof int[]) {
            size = RamUsageEstimator.sizeOf((int[])((int[])o));
        } else if (o instanceof Integer) {
            size = RamUsageEstimator.sizeOf((Integer)((Integer)o));
        } else if (o instanceof Long) {
            size = RamUsageEstimator.sizeOf((Long)((Long)o));
        } else if (o instanceof long[]) {
            size = RamUsageEstimator.sizeOf((long[])((long[])o));
        } else if (o instanceof short[]) {
            size = RamUsageEstimator.sizeOf((short[])((short[])o));
        } else if (o instanceof String[]) {
            size = RamUsageEstimator.sizeOf((String[])((String[])o));
        } else if (o instanceof Query) {
            size = RamUsageEstimator.sizeOf((Query)((Query)o), (long)256L);
        } else if (o instanceof Map) {
            Map map = (Map)o;
            size = ObjectType.sizeOfMap(map);
        } else if (o instanceof Collection) {
            Collection collection = (Collection)o;
            size = ObjectType.sizeOfCollection(collection);
        } else {
            size = 256L;
        }
        return size;
    }

    private static long sizeOfCollection(Collection<?> collection) {
        if (collection == null) {
            return 0L;
        }
        long size = RamUsageEstimator.shallowSizeOf(collection);
        size += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)collection.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        for (Object o : collection) {
            size += ObjectType.sizeOfObject(o);
        }
        return RamUsageEstimator.alignObjectSize((long)size);
    }

    @Override
    public long ramBytesUsed() {
        long bytes = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        for (Map.Entry<String, DataType<?>> entry : this.innerTypes.entrySet()) {
            String childName = entry.getKey();
            DataType<?> childType = entry.getValue();
            bytes += RamUsageEstimator.sizeOf((String)childName);
            bytes += childType.ramBytesUsed();
        }
        return bytes + RamUsageEstimator.sizeOf((Integer)ColumnPolicy.DYNAMIC.ordinal());
    }

    @Override
    public ColumnPolicy columnPolicy() {
        return this.columnPolicy;
    }

    @Override
    public DataType<Map<String, Object>> withColumnPolicy(ColumnPolicy columnPolicy) {
        if (this.columnPolicy == columnPolicy) {
            return this;
        }
        Builder objType = ObjectType.of(columnPolicy, this.innerTypes.size());
        for (Map.Entry<String, DataType<?>> entry : this.innerTypes.entrySet()) {
            objType.setInnerType(entry.getKey(), entry.getValue().withColumnPolicy(columnPolicy));
        }
        return objType.build();
    }

    public static class Builder {
        private final LinkedHashMap<String, DataType<?>> innerTypesBuilder;
        private final ColumnPolicy columnPolicy;

        private Builder(ColumnPolicy columnPolicy, LinkedHashMap<String, DataType<?>> innerTypes) {
            this.columnPolicy = columnPolicy;
            this.innerTypesBuilder = innerTypes;
        }

        public Builder setInnerType(String key, DataType<?> innerType) {
            DataType<?> exists = this.innerTypesBuilder.put(key, innerType);
            if (exists != null) {
                throw new IllegalArgumentException("Column \"" + key + "\" specified more than once");
            }
            return this;
        }

        public Builder mergeInnerType(String key, DataType<?> innerType, BiFunction<DataType<?>, DataType<?>, DataType<?>> remappingFunction) {
            this.innerTypesBuilder.merge(key, innerType, remappingFunction);
            return this;
        }

        public ObjectType build() {
            return new ObjectType(Collections.unmodifiableMap(this.innerTypesBuilder), this.columnPolicy);
        }
    }
}

