/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.exceptions.InvalidRelationName;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.SessionSettings;
import io.crate.sql.parser.ParsingException;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.types.DataType;
import io.crate.types.Regclass;
import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class RegclassType
extends DataType<Regclass>
implements Streamer<Regclass> {
    public static final RegclassType INSTANCE = new RegclassType();
    public static final int ID = 23;

    private RegclassType() {
    }

    @Override
    public int compare(Regclass o1, Regclass o2) {
        return o1.compareTo(o2);
    }

    @Override
    public Regclass readValueFrom(StreamInput in) throws IOException {
        return in.readOptionalWriteable(Regclass::new);
    }

    @Override
    public void writeValueTo(StreamOutput out, Regclass v) throws IOException {
        out.writeOptionalWriteable(v);
    }

    @Override
    public int id() {
        return 23;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.REGCLASS;
    }

    @Override
    public String getName() {
        return "regclass";
    }

    @Override
    public Streamer<Regclass> streamer() {
        return this;
    }

    @Override
    public Regclass sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        return (Regclass)value;
    }

    @Override
    public Regclass explicitCast(Object value, SessionSettings sessionSettings) throws IllegalArgumentException, ClassCastException {
        return this.cast(value, sessionSettings.currentSchema());
    }

    @Override
    public Regclass implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        return this.cast(value, CoordinatorTxnCtx.systemTransactionContext().sessionSettings().currentSchema());
    }

    private Regclass cast(Object value, String currentSchema) {
        if (value == null) {
            return null;
        }
        if (value instanceof Regclass) {
            Regclass regclass = (Regclass)value;
            return regclass;
        }
        if (value instanceof Integer) {
            Integer num = (Integer)value;
            return new Regclass(num, value.toString());
        }
        if (value instanceof Long) {
            Long num = (Long)value;
            if (num > Integer.MAX_VALUE || num < Integer.MIN_VALUE) {
                throw new IllegalArgumentException(String.valueOf(value) + " is outside of `int` range and cannot be cast to the regclass type");
            }
            return new Regclass(num.intValue(), value.toString());
        }
        if (value instanceof String) {
            String s = (String)value;
            try {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)SqlParser.createExpression((String)s);
                RelationName relationName = RelationName.of(qualifiedNameReference.getName(), currentSchema);
                return Regclass.fromRelationName(relationName);
            }
            catch (ParsingException e) {
                throw new InvalidRelationName(s, e);
            }
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public long valueBytes(Regclass value) {
        if (value == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
        return RamUsageEstimator.sizeOf((String)value.name()) + RamUsageEstimator.sizeOf((Integer)value.oid());
    }
}

