/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.signatures.antlr.TypeSignaturesLexer;
import io.crate.signatures.antlr.TypeSignaturesParser;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.IntegerLiteralTypeSignature;
import io.crate.types.ObjectType;
import io.crate.types.ParameterTypeSignature;
import io.crate.types.RowType;
import io.crate.types.TypeSignatureParsingException;
import io.crate.types.TypeSignatureType;
import io.crate.types.TypeSignaturesASTVisitor;
import io.crate.types.UndefinedType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class TypeSignature
implements Writeable,
Accountable {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new TypeSignatureParsingException(message, e, line, charPositionInLine);
        }
    };
    private final String baseTypeName;
    private final List<TypeSignature> parameters;

    public static TypeSignature parse(String signature) {
        try {
            TypeSignaturesParser.TypeContext tree;
            TypeSignaturesLexer lexer = new TypeSignaturesLexer((CharStream)CharStreams.fromString((String)signature));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            TypeSignaturesParser parser = new TypeSignaturesParser((TokenStream)tokenStream);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                tree = parser.type();
            }
            catch (ParseCancellationException ex) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                tree = parser.type();
            }
            return (TypeSignature)tree.accept(new TypeSignaturesASTVisitor());
        }
        catch (StackOverflowError e) {
            throw new TypeSignatureParsingException("stack overflow while parsing: " + e.getLocalizedMessage());
        }
    }

    protected static TypeSignature of(int parseInt) {
        return new IntegerLiteralTypeSignature(parseInt);
    }

    public static void toStream(TypeSignature typeSignature, StreamOutput out) throws IOException {
        out.writeVInt(typeSignature.type().ordinal());
        typeSignature.writeTo(out);
    }

    public static TypeSignature fromStream(StreamInput in) throws IOException {
        return TypeSignatureType.VALUES.get(in.readVInt()).newInstance(in);
    }

    public TypeSignature(String baseTypeName) {
        this(baseTypeName, Collections.emptyList());
    }

    public TypeSignature(String baseTypeName, List<TypeSignature> parameters) {
        this.baseTypeName = baseTypeName;
        this.parameters = parameters;
    }

    public TypeSignature(StreamInput in) throws IOException {
        this.baseTypeName = in.readString();
        int numParams = in.readVInt();
        this.parameters = new ArrayList<TypeSignature>(numParams);
        for (int i = 0; i < numParams; ++i) {
            this.parameters.add(TypeSignature.fromStream(in));
        }
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf((String)this.baseTypeName) + this.parameters.stream().mapToLong(TypeSignature::ramBytesUsed).sum();
    }

    public String getBaseTypeName() {
        return this.baseTypeName;
    }

    public List<TypeSignature> getParameters() {
        return this.parameters;
    }

    public boolean hasNumericParameters() {
        return this.parameters.stream().anyMatch(t -> t instanceof IntegerLiteralTypeSignature);
    }

    public DataType<?> createType() {
        if (this.baseTypeName.equalsIgnoreCase("array")) {
            if (this.parameters.isEmpty()) {
                return new ArrayType<Object>(UndefinedType.INSTANCE);
            }
            DataType<?> innerType = this.parameters.get(0).createType();
            return new ArrayType(innerType);
        }
        if (this.baseTypeName.equalsIgnoreCase("object")) {
            boolean objectIsEmpty = true;
            ObjectType.Builder builder = ObjectType.of(ColumnPolicy.DYNAMIC);
            if (this.parameters.size() > 1) {
                for (int i = 0; i < this.parameters.size() - 1; i += 2) {
                    TypeSignature valTypeSignature = this.parameters.get(i + 1);
                    if (!(valTypeSignature instanceof ParameterTypeSignature)) continue;
                    ParameterTypeSignature p = (ParameterTypeSignature)valTypeSignature;
                    String innerTypeName = p.unescapedParameterName();
                    builder.setInnerType(innerTypeName, valTypeSignature.createType());
                    objectIsEmpty = false;
                }
            }
            return objectIsEmpty ? ObjectType.UNTYPED : builder.build();
        }
        if (this.baseTypeName.equalsIgnoreCase("record")) {
            ArrayList<String> fields = new ArrayList<String>(this.parameters.size());
            ArrayList dataTypes = new ArrayList(this.parameters.size());
            for (int i = 0; i < this.parameters.size(); ++i) {
                TypeSignature parameterTypeSignature = this.parameters.get(i);
                if (!(parameterTypeSignature instanceof ParameterTypeSignature)) {
                    return RowType.EMPTY;
                }
                ParameterTypeSignature p = (ParameterTypeSignature)parameterTypeSignature;
                fields.add(p.unescapedParameterName());
                dataTypes.add(p.createType());
            }
            return new RowType(dataTypes, fields);
        }
        ArrayList<Integer> integerLiteralParameters = new ArrayList<Integer>(this.parameters.size());
        for (TypeSignature parameter : this.parameters) {
            if (!parameter.type().equals((Object)TypeSignatureType.INTEGER_LITERAL_SIGNATURE)) {
                throw new IllegalArgumentException("The signature type of the based data type parameters can only be: " + String.valueOf((Object)TypeSignatureType.INTEGER_LITERAL_SIGNATURE) + " but was " + String.valueOf((Object)parameter.type()));
            }
            integerLiteralParameters.add(((IntegerLiteralTypeSignature)parameter).value());
        }
        return DataTypes.of(this.baseTypeName, integerLiteralParameters);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.baseTypeName);
        out.writeVInt(this.parameters.size());
        for (TypeSignature parameter : this.parameters) {
            TypeSignature.toStream(parameter, out);
        }
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.baseTypeName;
        }
        StringBuilder typeName = new StringBuilder(this.baseTypeName);
        typeName.append("(").append(this.parameters.get(0));
        for (int i = 1; i < this.parameters.size(); ++i) {
            typeName.append(",").append(this.parameters.get(i));
        }
        typeName.append(")");
        return typeName.toString();
    }

    public boolean equalsIgnoringParameters(TypeSignature o) {
        return Objects.equals(this.baseTypeName, o.baseTypeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() && this.getClass() != ParameterTypeSignature.class) {
            return false;
        }
        TypeSignature that = (TypeSignature)o;
        return this.equalsIgnoringObjectParameterSizeDifference(that);
    }

    private boolean equalsIgnoringObjectParameterSizeDifference(TypeSignature that) {
        if (this.baseTypeName.equals("object") && that.baseTypeName.equals("object") && this.parameters.size() != that.parameters.size()) {
            return true;
        }
        return this.baseTypeName.equals(that.baseTypeName) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.baseTypeName, this.parameters);
    }

    public TypeSignatureType type() {
        return TypeSignatureType.TYPE_SIGNATURE;
    }
}

