/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import io.crate.rest.action.HttpErrorStatus;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.Nullable;

public class UnavailableShardsException
extends ElasticsearchException
implements TableScopeException {
    private static final Pattern MSG_INDEX_NAME_PATTERN = Pattern.compile("\\[([^\\]]+)\\].*");
    @Nullable
    private final RelationName relationName;

    public UnavailableShardsException(@Nullable ShardId shardId, String message, Object ... args) {
        super(UnavailableShardsException.buildMessage(shardId, message), args);
        this.relationName = shardId == null ? null : RelationName.fromIndexName(shardId.getIndexName());
    }

    public UnavailableShardsException(ShardId shardId) {
        super(UnavailableShardsException.buildMessage(shardId), new Object[0]);
        this.relationName = shardId == null ? null : RelationName.fromIndexName(shardId.getIndexName());
    }

    private static String buildMessage(ShardId shardId) {
        return String.format(Locale.ENGLISH, "[%s] shard %s is not available", shardId.getIndexName(), shardId.id());
    }

    private static String buildMessage(@Nullable ShardId shardId, String message) {
        if (shardId == null) {
            return message;
        }
        return "[" + shardId.getIndexName() + "][" + shardId.id() + "] " + message;
    }

    public UnavailableShardsException(StreamInput in) throws IOException {
        super(in);
        RelationName name = null;
        try {
            Matcher matcher = MSG_INDEX_NAME_PATTERN.matcher(this.getMessage());
            name = matcher.matches() ? RelationName.fromIndexName(matcher.group(1)) : null;
        }
        catch (Exception ex) {
            name = null;
        }
        this.relationName = name;
    }

    @Override
    public RestStatus status() {
        return RestStatus.SERVICE_UNAVAILABLE;
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.ONE_OR_MORE_SHARDS_NOT_AVAILABLE;
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return this.relationName == null ? List.of() : List.of(this.relationName);
    }
}

