/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.health.Health;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterHealthRequest
extends MasterNodeReadRequest<ClusterHealthRequest> {
    private TimeValue timeout = new TimeValue(30L, TimeUnit.SECONDS);
    private Health waitForStatus;
    private boolean waitForNoRelocatingShards = false;
    private boolean waitForNoInitializingShards = false;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;
    private String waitForNodes = "";
    private Priority waitForEvents = null;
    private Level level = Level.SHARDS;

    public ClusterHealthRequest() {
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ClusterHealthRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        if (this.masterNodeTimeout == DEFAULT_MASTER_NODE_TIMEOUT) {
            this.masterNodeTimeout = timeout;
        }
        return this;
    }

    public ClusterHealthRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public Health waitForStatus() {
        return this.waitForStatus;
    }

    public ClusterHealthRequest waitForStatus(Health waitForStatus) {
        this.waitForStatus = waitForStatus;
        return this;
    }

    public ClusterHealthRequest waitForGreenStatus() {
        return this.waitForStatus(Health.GREEN);
    }

    public ClusterHealthRequest waitForYellowStatus() {
        return this.waitForStatus(Health.YELLOW);
    }

    public boolean waitForNoRelocatingShards() {
        return this.waitForNoRelocatingShards;
    }

    public ClusterHealthRequest waitForNoRelocatingShards(boolean waitForNoRelocatingShards) {
        this.waitForNoRelocatingShards = waitForNoRelocatingShards;
        return this;
    }

    public boolean waitForNoInitializingShards() {
        return this.waitForNoInitializingShards;
    }

    public ClusterHealthRequest waitForNoInitializingShards(boolean waitForNoInitializingShards) {
        this.waitForNoInitializingShards = waitForNoInitializingShards;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ClusterHealthRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards.equals(ActiveShardCount.DEFAULT) ? ActiveShardCount.NONE : waitForActiveShards;
        return this;
    }

    public ClusterHealthRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public String waitForNodes() {
        return this.waitForNodes;
    }

    public ClusterHealthRequest waitForNodes(String waitForNodes) {
        this.waitForNodes = waitForNodes;
        return this;
    }

    public ClusterHealthRequest waitForEvents(Priority waitForEvents) {
        this.waitForEvents = waitForEvents;
        return this;
    }

    public Priority waitForEvents() {
        return this.waitForEvents;
    }

    public void level(Level level) {
        this.level = Objects.requireNonNull(level, "level must not be null");
    }

    public Level level() {
        return this.level;
    }

    public ClusterHealthRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_6_0_0)) {
            in.readStringArray();
        }
        this.timeout = in.readTimeValue();
        if (in.readBoolean()) {
            this.waitForStatus = Health.fromValue(in.readByte());
        }
        this.waitForNoRelocatingShards = in.readBoolean();
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.waitForNodes = in.readString();
        if (in.readBoolean()) {
            this.waitForEvents = Priority.readFrom(in);
        }
        this.waitForNoInitializingShards = in.readBoolean();
        if (in.getVersion().before(Version.V_6_0_0)) {
            IndicesOptions.readIndicesOptions(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        out.writeTimeValue(this.timeout);
        if (this.waitForStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.waitForStatus.value());
        }
        out.writeBoolean(this.waitForNoRelocatingShards);
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.waitForNodes);
        if (this.waitForEvents == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Priority.writeTo(this.waitForEvents, out);
        }
        out.writeBoolean(this.waitForNoInitializingShards);
        if (out.getVersion().before(Version.V_6_0_0)) {
            IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED.writeIndicesOptions(out);
        }
    }

    public static enum Level {
        CLUSTER,
        INDICES,
        SHARDS;

    }
}

