/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.health.Health;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public class ClusterHealthResponse
extends TransportResponse {
    private final String clusterName;
    private final int numberOfPendingTasks;
    private final int numberOfInFlightFetch;
    private final int delayedUnassignedShards;
    private final TimeValue taskMaxWaitingTime;
    private final ClusterStateHealth clusterStateHealth;
    private Health clusterHealthStatus;
    private boolean timedOut = false;

    public ClusterHealthResponse(String clusterName, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        this.clusterStateHealth = new ClusterStateHealth(clusterState);
        this.clusterHealthStatus = this.clusterStateHealth.getStatus();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getActiveShards() {
        return this.clusterStateHealth.getActiveShards();
    }

    public int getRelocatingShards() {
        return this.clusterStateHealth.getRelocatingShards();
    }

    public int getActivePrimaryShards() {
        return this.clusterStateHealth.getActivePrimaryShards();
    }

    public int getInitializingShards() {
        return this.clusterStateHealth.getInitializingShards();
    }

    public int getUnassignedShards() {
        return this.clusterStateHealth.getUnassignedShards();
    }

    public int getNumberOfNodes() {
        return this.clusterStateHealth.getNumberOfNodes();
    }

    public int getNumberOfDataNodes() {
        return this.clusterStateHealth.getNumberOfDataNodes();
    }

    public int getNumberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public int getNumberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public Health getStatus() {
        return this.clusterHealthStatus;
    }

    public void setStatus(Health status) {
        if (status == null) {
            throw new IllegalArgumentException("'status' must not be null");
        }
        this.clusterHealthStatus = status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.clusterStateHealth.getIndices();
    }

    public TimeValue getTaskMaxWaitingTime() {
        return this.taskMaxWaitingTime;
    }

    public double getActiveShardsPercent() {
        return this.clusterStateHealth.getActiveShardsPercent();
    }

    public ClusterHealthResponse(StreamInput in) throws IOException {
        this.clusterName = in.readString();
        this.clusterHealthStatus = Health.fromValue(in.readByte());
        this.clusterStateHealth = new ClusterStateHealth(in);
        this.numberOfPendingTasks = in.readInt();
        this.timedOut = in.readBoolean();
        this.numberOfInFlightFetch = in.readInt();
        this.delayedUnassignedShards = in.readInt();
        this.taskMaxWaitingTime = in.readTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.clusterName);
        out.writeByte(this.clusterHealthStatus.value());
        this.clusterStateHealth.writeTo(out);
        out.writeInt(this.numberOfPendingTasks);
        out.writeBoolean(this.timedOut);
        out.writeInt(this.numberOfInFlightFetch);
        out.writeInt(this.delayedUnassignedShards);
        out.writeTimeValue(this.taskMaxWaitingTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterHealthResponse that = (ClusterHealthResponse)o;
        return Objects.equals(this.clusterName, that.clusterName) && this.numberOfPendingTasks == that.numberOfPendingTasks && this.numberOfInFlightFetch == that.numberOfInFlightFetch && this.delayedUnassignedShards == that.delayedUnassignedShards && Objects.equals(this.taskMaxWaitingTime, that.taskMaxWaitingTime) && this.timedOut == that.timedOut && Objects.equals(this.clusterStateHealth, that.clusterStateHealth) && this.clusterHealthStatus == that.clusterHealthStatus;
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.numberOfPendingTasks, this.numberOfInFlightFetch, this.delayedUnassignedShards, this.taskMaxWaitingTime, this.timedOut, this.clusterStateHealth, this.clusterHealthStatus);
    }
}

