/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.create;

import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class CreateSnapshotRequest
extends MasterNodeRequest<CreateSnapshotRequest> {
    private String snapshot;
    private String repository;
    private List<RelationName> relationNames = List.of();
    private List<PartitionName> partitionNames = List.of();
    private boolean partial = false;
    private Settings settings = Settings.EMPTY;
    private boolean includeGlobalState = true;
    private boolean waitForCompletion;

    public CreateSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    public CreateSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        if (in.getVersion().before(Version.V_6_0_0)) {
            String[] oldIndices = in.readStringArray();
            IndicesOptions.readIndicesOptions(in);
            String[] oldTemplates = in.readStringArray();
            HashSet<RelationName> relationNames = new HashSet<RelationName>();
            ArrayList<PartitionName> partitionNames = new ArrayList<PartitionName>();
            for (String index : oldIndices) {
                IndexParts indexParts = IndexName.decode(index);
                if (indexParts.isPartitioned()) {
                    partitionNames.add(PartitionName.fromIndexOrTemplate(index));
                    continue;
                }
                relationNames.add(indexParts.toRelationName());
            }
            for (String template : oldTemplates) {
                relationNames.add(IndexName.decode(template).toRelationName());
            }
            this.relationNames = new ArrayList<RelationName>(relationNames);
            this.partitionNames = partitionNames;
        }
        this.settings = Settings.readSettingsFromStream(in);
        this.includeGlobalState = in.readBoolean();
        this.waitForCompletion = in.readBoolean();
        this.partial = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_6_0_0)) {
            this.relationNames = in.readList(RelationName::new);
            this.partitionNames = in.readList(PartitionName::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        if (out.getVersion().before(Version.V_6_0_0)) {
            HashSet indices = new HashSet();
            this.relationNames.stream().map(RelationName::indexNameOrAlias).forEach(indices::add);
            this.partitionNames.stream().map(PartitionName::asIndexName).forEach(indices::add);
            out.writeStringArray((String[])indices.toArray(String[]::new));
            IndicesOptions.STRICT_EXPAND_OPEN.writeIndicesOptions(out);
            out.writeStringArray((String[])this.relationNames.stream().map(r -> PartitionName.templateName(r.schema(), r.name())).toArray(String[]::new));
        }
        Settings.writeSettingsToStream(out, this.settings);
        out.writeBoolean(this.includeGlobalState);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.partial);
        if (out.getVersion().onOrAfter(Version.V_6_0_0)) {
            out.writeList(this.relationNames);
            out.writeList(this.partitionNames);
        }
    }

    public CreateSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public CreateSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public CreateSnapshotRequest relationNames(List<RelationName> relationNames) {
        this.relationNames = relationNames;
        return this;
    }

    public List<RelationName> relationNames() {
        return this.relationNames;
    }

    public CreateSnapshotRequest partitionNames(List<PartitionName> partitionNames) {
        this.partitionNames = partitionNames;
        return this;
    }

    public List<PartitionName> partitionNames() {
        return this.partitionNames;
    }

    public boolean partial() {
        return this.partial;
    }

    public CreateSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public CreateSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public CreateSnapshotRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateSnapshotRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateSnapshotRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CreateSnapshotRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = JsonXContent.builder();
            builder.map(source);
            this.settings(Strings.toString(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public CreateSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotRequest that = (CreateSnapshotRequest)o;
        return this.partial == that.partial && this.includeGlobalState == that.includeGlobalState && this.waitForCompletion == that.waitForCompletion && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.repository, that.repository) && Objects.equals(this.relationNames, that.relationNames) && Objects.equals(this.partitionNames, that.partitionNames) && Objects.equals(this.settings, that.settings) && Objects.equals(this.masterNodeTimeout, that.masterNodeTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.snapshot, this.repository, this.relationNames, this.partitionNames, this.partial, this.settings, this.includeGlobalState, this.waitForCompletion);
    }

    public String toString() {
        return "CreateSnapshotRequest{snapshot='" + this.snapshot + "', repository='" + this.repository + "', relationNames=" + String.valueOf(this.relationNames) + ", partitionNames=" + String.valueOf(this.partitionNames) + ", partial=" + this.partial + ", settings=" + String.valueOf(this.settings) + ", includeGlobalState=" + this.includeGlobalState + ", waitForCompletion=" + this.waitForCompletion + ", masterNodeTimeout=" + String.valueOf(this.masterNodeTimeout) + "}";
    }
}

