/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.IndexName;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterStateRequest
extends MasterNodeReadRequest<ClusterStateRequest> {
    public static final TimeValue DEFAULT_WAIT_FOR_NODE_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private boolean routingTable = true;
    private boolean nodes = true;
    private boolean metadata = true;
    private boolean blocks = true;
    private boolean customs = true;
    private Long waitForMetadataVersion;
    private TimeValue waitForTimeout = DEFAULT_WAIT_FOR_NODE_TIMEOUT;
    private List<RelationName> relationNames = new ArrayList<RelationName>();

    public ClusterStateRequest() {
    }

    public ClusterStateRequest all() {
        this.routingTable = true;
        this.nodes = true;
        this.metadata = true;
        this.blocks = true;
        this.customs = true;
        this.relationNames = new ArrayList<RelationName>();
        return this;
    }

    public ClusterStateRequest clear() {
        this.routingTable = false;
        this.nodes = false;
        this.metadata = false;
        this.blocks = false;
        this.customs = false;
        this.relationNames = new ArrayList<RelationName>();
        return this;
    }

    public boolean routingTable() {
        return this.routingTable;
    }

    public ClusterStateRequest routingTable(boolean routingTable) {
        this.routingTable = routingTable;
        return this;
    }

    public boolean nodes() {
        return this.nodes;
    }

    public ClusterStateRequest nodes(boolean nodes) {
        this.nodes = nodes;
        return this;
    }

    public boolean metadata() {
        return this.metadata;
    }

    public ClusterStateRequest metadata(boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean blocks() {
        return this.blocks;
    }

    public ClusterStateRequest blocks(boolean blocks) {
        this.blocks = blocks;
        return this;
    }

    public ClusterStateRequest relationNames(List<RelationName> relationNames) {
        this.relationNames = relationNames;
        return this;
    }

    public List<RelationName> relationNames() {
        return this.relationNames;
    }

    public ClusterStateRequest customs(boolean customs) {
        this.customs = customs;
        return this;
    }

    public boolean customs() {
        return this.customs;
    }

    public TimeValue waitForTimeout() {
        return this.waitForTimeout;
    }

    public ClusterStateRequest waitForTimeout(TimeValue waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
        return this;
    }

    public Long waitForMetadataVersion() {
        return this.waitForMetadataVersion;
    }

    public ClusterStateRequest(StreamInput in) throws IOException {
        super(in);
        this.routingTable = in.readBoolean();
        this.nodes = in.readBoolean();
        this.metadata = in.readBoolean();
        this.blocks = in.readBoolean();
        this.customs = in.readBoolean();
        String[] oldIndices = Strings.EMPTY_ARRAY;
        if (in.getVersion().before(Version.V_6_0_0)) {
            oldIndices = in.readStringArray();
            IndicesOptions.readIndicesOptions(in);
        }
        if (in.getVersion().onOrAfter(Version.V_4_4_0)) {
            this.waitForTimeout = in.readTimeValue();
            this.waitForMetadataVersion = in.readOptionalLong();
        }
        String[] oldTemplates = Strings.EMPTY_ARRAY;
        if (in.getVersion().before(Version.V_6_0_0)) {
            oldTemplates = in.readStringArray();
        }
        HashSet<RelationName> relationNamesSet = new HashSet<RelationName>();
        if (in.getVersion().onOrAfter(Version.V_6_0_0)) {
            relationNamesSet.addAll(in.readList(RelationName::new));
        }
        for (String index : oldIndices) {
            relationNamesSet.add(IndexName.decode(index).toRelationName());
        }
        for (String template : oldTemplates) {
            RelationName relationName = IndexName.decode(template).toRelationName();
            relationNamesSet.add(relationName);
        }
        this.relationNames = new ArrayList<RelationName>(relationNamesSet);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.routingTable);
        out.writeBoolean(this.nodes);
        out.writeBoolean(this.metadata);
        out.writeBoolean(this.blocks);
        out.writeBoolean(this.customs);
        if (out.getVersion().before(Version.V_6_0_0)) {
            out.writeStringArray((String[])this.relationNames.stream().map(RelationName::indexNameOrAlias).toArray(String[]::new));
            IndicesOptions.LENIENT_EXPAND_OPEN.writeIndicesOptions(out);
        }
        if (out.getVersion().onOrAfter(Version.V_4_4_0)) {
            out.writeTimeValue(this.waitForTimeout);
            out.writeOptionalLong(this.waitForMetadataVersion);
        }
        if (out.getVersion().before(Version.V_6_0_0)) {
            out.writeStringArray((String[])this.relationNames.stream().map(r -> PartitionName.templateName(r.schema(), r.name())).toArray(String[]::new));
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0)) {
            out.writeList(this.relationNames);
        }
    }

    public ClusterStateRequest waitForMetadataVersion(long waitForMetadataVersion) {
        if (waitForMetadataVersion < 1L) {
            throw new IllegalArgumentException("provided waitForMetadataVersion should be >= 1, but instead is [" + waitForMetadataVersion + "]");
        }
        this.waitForMetadataVersion = waitForMetadataVersion;
        return this;
    }
}

