/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import io.crate.common.collections.Lists;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CreatePartitionsRequest
extends AcknowledgedRequest<CreatePartitionsRequest> {
    private final RelationName relationName;
    private final List<List<String>> partitionValuesList;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CreatePartitionsRequest of(Collection<PartitionName> partitions) {
        List<RelationName> relations = partitions.stream().map(PartitionName::relationName).distinct().toList();
        switch (relations.size()) {
            case 0: {
                throw new IllegalArgumentException("Must create at least one partition");
            }
            case 1: {
                return new CreatePartitionsRequest(relations.get(0), Lists.map(partitions, p -> p.ident().isEmpty() ? List.of() : p.values()));
            }
            default: {
                throw new IllegalArgumentException("Cannot create partitions for more than one table in the same request: " + String.valueOf(relations));
            }
        }
    }

    public CreatePartitionsRequest(RelationName relationName, List<List<String>> partitionValuesList) {
        this.relationName = relationName;
        this.partitionValuesList = partitionValuesList;
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public List<List<String>> partitionValuesList() {
        return this.partitionValuesList;
    }

    public List<String> indexNames() {
        return Lists.map(this.partitionValuesList, values -> new PartitionName(this.relationName, (List<String>)values).asIndexName());
    }

    public CreatePartitionsRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_5_10_0)) {
            this.relationName = new RelationName(in);
            int numPartitions = in.readVInt();
            this.partitionValuesList = new ArrayList<List<String>>(numPartitions);
            for (int i = 0; i < numPartitions; ++i) {
                int numValues = in.readVInt();
                ArrayList<String> partitionValues = new ArrayList<String>(numValues);
                for (int j = 0; j < numValues; ++j) {
                    partitionValues.add(in.readOptionalString());
                }
                this.partitionValuesList.add(partitionValues);
            }
        } else {
            if (in.getVersion().before(Version.V_5_3_0)) {
                in.readLong();
                in.readLong();
            }
            int numIndices = in.readVInt();
            this.partitionValuesList = new ArrayList<List<String>>(numIndices);
            RelationName relation = null;
            for (int i = 0; i < numIndices; ++i) {
                PartitionName partitionName = PartitionName.fromIndexOrTemplate(in.readString());
                if (relation == null) {
                    relation = partitionName.relationName();
                }
                this.partitionValuesList.add(partitionName.values());
            }
            this.relationName = relation;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_10_0)) {
            this.relationName.writeTo(out);
            out.writeVInt(this.partitionValuesList.size());
            for (List<String> partitionValues : this.partitionValuesList) {
                out.writeVInt(partitionValues.size());
                for (String value : partitionValues) {
                    out.writeOptionalString(value);
                }
            }
        } else {
            if (out.getVersion().before(Version.V_5_3_0)) {
                out.writeLong(0L);
                out.writeLong(0L);
            }
            out.writeVInt(this.partitionValuesList.size());
            for (List<String> partitionValues : this.partitionValuesList) {
                String indexName = new PartitionName(this.relationName, partitionValues).asIndexName();
                out.writeString(indexName);
            }
        }
    }
}

