/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.tables.MappingUtil;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreatePartitionsRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TransportCreatePartitions
extends TransportMasterNodeAction<CreatePartitionsRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final ActiveShardsObserver activeShardsObserver;
    private final ShardLimitValidator shardLimitValidator;
    private final DocTableInfoFactory docTableInfoFactory;

    @Inject
    public TransportCreatePartitions(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndicesService indicesService, AllocationService allocationService, ShardLimitValidator shardLimitValidator, NodeContext nodeContext) {
        super(ACTION.name(), transportService, clusterService, threadPool, CreatePartitionsRequest::new);
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService);
        this.shardLimitValidator = shardLimitValidator;
        this.docTableInfoFactory = new DocTableInfoFactory(nodeContext);
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(CreatePartitionsRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws ElasticsearchException {
        this.createIndices(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                String[] indices = (String[])request.partitionValuesList().stream().map(partitionValues -> this.clusterService.state().metadata().getIndex(request.relationName(), (List<String>)partitionValues, false, IndexMetadata::getIndexUUID)).toArray(String[]::new);
                this.activeShardsObserver.waitForActiveShards(indices, ActiveShardCount.DEFAULT, request.ackTimeout(), shardsAcked -> {
                    if (!shardsAcked.booleanValue() && this.logger.isInfoEnabled()) {
                        RelationName relationName = request.relationName();
                        RelationMetadata.Table table = (RelationMetadata.Table)state.metadata().getRelation(relationName);
                        assert (table != null) : "table should be present in the cluster state";
                        this.logger.info("[{}] Table partitions created, but the operation timed out while waiting for enough shards to be started. Timeout={}, wait_for_active_shards={}. Consider decreasing the 'number_of_shards' table setting (currently: {}) or adding nodes to the cluster.", (Object)relationName, (Object)request.timeout(), (Object)IndexMetadata.SETTING_WAIT_FOR_ACTIVE_SHARDS.get(table.settings()), (Object)IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(table.settings()));
                    }
                    listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
                }, listener::onFailure);
            } else {
                this.logger.warn("[{}] Table partitions created, but publishing new cluster state timed out. Timeout={}", (Object)request.relationName(), (Object)request.timeout());
                listener.onResponse(new AcknowledgedResponse(false));
            }
        }, listener::onFailure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState executeCreateIndices(ClusterState currentState, RelationMetadata.Table table, DocTableInfo docTableInfo, CreatePartitionsRequest request) throws Exception {
        List<PartitionName> partitions;
        Index testIndex;
        String removalReason;
        block10: {
            removalReason = null;
            testIndex = null;
            partitions = TransportCreatePartitions.getPartitionsToCreate(currentState, request);
            if (!partitions.isEmpty()) break block10;
            ClusterState clusterState = currentState;
            if (testIndex != null) {
                this.indicesService.removeIndex(testIndex, IndicesClusterStateService.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason != null ? removalReason : "failed to create index");
            }
            return clusterState;
        }
        try {
            String firstIndex = partitions.get(0).asIndexName();
            Metadata metadata = currentState.metadata();
            Metadata.Builder newMetadataBuilder = Metadata.builder(metadata);
            Settings commonIndexSettings = this.createCommonIndexSettings(currentState, table.settings());
            int numberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(commonIndexSettings);
            int numberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(commonIndexSettings);
            int numShardsToCreate = numberOfShards * (1 + numberOfReplicas) * partitions.size();
            this.shardLimitValidator.checkShardLimit(numShardsToCreate, currentState).ifPresent(err -> {
                ValidationException e = new ValidationException();
                e.addValidationError((String)err);
                throw e;
            });
            int numTargetShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(commonIndexSettings);
            Version indexVersionCreated = commonIndexSettings.getAsVersion("index.version.created", null);
            int routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(commonIndexSettings) ? numTargetShards : MetadataCreateIndexService.calculateNumRoutingShards(numTargetShards, indexVersionCreated);
            String tmpUUID = UUIDs.randomBase64UUID();
            IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(tmpUUID).indexName(firstIndex).setRoutingNumShards(routingNumShards);
            IndexMetadata tmpImd = tmpImdBuilder.settings(Settings.builder().put(commonIndexSettings).put("index.uuid", tmpUUID)).build();
            ActiveShardCount waitForActiveShards = tmpImd.getWaitForActiveShards();
            if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                throw new IllegalArgumentException("invalid wait_for_active_shards[" + String.valueOf(waitForActiveShards) + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
            }
            IndexService indexService = this.indicesService.createIndex(tmpImd, Collections.emptyList(), false);
            testIndex = indexService.index();
            MappingMetadata mapping = new MappingMetadata(Map.of("default", MappingUtil.createMapping(MappingUtil.AllocPosition.forTable(docTableInfo), table.pkConstraintName(), table.columns(), table.primaryKeys(), table.checkConstraints(), table.partitionedBy(), table.columnPolicy(), table.routingColumn())));
            RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
            ArrayList<String> indexUUIDs = new ArrayList<String>(partitions.size());
            for (PartitionName partition : partitions) {
                IndexMetadata indexMetadata;
                String indexName = partition.asIndexName();
                String indexUUID = UUIDs.randomBase64UUID();
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexUUID).indexName(indexName).setRoutingNumShards(routingNumShards).partitionValues(partition.values()).settings(Settings.builder().put(commonIndexSettings).put("index.uuid", indexUUID));
                indexMetadataBuilder.putMapping(mapping);
                indexMetadataBuilder.state(IndexMetadata.State.OPEN);
                try {
                    indexMetadata = indexMetadataBuilder.build();
                }
                catch (Exception e) {
                    removalReason = "failed to build index metadata";
                    throw e;
                }
                this.logger.info("[{}] creating partition, cause [bulk], shards [{}]/[{}]", (Object)partition, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas());
                indexService.getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
                newMetadataBuilder.put(indexMetadata, false);
                indexUUIDs.add(indexUUID);
                routingTableBuilder.addAsNew(indexMetadata);
            }
            newMetadataBuilder.addIndexUUIDs(table, indexUUIDs);
            Metadata newMetadata = newMetadataBuilder.build();
            ClusterState updatedState = ClusterState.builder(currentState).metadata(newMetadata).routingTable(routingTableBuilder.build()).build();
            ClusterState clusterState = this.allocationService.reroute(updatedState, "bulk-index-creation");
            if (testIndex != null) {
                this.indicesService.removeIndex(testIndex, IndicesClusterStateService.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason != null ? removalReason : "failed to create index");
            }
            return clusterState;
        }
        catch (Throwable throwable) {
            if (testIndex != null) {
                this.indicesService.removeIndex(testIndex, IndicesClusterStateService.IndexRemovalReason.NO_LONGER_ASSIGNED, removalReason != null ? removalReason : "failed to create index");
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    void createIndices(final CreatePartitionsRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("bulk-create-indices", request, ClusterStateTaskConfig.build(Priority.URGENT, request.masterNodeTimeout()), (currentState, tasks) -> {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<CreatePartitionsRequest> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            for (CreatePartitionsRequest request1 : tasks) {
                try {
                    RelationMetadata.Table table = (RelationMetadata.Table)currentState.metadata().getRelation(request1.relationName());
                    if (table == null) {
                        throw new RelationUnknown(request1.relationName());
                    }
                    DocTableInfo docTableInfo = this.docTableInfoFactory.create(table.name(), currentState.metadata());
                    currentState = this.executeCreateIndices(currentState, table, docTableInfo, request1);
                    builder.success(request);
                }
                catch (Exception e) {
                    builder.failure(request, e);
                }
            }
            return builder.build(currentState);
        }, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, (AckedRequest)request, listener){
            final /* synthetic */ TransportCreatePartitions this$0;
            {
                this.this$0 = this$0;
                super(request2, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                RelationMetadata.Table table = (RelationMetadata.Table)currentState.metadata().getRelation(request.relationName());
                if (table == null) {
                    throw new RelationUnknown(request.relationName());
                }
                DocTableInfo docTableInfo = this.this$0.docTableInfoFactory.create(table.name(), currentState.metadata());
                return this.this$0.executeCreateIndices(currentState, table, docTableInfo, request);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }
        });
    }

    private static List<PartitionName> getPartitionsToCreate(ClusterState state, CreatePartitionsRequest request) {
        Metadata metadata = state.metadata();
        ArrayList<PartitionName> partitions = new ArrayList<PartitionName>(request.partitionValuesList().size());
        for (List<String> partitionValues : request.partitionValuesList()) {
            List<IndexMetadata> indices = metadata.getIndices(request.relationName(), partitionValues, false, imd -> imd);
            if (!indices.isEmpty()) continue;
            PartitionName partition = new PartitionName(request.relationName(), partitionValues);
            partitions.add(partition);
        }
        return partitions;
    }

    private Settings createCommonIndexSettings(ClusterState currentState, Settings tableSettings) {
        Settings.Builder indexSettingsBuilder = Settings.builder();
        indexSettingsBuilder.put(tableSettings);
        Version minVersion = currentState.nodes().getSmallestNonClientNodeVersion();
        indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), minVersion);
        if (indexSettingsBuilder.get("index.creation_date") == null) {
            indexSettingsBuilder.put("index.creation_date", new DateTime(DateTimeZone.UTC).getMillis());
        }
        return indexSettingsBuilder.build();
    }

    @Override
    protected ClusterBlockException checkBlock(CreatePartitionsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, (String[])request.indexNames().toArray(String[]::new));
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "indices:admin/bulk_create";

        private Action() {
            super(NAME);
        }
    }
}

