/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import io.crate.common.MutableLong;
import io.crate.common.concurrent.ConcurrencyLimit;
import io.crate.common.unit.TimeValue;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Gatherer;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class BackoffPolicy {
    private static final int DEFAULT_RETRY_LIMIT = 10;

    private BackoffPolicy() {
    }

    public static Iterable<TimeValue> unlimitedDynamic(ConcurrencyLimit concurrencyLimit) {
        return () -> Stream.generate(() -> TimeValue.timeValueNanos((long)concurrencyLimit.getLastRtt(TimeUnit.NANOSECONDS))).iterator();
    }

    public static Iterable<TimeValue> limitedDynamic(ConcurrencyLimit concurrencyLimit) {
        return () -> Stream.generate(() -> TimeValue.timeValueNanos((long)concurrencyLimit.getLastRtt(TimeUnit.NANOSECONDS))).limit(10L).iterator();
    }

    private static long exp(long initialDelayMs, long i) {
        long delta = 10L * ((long)Math.exp(0.8 * (double)i) - 1L);
        long result = initialDelayMs + delta;
        return result < 0L || i > 51L ? Long.MAX_VALUE : result;
    }

    private static Stream<TimeValue> exponential(TimeValue initialDelay) {
        long initialDelayMs = initialDelay.millis();
        return LongStream.iterate(0L, i -> i + 1L).mapToObj(i -> TimeValue.timeValueMillis((long)BackoffPolicy.exp(initialDelayMs, i)));
    }

    public static Iterable<TimeValue> exponentialBackoff() {
        return BackoffPolicy.exponentialBackoff(TimeValue.timeValueMillis((long)50L), 8);
    }

    public static Iterable<TimeValue> exponentialBackoff(TimeValue initialDelay, int maxNumberOfRetries) {
        return () -> BackoffPolicy.exponential(initialDelay).limit(maxNumberOfRetries).iterator();
    }

    public static Iterable<TimeValue> exponentialBackoff(TimeValue initialDelay, TimeValue timeout) {
        long timeoutMs = timeout.millis();
        if (timeoutMs == 0L) {
            return List.of();
        }
        Gatherer withTimeLimit = Gatherer.ofSequential(() -> new MutableLong(0L), (sumState, delay, downstream) -> {
            sumState.add(delay.millis());
            downstream.push(delay);
            long delaySum = sumState.value();
            return delaySum > 0L && delaySum < timeoutMs;
        });
        return () -> BackoffPolicy.exponential(initialDelay).gather(withTimeLimit).iterator();
    }

    public static Iterable<TimeValue> exponentialBackoff(int initialDelayMs, int maxNumberOfRetries, int maxDelayMs) {
        return () -> LongStream.iterate(0L, i -> i + 1L).mapToObj(i -> TimeValue.timeValueMillis((long)Math.min(BackoffPolicy.exp(initialDelayMs, i), (long)maxDelayMs))).limit(maxNumberOfRetries).iterator();
    }
}

