/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import io.crate.common.unit.TimeValue;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.node.NodeClosedException;

public class ActiveShardsObserver {
    private static final Logger LOGGER = LogManager.getLogger(ActiveShardsObserver.class);
    private final ClusterService clusterService;

    public ActiveShardsObserver(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public <T extends AcknowledgedResponse> ActionListener<T> waitForShards(ActionListener<T> delegate, TimeValue timeout, Runnable onShardsNotAcknowledged, Supplier<String[]> getIndexUUIDs) {
        return ActionListener.wrap(resp -> {
            if (resp.isAcknowledged()) {
                this.waitForActiveShards((String[])getIndexUUIDs.get(), ActiveShardCount.DEFAULT, timeout, shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        onShardsNotAcknowledged.run();
                    }
                    delegate.onResponse(resp);
                }, delegate::onFailure);
            } else {
                delegate.onResponse(resp);
            }
        }, delegate::onFailure);
    }

    public CompletableFuture<Boolean> waitForActiveShards(String[] indexUUIDs, ActiveShardCount shardCount, TimeValue timeout) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.waitForActiveShards(indexUUIDs, shardCount, timeout, result::complete, result::completeExceptionally);
        return result;
    }

    public void waitForActiveShards(final String[] indexUUIDs, ActiveShardCount activeShardCount, TimeValue timeout, final Consumer<Boolean> onResult, final Consumer<Exception> onFailure) {
        if (activeShardCount == ActiveShardCount.NONE) {
            onResult.accept(true);
            return;
        }
        ClusterState state = this.clusterService.state();
        ClusterStateObserver observer = new ClusterStateObserver(state, this.clusterService.getClusterApplierService(), null, LOGGER);
        if (activeShardCount.enoughShardsActive(state, indexUUIDs)) {
            onResult.accept(true);
        } else {
            Predicate<ClusterState> shardsAllocatedPredicate = newState -> activeShardCount.enoughShardsActive((ClusterState)newState, indexUUIDs);
            ClusterStateObserver.Listener observerListener = new ClusterStateObserver.Listener(){
                final /* synthetic */ ActiveShardsObserver this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onNewClusterState(ClusterState state) {
                    onResult.accept(true);
                }

                @Override
                public void onClusterServiceClose() {
                    LOGGER.debug("[{}] cluster service closed while waiting for enough shards to be started.", (Object)Arrays.toString(indexUUIDs));
                    onFailure.accept(new NodeClosedException(this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    onResult.accept(false);
                }
            };
            observer.waitForNextChange(observerListener, shardsAllocatedPredicate, timeout);
        }
    }
}

