/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.MasterNodeChangePredicate;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeAction<Request extends MasterNodeRequest<Request>, Response extends TransportResponse>
extends HandledTransportAction<Request, Response> {
    protected final ThreadPool threadPool;
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    private final String executor;

    protected TransportMasterNodeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Writeable.Reader<Request> request) {
        this(actionName, true, transportService, clusterService, threadPool, request);
    }

    protected TransportMasterNodeAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Writeable.Reader<Request> request) {
        super(actionName, canTripCircuitBreaker, transportService, request);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.executor = this.executor();
    }

    protected abstract String executor();

    protected abstract Response read(StreamInput var1) throws IOException;

    protected abstract void masterOperation(Request var1, ClusterState var2, ActionListener<Response> var3) throws Exception;

    protected boolean localExecute(Request request) {
        return false;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        ClusterState state = this.clusterService.state();
        this.logger.trace("starting processing request [{}] with cluster state version [{}]", request, (Object)state.version());
        new AsyncSingleAction(this, request, listener).doStart(state);
    }

    protected String getMasterActionName(DiscoveryNode node) {
        return this.actionName;
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private ClusterStateObserver observer;
        private final long startTime;
        final /* synthetic */ TransportMasterNodeAction this$0;

        AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
            this.startTime = this$0.threadPool.relativeTimeInMillis();
        }

        protected void doStart(final ClusterState clusterState) {
            if (clusterState == null) {
                WaitForInitialState waitForState = this.this$0.new WaitForInitialState(this);
                this.this$0.clusterService.addListener(waitForState);
                if (this.this$0.clusterService.state() != null) {
                    waitForState.clusterChanged(null);
                }
                return;
            }
            try {
                final DiscoveryNodes nodes = clusterState.nodes();
                if (nodes.isLocalNodeElectedMaster() || this.this$0.localExecute(this.request)) {
                    ClusterBlockException blockException = this.this$0.checkBlock(this.request, clusterState);
                    if (blockException != null) {
                        if (!blockException.retryable()) {
                            this.listener.onFailure(blockException);
                        } else {
                            this.this$0.logger.debug("can't execute due to a cluster block, retrying", (Throwable)blockException);
                            this.retry(clusterState, blockException, newState -> {
                                try {
                                    ClusterBlockException newException = this.this$0.checkBlock(this.request, (ClusterState)newState);
                                    return newException == null || !newException.retryable();
                                }
                                catch (Exception e) {
                                    this.this$0.logger.trace("exception occurred during cluster block checking, accepting state", (Throwable)e);
                                    return true;
                                }
                            });
                        }
                    } else {
                        ActionListener delegate = this.listener.withOnFailure((delegatedListener, t) -> {
                            if (t instanceof FailedToCommitClusterStateException || t instanceof NotMasterException) {
                                this.this$0.logger.debug(() -> new ParameterizedMessage("master could not publish cluster state or stepped down before publishing action [{}], scheduling a retry", (Object)this.this$0.actionName), (Throwable)t);
                                this.retryOnMasterChange(clusterState, (Throwable)t);
                            } else {
                                delegatedListener.onFailure((Exception)t);
                            }
                        });
                        this.this$0.threadPool.executor(this.this$0.executor).execute(ActionRunnable.wrap(delegate, l -> this.this$0.masterOperation(this.request, clusterState, l)));
                    }
                } else if (nodes.getMasterNode() == null) {
                    this.this$0.logger.debug("no known master node, scheduling a retry");
                    this.retryOnMasterChange(clusterState, null);
                } else {
                    DiscoveryNode masterNode = nodes.getMasterNode();
                    final String actionName = this.this$0.getMasterActionName(masterNode);
                    ActionListenerResponseHandler handler = new ActionListenerResponseHandler<Response>(this, actionName, this.listener, this.this$0::read){
                        final /* synthetic */ AsyncSingleAction this$1;
                        {
                            this.this$1 = this$1;
                            super(action, listener, reader);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            Throwable cause = exp.unwrapCause();
                            if (cause instanceof ConnectTransportException || exp instanceof RemoteTransportException && cause instanceof NodeClosedException) {
                                this.this$1.this$0.logger.debug("connection exception while trying to forward request with action name [{}] to master node [{}], scheduling a retry. Error: [{}]", (Object)actionName, (Object)nodes.getMasterNode(), (Object)exp.getDetailedMessage());
                                this.this$1.retryOnMasterChange(clusterState, null);
                            } else {
                                this.this$1.listener.onFailure(exp);
                            }
                        }
                    };
                    this.this$0.transportService.sendRequest(masterNode, actionName, (TransportRequest)this.request, handler);
                }
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        private void retryOnMasterChange(ClusterState state, Throwable failure) {
            this.retry(state, failure, MasterNodeChangePredicate.build(state));
        }

        private void retry(ClusterState state, final Throwable failure, Predicate<ClusterState> statePredicate) {
            if (this.observer == null) {
                long remainingTimeoutMS = ((MasterNodeRequest)this.request).masterNodeTimeout().millis() - (this.this$0.threadPool.relativeTimeInMillis() - this.startTime);
                if (remainingTimeoutMS <= 0L) {
                    this.this$0.logger.debug(() -> new ParameterizedMessage("timed out before retrying [{}] after failure", (Object)this.this$0.actionName), failure);
                    this.listener.onFailure(new MasterNotDiscoveredException(failure));
                    return;
                }
                this.observer = new ClusterStateObserver(state, this.this$0.clusterService.getClusterApplierService(), TimeValue.timeValueMillis((long)remainingTimeoutMS), this.this$0.logger);
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){
                final /* synthetic */ AsyncSingleAction this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void onNewClusterState(ClusterState state) {
                    this.this$1.doStart(state);
                }

                @Override
                public void onClusterServiceClose() {
                    this.this$1.listener.onFailure(new NodeClosedException(this.this$1.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    this.this$1.this$0.logger.debug(() -> new ParameterizedMessage("timed out while retrying [{}] after failure (timeout [{}])", (Object)this.this$1.this$0.actionName, (Object)timeout), failure);
                    this.this$1.listener.onFailure(new MasterNotDiscoveredException(failure));
                }
            }, statePredicate);
        }
    }

    class WaitForInitialState
    implements ClusterStateListener {
        private final AsyncSingleAction asyncSingleAction;

        public WaitForInitialState(AsyncSingleAction asyncSingleAction) {
            this.asyncSingleAction = asyncSingleAction;
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            TransportMasterNodeAction.this.clusterService.removeListener(this);
            this.asyncSingleAction.doStart(event.state());
        }
    }
}

