/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public abstract class ReplicationRequest<Request extends ReplicationRequest<Request>>
extends TransportRequest {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected final ShardId shardId;
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private long routedBasedOnClusterVersion = 0L;

    public ReplicationRequest(ShardId shardId) {
        this.shardId = shardId;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public final Request waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return (Request)this;
    }

    protected Request routedBasedOnClusterVersion(long routedBasedOnClusterVersion) {
        this.routedBasedOnClusterVersion = routedBasedOnClusterVersion;
        return (Request)this;
    }

    long routedBasedOnClusterVersion() {
        return this.routedBasedOnClusterVersion;
    }

    public ReplicationRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_6_0_0)) {
            in.readBoolean();
        }
        this.shardId = new ShardId(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.timeout = in.readTimeValue();
        if (in.getVersion().before(Version.V_6_0_0)) {
            in.readString();
        }
        this.routedBasedOnClusterVersion = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_0_0)) {
            out.writeBoolean(true);
        }
        this.shardId.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeTimeValue(this.timeout);
        if (out.getVersion().before(Version.V_6_0_0)) {
            out.writeString(this.shardId.getIndexName());
        }
        out.writeVLong(this.routedBasedOnClusterVersion);
    }

    public abstract String toString();

    public void onRetry() {
    }
}

