/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import io.crate.common.exceptions.Exceptions;
import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportResponse;
import org.jetbrains.annotations.Nullable;

public class ReplicationResponse
extends TransportResponse {
    public static final ShardInfo.Failure[] EMPTY = new ShardInfo.Failure[0];
    private ShardInfo shardInfo;

    public ReplicationResponse() {
    }

    public ReplicationResponse(StreamInput in) throws IOException {
        this.shardInfo = new ShardInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardInfo.writeTo(out);
    }

    public ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    public void setShardInfo(ShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    public static class ShardInfo
    implements Writeable {
        private final int total;
        private final int successful;
        private final Failure[] failures;

        public ShardInfo(int total, int successful, Failure ... failures) {
            assert (total >= 0 && successful >= 0);
            this.total = total;
            this.successful = successful;
            this.failures = failures;
        }

        public ShardInfo(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.successful = in.readVInt();
            int size = in.readVInt();
            this.failures = new Failure[size];
            for (int i = 0; i < size; ++i) {
                this.failures[i] = new Failure(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.successful);
            out.writeVInt(this.failures.length);
            for (Failure failure : this.failures) {
                failure.writeTo(out);
            }
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccessful() {
            return this.successful;
        }

        public int getFailed() {
            return this.failures.length;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        public RestStatus status() {
            RestStatus status = RestStatus.OK;
            for (Failure failure : this.failures) {
                if (!failure.primary() || failure.status().getStatus() <= status.getStatus()) continue;
                status = failure.status();
            }
            return status;
        }

        public String toString() {
            return "ShardInfo{total=" + this.total + ", successful=" + this.successful + ", failures=" + Arrays.toString(this.failures) + "}";
        }

        public static class Failure
        extends ShardOperationFailedException {
            private final ShardId shardId;
            private final String nodeId;
            private final boolean primary;

            public Failure(ShardId shardId, @Nullable String nodeId, Exception cause, RestStatus status, boolean primary) {
                super(shardId.getIndexName(), shardId.id(), Exceptions.stackTrace((Throwable)cause), status, cause);
                this.shardId = shardId;
                this.nodeId = nodeId;
                this.primary = primary;
            }

            public ShardId fullShardId() {
                return this.shardId;
            }

            @Nullable
            public String nodeId() {
                return this.nodeId;
            }

            public boolean primary() {
                return this.primary;
            }

            public Failure(StreamInput in) throws IOException {
                this.shardId = new ShardId(in);
                ((ShardOperationFailedException)this).shardId = this.shardId.id();
                this.index = this.shardId.getIndexName();
                this.nodeId = in.readOptionalString();
                this.cause = in.readException();
                this.status = RestStatus.readFrom(in);
                this.primary = in.readBoolean();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.shardId.writeTo(out);
                out.writeOptionalString(this.nodeId);
                out.writeException(this.cause);
                RestStatus.writeTo(out, this.status);
                out.writeBoolean(this.primary);
            }
        }
    }
}

