/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.concurrent.MultiActionListener;
import io.crate.exceptions.SQLExceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastReplicationAction<Request extends BroadcastRequest, Response extends BroadcastResponse, ShardRequest extends ReplicationRequest<ShardRequest>, ShardResponse extends ReplicationResponse>
extends HandledTransportAction<Request, Response> {
    private final ActionType<ShardResponse> replicatedBroadcastShardAction;
    private final ClusterService clusterService;
    private final NodeClient client;

    public TransportBroadcastReplicationAction(String name, Writeable.Reader<Request> reader, ClusterService clusterService, TransportService transportService, NodeClient client, ActionType<ShardResponse> replicatedBroadcastShardAction) {
        super(name, transportService, reader);
        this.client = client;
        this.replicatedBroadcastShardAction = replicatedBroadcastShardAction;
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        List<ShardId> shards = this.shards(request, clusterState);
        MultiActionListener multiListener = new MultiActionListener(shards.size(), Collectors.collectingAndThen(Collectors.toList(), this::mergeResponse), listener);
        for (ShardId shardId : shards) {
            this.shardExecute(request, shardId, ActionListener.wrap(multiListener::onResponse, e -> {
                Object[] failures;
                int totalNumCopies = clusterState.metadata().getIndexSafe(shardId.getIndex()).getNumberOfReplicas() + 1;
                ShardResponse shardResponse = this.newShardResponse();
                if (SQLExceptions.isShardNotAvailable(e)) {
                    failures = new ReplicationResponse.ShardInfo.Failure[]{};
                } else {
                    ReplicationResponse.ShardInfo.Failure failure = new ReplicationResponse.ShardInfo.Failure(shardId, null, (Exception)e, SQLExceptions.status(e), true);
                    failures = new ReplicationResponse.ShardInfo.Failure[totalNumCopies];
                    Arrays.fill(failures, failure);
                }
                ((ReplicationResponse)shardResponse).setShardInfo(new ReplicationResponse.ShardInfo(totalNumCopies, 0, (ReplicationResponse.ShardInfo.Failure[])failures));
                multiListener.onResponse(shardResponse);
            }));
        }
    }

    protected void shardExecute(Request request, ShardId shardId, ActionListener<ShardResponse> shardActionListener) {
        ShardRequest shardRequest = this.newShardRequest(request, shardId);
        this.client.execute(this.replicatedBroadcastShardAction, shardRequest).whenComplete(shardActionListener);
    }

    protected List<ShardId> shards(Request request, ClusterState clusterState) {
        ArrayList<ShardId> shardIds = new ArrayList<ShardId>();
        for (IndexRoutingTable routing : clusterState.metadata().getIndices(((BroadcastRequest)request).partitions(), false, im -> clusterState.routingTable().indicesRouting().get(im.getIndex().getUUID()))) {
            for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : routing.shards()) {
                shardIds.add(((IndexShardRoutingTable)intObjectCursor.value).shardId());
            }
        }
        return shardIds;
    }

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardRequest newShardRequest(Request var1, ShardId var2);

    private Response mergeResponse(List<ShardResponse> shardsResponses) {
        this.logger.trace("{}: got all shard responses", (Object)this.actionName);
        int successfulShards = 0;
        int failedShards = 0;
        int totalNumCopies = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.size(); ++i) {
            ReplicationResponse shardResponse = (ReplicationResponse)shardsResponses.get(i);
            if (shardResponse == null) continue;
            failedShards += shardResponse.getShardInfo().getFailed();
            successfulShards += shardResponse.getShardInfo().getSuccessful();
            totalNumCopies += shardResponse.getShardInfo().getTotal();
            if (shardFailures == null) {
                shardFailures = new ArrayList<DefaultShardOperationFailedException>();
            }
            for (ReplicationResponse.ShardInfo.Failure failure : shardResponse.getShardInfo().getFailures()) {
                shardFailures.add(new DefaultShardOperationFailedException(new BroadcastShardOperationFailedException(failure.fullShardId(), failure.getCause())));
            }
        }
        return this.newResponse(successfulShards, failedShards, totalNumCopies, shardFailures);
    }

    protected abstract Response newResponse(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);
}

