/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlockException
extends ElasticsearchException {
    private final Set<ClusterBlock> blocks;

    public ClusterBlockException(Set<ClusterBlock> blocks) {
        super(ClusterBlockException.buildMessage(blocks), new Object[0]);
        this.blocks = blocks;
    }

    public ClusterBlockException(StreamInput in) throws IOException {
        super(in);
        this.blocks = Collections.unmodifiableSet(in.readSet(ClusterBlock::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.blocks != null) {
            out.writeCollection(this.blocks);
        } else {
            out.writeVInt(0);
        }
    }

    public boolean retryable() {
        for (ClusterBlock block : this.blocks) {
            if (block.retryable()) continue;
            return false;
        }
        return true;
    }

    public Set<ClusterBlock> blocks() {
        return this.blocks;
    }

    private static String buildMessage(Set<ClusterBlock> blocks) {
        StringBuilder sb = new StringBuilder("blocked by: ");
        for (ClusterBlock block : blocks) {
            sb.append("[").append((Object)block.status()).append("/").append(block.id()).append("/").append(block.description()).append("];");
        }
        return sb.toString();
    }

    @Override
    public RestStatus status() {
        RestStatus status = null;
        for (ClusterBlock block : this.blocks) {
            if (status == null) {
                status = block.status();
                continue;
            }
            if (status.getStatus() >= block.status().getStatus()) continue;
            status = block.status();
        }
        return status;
    }
}

