/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.Nullable;

public class ClusterBlocks
extends AbstractDiffable<ClusterBlocks> {
    public static final ClusterBlocks EMPTY_CLUSTER_BLOCK = new ClusterBlocks(Collections.emptySet(), ImmutableOpenMap.of());
    private final Set<ClusterBlock> global;
    private final ImmutableOpenMap<String, Set<ClusterBlock>> indicesBlocks;
    private final EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders;

    ClusterBlocks(Set<ClusterBlock> global, ImmutableOpenMap<String, Set<ClusterBlock>> indicesBlocks) {
        this.global = global;
        this.indicesBlocks = indicesBlocks;
        this.levelHolders = ClusterBlocks.generateLevelHolders(global, indicesBlocks);
    }

    public Set<ClusterBlock> global() {
        return this.global;
    }

    public ImmutableOpenMap<String, Set<ClusterBlock>> indices() {
        return this.indicesBlocks;
    }

    public Set<ClusterBlock> global(ClusterBlockLevel level) {
        return this.levelHolders.get((Object)level).global();
    }

    public Set<ClusterBlock> global(RestStatus status) {
        HashSet<ClusterBlock> blocks = new HashSet<ClusterBlock>();
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.status().equals((Object)status)) continue;
            blocks.add(clusterBlock);
        }
        return blocks;
    }

    public ImmutableOpenMap<String, Set<ClusterBlock>> indices(ClusterBlockLevel level) {
        return this.levelHolders.get((Object)level).indices();
    }

    private Set<ClusterBlock> blocksForIndex(ClusterBlockLevel level, String index) {
        return this.indices(level).getOrDefault(index, Collections.emptySet());
    }

    private static EnumMap<ClusterBlockLevel, ImmutableLevelHolder> generateLevelHolders(Set<ClusterBlock> global, ImmutableOpenMap<String, Set<ClusterBlock>> indicesBlocks) {
        EnumMap<ClusterBlockLevel, ImmutableLevelHolder> levelHolders = new EnumMap<ClusterBlockLevel, ImmutableLevelHolder>(ClusterBlockLevel.class);
        for (ClusterBlockLevel level : ClusterBlockLevel.values()) {
            Predicate<ClusterBlock> containsLevel = block -> block.contains(level);
            Set<ClusterBlock> newGlobal = Collections.unmodifiableSet(global.stream().filter(containsLevel).collect(Collectors.toSet()));
            ImmutableOpenMap.Builder indicesBuilder = ImmutableOpenMap.builder();
            for (ObjectObjectCursor<String, Set<ClusterBlock>> objectObjectCursor : indicesBlocks) {
                indicesBuilder.put((String)objectObjectCursor.key, Collections.unmodifiableSet(((Set)objectObjectCursor.value).stream().filter(containsLevel).collect(Collectors.toSet())));
            }
            levelHolders.put(level, new ImmutableLevelHolder(newGlobal, indicesBuilder.build()));
        }
        return levelHolders;
    }

    public boolean disableStatePersistence() {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.disableStatePersistence()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlock(ClusterBlock block) {
        return this.global.contains(block);
    }

    public boolean hasGlobalBlockWithId(int blockId) {
        for (ClusterBlock clusterBlock : this.global) {
            if (clusterBlock.id() != blockId) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlockWithLevel(ClusterBlockLevel level) {
        return this.global(level).size() > 0;
    }

    public boolean hasGlobalBlockWithStatus(RestStatus status) {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.status().equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndexBlock(String indexUUID, ClusterBlock block) {
        return this.indicesBlocks.containsKey(indexUUID) && this.indicesBlocks.get(indexUUID).contains(block);
    }

    public boolean hasIndexBlockWithId(String indexUUID, int blockId) {
        Set<ClusterBlock> clusterBlocks = this.indicesBlocks.get(indexUUID);
        if (clusterBlocks != null) {
            for (ClusterBlock clusterBlock : clusterBlocks) {
                if (clusterBlock.id() != blockId) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ClusterBlock getIndexBlockWithId(String indexUUID, int blockId) {
        Set<ClusterBlock> clusterBlocks = this.indicesBlocks.get(indexUUID);
        if (clusterBlocks != null) {
            for (ClusterBlock clusterBlock : clusterBlocks) {
                if (clusterBlock.id() != blockId) continue;
                return clusterBlock;
            }
        }
        return null;
    }

    private boolean globalBlocked(ClusterBlockLevel level) {
        return !this.global(level).isEmpty();
    }

    public ClusterBlockException globalBlockedException(ClusterBlockLevel level) {
        if (!this.globalBlocked(level)) {
            return null;
        }
        return new ClusterBlockException(this.global(level));
    }

    public ClusterBlockException indexBlockedException(ClusterBlockLevel level, String index) {
        if (!this.indexBlocked(level, index)) {
            return null;
        }
        Stream blocks = Stream.concat(this.global(level).stream(), this.blocksForIndex(level, index).stream());
        return new ClusterBlockException(Collections.unmodifiableSet(blocks.collect(Collectors.toSet())));
    }

    public boolean indexBlocked(ClusterBlockLevel level, String index) {
        return this.globalBlocked(level) || !this.blocksForIndex(level, index).isEmpty();
    }

    public ClusterBlockException indicesBlockedException(ClusterBlockLevel level, String[] indices) {
        boolean indexIsBlocked = false;
        for (String index2 : indices) {
            if (!this.indexBlocked(level, index2)) continue;
            indexIsBlocked = true;
        }
        if (!this.globalBlocked(level) && !indexIsBlocked) {
            return null;
        }
        Function<String, Stream> blocksForIndexAtLevel = index -> this.blocksForIndex(level, (String)index).stream();
        Stream blocks = Stream.concat(this.global(level).stream(), Stream.of(indices).flatMap(blocksForIndexAtLevel));
        return new ClusterBlockException(Collections.unmodifiableSet(blocks.collect(Collectors.toSet())));
    }

    public ClusterBlockException indicesAllowReleaseResources(String[] indices) {
        Function<String, Stream> blocksForIndexAtLevel = index -> this.blocksForIndex(ClusterBlockLevel.METADATA_WRITE, (String)index).stream();
        Stream<ClusterBlock> blocks = Stream.concat(this.global(ClusterBlockLevel.METADATA_WRITE).stream(), Stream.of(indices).flatMap(blocksForIndexAtLevel)).filter(clusterBlock -> !clusterBlock.isAllowReleaseResources());
        Set<ClusterBlock> clusterBlocks = Collections.unmodifiableSet(blocks.collect(Collectors.toSet()));
        if (clusterBlocks.isEmpty()) {
            return null;
        }
        return new ClusterBlockException(clusterBlocks);
    }

    public String toString() {
        if (this.global.isEmpty() && this.indices().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("blocks: \n");
        if (!this.global.isEmpty()) {
            sb.append("   _global_:\n");
            for (ClusterBlock clusterBlock : this.global) {
                sb.append("      ").append(clusterBlock);
            }
        }
        for (ObjectObjectCursor objectObjectCursor : this.indices()) {
            sb.append("   ").append((String)objectObjectCursor.key).append(":\n");
            for (ClusterBlock block : (Set)objectObjectCursor.value) {
                sb.append("      ").append(block);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ClusterBlocks.writeBlockSet(this.global, out);
        out.writeMap(this.indicesBlocks, StreamOutput::writeString, (o, s) -> ClusterBlocks.writeBlockSet(s, o));
    }

    private static void writeBlockSet(Set<ClusterBlock> blocks, StreamOutput out) throws IOException {
        out.writeCollection(blocks);
    }

    public static ClusterBlocks readFrom(StreamInput in) throws IOException {
        Set<ClusterBlock> global = ClusterBlocks.readBlockSet(in);
        ImmutableOpenMap<String, Set<ClusterBlock>> indicesBlocks = in.readImmutableMap(i -> i.readString().intern(), ClusterBlocks::readBlockSet);
        if (global.isEmpty() && indicesBlocks.isEmpty()) {
            return EMPTY_CLUSTER_BLOCK;
        }
        return new ClusterBlocks(global, indicesBlocks);
    }

    private static Set<ClusterBlock> readBlockSet(StreamInput in) throws IOException {
        Set<ClusterBlock> blocks = in.readSet(ClusterBlock::new);
        return blocks.isEmpty() ? blocks : Collections.unmodifiableSet(blocks);
    }

    public static Diff<ClusterBlocks> readDiffFrom(StreamInput in) throws IOException {
        return AbstractDiffable.readDiffFrom(ClusterBlocks::readFrom, in);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.global.hashCode();
        result = 31 * result + this.indicesBlocks.hashCode();
        result = 31 * result + this.levelHolders.hashCode();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ClusterBlocks)) return false;
        ClusterBlocks other = (ClusterBlocks)obj;
        if (!this.global.equals(other.global)) return false;
        if (!this.indicesBlocks.equals(other.indicesBlocks)) return false;
        if (!this.levelHolders.equals((Object)other.levelHolders)) return false;
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    record ImmutableLevelHolder(Set<ClusterBlock> global, ImmutableOpenMap<String, Set<ClusterBlock>> indices) {
    }

    public static class Builder {
        private final Set<ClusterBlock> global = new HashSet<ClusterBlock>();
        private final Map<String, Set<ClusterBlock>> indices = new HashMap<String, Set<ClusterBlock>>();

        public Builder blocks(ClusterBlocks blocks) {
            this.global.addAll(blocks.global());
            for (ObjectObjectCursor<String, Set<ClusterBlock>> objectObjectCursor : blocks.indices()) {
                if (!this.indices.containsKey(objectObjectCursor.key)) {
                    this.indices.put((String)objectObjectCursor.key, new HashSet());
                }
                this.indices.get(objectObjectCursor.key).addAll((Collection)objectObjectCursor.value);
            }
            return this;
        }

        public Builder addBlocks(IndexMetadata indexMetadata) {
            String indexUUID = indexMetadata.getIndex().getUUID();
            if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                this.addIndexBlock(indexUUID, IndexMetadata.INDEX_CLOSED_BLOCK);
            }
            if (IndexMetadata.INDEX_READ_ONLY_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexUUID, IndexMetadata.INDEX_READ_ONLY_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexUUID, IndexMetadata.INDEX_READ_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexUUID, IndexMetadata.INDEX_WRITE_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexUUID, IndexMetadata.INDEX_METADATA_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexUUID, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);
            }
            return this;
        }

        public Builder addBlocksWithIndexName(IndexMetadata indexMetadata) {
            String indexName = indexMetadata.getIndex().getName();
            if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_CLOSED_BLOCK);
            }
            if (IndexMetadata.INDEX_READ_ONLY_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_READ_ONLY_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_READ_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_WRITE_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_METADATA_BLOCK);
            }
            if (IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                this.addIndexBlock(indexName, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);
            }
            return this;
        }

        public Builder updateBlocks(IndexMetadata indexMetadata) {
            this.indices.remove(indexMetadata.getIndex().getUUID());
            return this.addBlocks(indexMetadata);
        }

        public Builder addGlobalBlock(ClusterBlock block) {
            this.global.add(block);
            return this;
        }

        public Builder removeGlobalBlock(ClusterBlock block) {
            this.global.remove(block);
            return this;
        }

        public Builder removeGlobalBlock(int blockId) {
            this.global.removeIf(block -> block.id() == blockId);
            return this;
        }

        public Builder addIndexBlock(String indexUUID, ClusterBlock block) {
            if (!this.indices.containsKey(indexUUID)) {
                this.indices.put(indexUUID, new HashSet());
            }
            this.indices.get(indexUUID).add(block);
            return this;
        }

        public Builder removeIndexBlocks(String indexUUID) {
            if (!this.indices.containsKey(indexUUID)) {
                return this;
            }
            this.indices.remove(indexUUID);
            return this;
        }

        public Builder removeIndexBlock(String index, ClusterBlock block) {
            if (!this.indices.containsKey(index)) {
                return this;
            }
            this.indices.get(index).remove(block);
            if (this.indices.get(index).isEmpty()) {
                this.indices.remove(index);
            }
            return this;
        }

        public Builder removeIndexBlockWithId(String index, int blockId) {
            Set<ClusterBlock> indexBlocks = this.indices.get(index);
            if (indexBlocks == null) {
                return this;
            }
            indexBlocks.removeIf(block -> block.id() == blockId);
            if (indexBlocks.isEmpty()) {
                this.indices.remove(index);
            }
            return this;
        }

        public ClusterBlocks build() {
            if (this.indices.isEmpty() && this.global.isEmpty()) {
                return EMPTY_CLUSTER_BLOCK;
            }
            ImmutableOpenMap.Builder indicesBuilder = ImmutableOpenMap.builder(this.indices.size());
            for (Map.Entry<String, Set<ClusterBlock>> entry : this.indices.entrySet()) {
                indicesBuilder.put(entry.getKey(), Set.copyOf((Collection)entry.getValue()));
            }
            return new ClusterBlocks(Set.copyOf(this.global), indicesBuilder.build());
        }
    }
}

