/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import io.crate.common.collections.Tuple;
import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.JoinRequest;
import org.elasticsearch.cluster.coordination.JoinTaskExecutor;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.coordination.ValidateJoinRequest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class JoinHelper {
    private static final Logger LOGGER = LogManager.getLogger(JoinHelper.class);
    public static final String JOIN_ACTION_NAME = "internal:cluster/coordination/join";
    public static final String VALIDATE_JOIN_ACTION_NAME = "internal:cluster/coordination/join/validate";
    public static final String START_JOIN_ACTION_NAME = "internal:cluster/coordination/start_join";
    public static final Setting<TimeValue> JOIN_TIMEOUT_SETTING = Setting.timeSetting("cluster.join.timeout", TimeValue.timeValueMillis((long)60000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final MasterService masterService;
    private final TransportService transportService;
    private volatile JoinTaskExecutor joinTaskExecutor;
    @Nullable
    private final TimeValue joinTimeout;
    private final NodeHealthService nodeHealthService;
    private final Set<Tuple<DiscoveryNode, JoinRequest>> pendingOutgoingJoins = Collections.synchronizedSet(new HashSet());
    private final AtomicReference<FailedJoinAttempt> lastFailedJoinAttempt = new AtomicReference();
    private final Supplier<JoinTaskExecutor> joinTaskExecutorGenerator;

    JoinHelper(Settings settings, AllocationService allocationService, MasterService masterService, TransportService transportService, final LongSupplier currentTermSupplier, Supplier<ClusterState> currentStateSupplier, BiConsumer<JoinRequest, ActionListener<Void>> joinHandler, Function<StartJoinRequest, Join> joinLeaderInTerm, Collection<BiConsumer<DiscoveryNode, ClusterState>> joinValidators, RerouteService rerouteService, NodeHealthService nodeHealthService) {
        this.masterService = masterService;
        this.transportService = transportService;
        this.nodeHealthService = nodeHealthService;
        this.joinTimeout = DiscoveryModule.isSingleNodeDiscovery(settings) ? null : JOIN_TIMEOUT_SETTING.get(settings);
        this.joinTaskExecutorGenerator = () -> new JoinTaskExecutor(this, allocationService, LOGGER, rerouteService){
            private final long term;
            {
                super(allocationService, logger, rerouteService);
                this.term = currentTermSupplier.getAsLong();
            }

            @Override
            public ClusterStateTaskExecutor.ClusterTasksResult<JoinTaskExecutor.Task> execute(ClusterState currentState, List<JoinTaskExecutor.Task> joiningTasks) throws Exception {
                if (currentState.term() > this.term) {
                    LOGGER.trace("encountered higher term {} than current {}, there is a newer master", (Object)currentState.term(), (Object)this.term);
                    throw new NotMasterException("Higher term encountered (current: " + currentState.term() + " > used: " + this.term + "), there is a newer master");
                }
                if (currentState.nodes().getMasterNodeId() == null && joiningTasks.stream().anyMatch(JoinTaskExecutor.Task::isBecomeMasterTask)) {
                    assert (currentState.term() < this.term) : "there should be at most one become master task per election (= by term)";
                    CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).term(this.term).build();
                    Metadata metadata = Metadata.builder(currentState.metadata()).coordinationMetadata(coordinationMetadata).build();
                    currentState = ClusterState.builder(currentState).metadata(metadata).build();
                } else if (currentState.nodes().isLocalNodeElectedMaster()) assert (currentState.term() == this.term) : "term should be stable for the same master";
                return super.execute(currentState, joiningTasks);
            }
        };
        transportService.registerRequestHandler(JOIN_ACTION_NAME, "generic", false, false, JoinRequest::new, (request, channel) -> joinHandler.accept((JoinRequest)request, this.transportJoinCallback(request, channel)));
        transportService.registerRequestHandler(START_JOIN_ACTION_NAME, "generic", false, false, StartJoinRequest::new, (request, channel) -> {
            DiscoveryNode destination = request.getSourceNode();
            this.sendJoinRequest(destination, currentTermSupplier.getAsLong(), Optional.of((Join)joinLeaderInTerm.apply((StartJoinRequest)request)));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
        transportService.registerRequestHandler(VALIDATE_JOIN_ACTION_NAME, "generic", ValidateJoinRequest::new, (request, channel) -> {
            ClusterState localState = (ClusterState)currentStateSupplier.get();
            if (localState.metadata().clusterUUIDCommitted() && !localState.metadata().clusterUUID().equals(request.getState().metadata().clusterUUID())) {
                throw new CoordinationStateRejectedException("join validation on cluster state with a different cluster uuid " + request.getState().metadata().clusterUUID() + " than local cluster uuid " + localState.metadata().clusterUUID() + ", rejecting", new Object[0]);
            }
            joinValidators.forEach(action -> action.accept(transportService.getLocalNode(), request.getState()));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
    }

    private ActionListener<Void> transportJoinCallback(final TransportRequest request, final TransportChannel channel) {
        return new ActionListener<Void>(this){

            @Override
            public void onResponse(Void response) {
                try {
                    channel.sendResponse(TransportResponse.Empty.INSTANCE);
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    LOGGER.warn("failed to send back failure on join request", (Throwable)inner);
                }
            }

            public String toString() {
                return "JoinCallback{request=" + String.valueOf(request) + "}";
            }
        };
    }

    boolean isJoinPending() {
        return !this.pendingOutgoingJoins.isEmpty();
    }

    void logLastFailedJoinAttempt() {
        FailedJoinAttempt attempt = this.lastFailedJoinAttempt.get();
        if (attempt != null) {
            attempt.logWarnWithTimestamp();
            this.lastFailedJoinAttempt.compareAndSet(attempt, null);
        }
    }

    public void sendJoinRequest(final DiscoveryNode destination, long term, Optional<Join> optionalJoin) {
        assert (destination.isMasterEligibleNode()) : "trying to join master-ineligible " + String.valueOf(destination);
        StatusInfo statusInfo = this.nodeHealthService.getHealth();
        if (statusInfo.status() == StatusInfo.Status.UNHEALTHY) {
            LOGGER.debug("dropping join request to [{}]: [{}]", (Object)destination, (Object)statusInfo.info());
            return;
        }
        final JoinRequest joinRequest = new JoinRequest(this.transportService.getLocalNode(), term, optionalJoin);
        final Tuple dedupKey = new Tuple((Object)destination, (Object)joinRequest);
        if (this.pendingOutgoingJoins.add((Tuple<DiscoveryNode, JoinRequest>)dedupKey)) {
            LOGGER.debug("attempting to join {} with {}", (Object)destination, (Object)joinRequest);
            this.transportService.sendRequest(destination, JOIN_ACTION_NAME, (TransportRequest)joinRequest, new TransportRequestOptions(this.joinTimeout), new TransportResponseHandler<TransportResponse.Empty>(){
                final /* synthetic */ JoinHelper this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public TransportResponse.Empty read(StreamInput in) {
                    return TransportResponse.Empty.INSTANCE;
                }

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    this.this$0.pendingOutgoingJoins.remove(dedupKey);
                    LOGGER.debug("successfully joined {} with {}", (Object)destination, (Object)joinRequest);
                    this.this$0.lastFailedJoinAttempt.set(null);
                }

                @Override
                public void handleException(TransportException exp) {
                    this.this$0.pendingOutgoingJoins.remove(dedupKey);
                    FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, exp);
                    attempt.logNow();
                    this.this$0.lastFailedJoinAttempt.set(attempt);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        } else {
            LOGGER.debug("already attempting to join {} with request {}, not sending request", (Object)destination, (Object)joinRequest);
        }
    }

    void sendStartJoinRequest(final StartJoinRequest startJoinRequest, final DiscoveryNode destination) {
        assert (startJoinRequest.getSourceNode().isMasterEligibleNode()) : "sending start-join request for master-ineligible " + String.valueOf(startJoinRequest.getSourceNode());
        this.transportService.sendRequest(destination, START_JOIN_ACTION_NAME, startJoinRequest, new TransportResponseHandler<TransportResponse.Empty>(){

            @Override
            public TransportResponse.Empty read(StreamInput in) {
                return TransportResponse.Empty.INSTANCE;
            }

            @Override
            public void handleResponse(TransportResponse.Empty response) {
                LOGGER.debug("successful response to {} from {}", (Object)startJoinRequest, (Object)destination);
            }

            @Override
            public void handleException(TransportException exp) {
                LOGGER.debug((Message)new ParameterizedMessage("failure in response to {} from {}", (Object)startJoinRequest, (Object)destination), (Throwable)exp);
            }

            @Override
            public String executor() {
                return "same";
            }
        });
    }

    void sendValidateJoinRequest(DiscoveryNode node, ClusterState state, ActionListener<TransportResponse.Empty> listener) {
        this.transportService.sendRequest(node, VALIDATE_JOIN_ACTION_NAME, (TransportRequest)new ValidateJoinRequest(state), new TransportRequestOptions(this.joinTimeout), new ActionListenerResponseHandler<TransportResponse.Empty>(VALIDATE_JOIN_ACTION_NAME, listener, i -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    static class FailedJoinAttempt {
        private final DiscoveryNode destination;
        private final JoinRequest joinRequest;
        private final TransportException exception;
        private final long timestamp;

        FailedJoinAttempt(DiscoveryNode destination, JoinRequest joinRequest, TransportException exception) {
            this.destination = destination;
            this.joinRequest = joinRequest;
            this.exception = exception;
            this.timestamp = System.nanoTime();
        }

        void logNow() {
            LOGGER.log(FailedJoinAttempt.getLogLevel(this.exception), () -> new ParameterizedMessage("failed to join {} with {}", (Object)this.destination, (Object)this.joinRequest), (Throwable)this.exception);
        }

        static Level getLogLevel(TransportException e) {
            Throwable cause = e.unwrapCause();
            if (cause instanceof CoordinationStateRejectedException || cause instanceof FailedToCommitClusterStateException || cause instanceof NotMasterException) {
                return Level.DEBUG;
            }
            return Level.INFO;
        }

        void logWarnWithTimestamp() {
            LOGGER.warn(() -> new ParameterizedMessage("last failed join attempt was {} ago, failed to join {} with {}", new Object[]{TimeValue.timeValueMillis((long)TimeValue.nsecToMSec((long)(System.nanoTime() - this.timestamp))), this.destination, this.joinRequest}), (Throwable)this.exception);
        }
    }

    class CandidateJoinAccumulator
    implements JoinAccumulator {
        private final Map<DiscoveryNode, ActionListener<Void>> joinRequestAccumulator = new HashMap<DiscoveryNode, ActionListener<Void>>();
        boolean closed;

        CandidateJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinCallback) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            ActionListener<Void> prev = this.joinRequestAccumulator.put(sender, joinCallback);
            if (prev != null) {
                prev.onFailure(new CoordinationStateRejectedException("received a newer join from " + String.valueOf(sender), new Object[0]));
            }
        }

        @Override
        public void close(Coordinator.Mode newMode) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            this.closed = true;
            if (newMode == Coordinator.Mode.LEADER) {
                LinkedHashMap<JoinTaskExecutor.Task, ClusterStateTaskListener> pendingAsTasks = new LinkedHashMap<JoinTaskExecutor.Task, ClusterStateTaskListener>();
                this.joinRequestAccumulator.forEach((key, value) -> {
                    JoinTaskExecutor.Task task = new JoinTaskExecutor.Task((DiscoveryNode)key, "elect leader");
                    pendingAsTasks.put(task, new JoinTaskListener(task, (ActionListener<Void>)value));
                });
                String stateUpdateSource = "elected-as-master ([" + pendingAsTasks.size() + "] nodes joined)";
                pendingAsTasks.put(JoinTaskExecutor.newBecomeMasterTask(), (source, e) -> {});
                pendingAsTasks.put(JoinTaskExecutor.newFinishElectionTask(), (source, e) -> {});
                JoinHelper.this.joinTaskExecutor = JoinHelper.this.joinTaskExecutorGenerator.get();
                JoinHelper.this.masterService.submitStateUpdateTasks(stateUpdateSource, pendingAsTasks, ClusterStateTaskConfig.build(Priority.URGENT), JoinHelper.this.joinTaskExecutor);
            } else {
                assert (newMode == Coordinator.Mode.FOLLOWER) : newMode;
                JoinHelper.this.joinTaskExecutor = null;
                this.joinRequestAccumulator.values().forEach(joinCallback -> joinCallback.onFailure(new CoordinationStateRejectedException("became follower", new Object[0])));
            }
        }

        public String toString() {
            return "CandidateJoinAccumulator{" + String.valueOf(this.joinRequestAccumulator.keySet()) + ", closed=" + this.closed + "}";
        }
    }

    static class FollowerJoinAccumulator
    implements JoinAccumulator {
        FollowerJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinCallback) {
            joinCallback.onFailure(new CoordinationStateRejectedException("join target is a follower", new Object[0]));
        }

        public String toString() {
            return "FollowerJoinAccumulator";
        }
    }

    static class InitialJoinAccumulator
    implements JoinAccumulator {
        InitialJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinCallback) {
            assert (false) : "unexpected join from " + String.valueOf(sender) + " during initialisation";
            joinCallback.onFailure(new CoordinationStateRejectedException("join target is not initialised yet", new Object[0]));
        }

        public String toString() {
            return "InitialJoinAccumulator";
        }
    }

    class LeaderJoinAccumulator
    implements JoinAccumulator {
        LeaderJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinCallback) {
            JoinTaskExecutor.Task task = new JoinTaskExecutor.Task(sender, "join existing leader");
            assert (JoinHelper.this.joinTaskExecutor != null);
            JoinHelper.this.masterService.submitStateUpdateTask("node-join", task, ClusterStateTaskConfig.build(Priority.URGENT), JoinHelper.this.joinTaskExecutor, new JoinTaskListener(task, joinCallback));
        }

        public String toString() {
            return "LeaderJoinAccumulator";
        }
    }

    static interface JoinAccumulator {
        public void handleJoinRequest(DiscoveryNode var1, ActionListener<Void> var2);

        default public void close(Coordinator.Mode newMode) {
        }
    }

    static class JoinTaskListener
    implements ClusterStateTaskListener {
        private final JoinTaskExecutor.Task task;
        private final ActionListener<Void> joinCallback;

        JoinTaskListener(JoinTaskExecutor.Task task, ActionListener<Void> joinCallback) {
            this.task = task;
            this.joinCallback = joinCallback;
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.joinCallback.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.joinCallback.onResponse(null);
        }

        public String toString() {
            return "JoinTaskListener{task=" + String.valueOf(this.task) + "}";
        }
    }
}

