/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.health.Health;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.Index;
import org.elasticsearch.rest.RestStatus;

public final class ClusterStateHealth
implements Iterable<ClusterIndexHealth>,
Writeable {
    private final int numberOfNodes;
    private final int numberOfDataNodes;
    private final int activeShards;
    private final int relocatingShards;
    private final int activePrimaryShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final double activeShardsPercent;
    private final Health status;
    private final Map<String, ClusterIndexHealth> indices;

    public ClusterStateHealth(ClusterState clusterState) {
        this.numberOfNodes = clusterState.nodes().getSize();
        this.numberOfDataNodes = clusterState.nodes().getDataNodes().size();
        this.indices = new HashMap<String, ClusterIndexHealth>();
        for (IndexRoutingTable indexRoutingTable : clusterState.routingTable()) {
            Index index = indexRoutingTable.getIndex();
            IndexMetadata indexMetadata = clusterState.metadata().index(index);
            if (indexMetadata == null) continue;
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(indexMetadata, indexRoutingTable);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        Health computeStatus = Health.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            computeActivePrimaryShards += indexHealth.getActivePrimaryShards();
            computeActiveShards += indexHealth.getActiveShards();
            computeRelocatingShards += indexHealth.getRelocatingShards();
            computeInitializingShards += indexHealth.getInitializingShards();
            computeUnassignedShards += indexHealth.getUnassignedShards();
            if (indexHealth.getStatus() == Health.RED) {
                computeStatus = Health.RED;
                continue;
            }
            if (indexHealth.getStatus() != Health.YELLOW || computeStatus == Health.RED) continue;
            computeStatus = Health.YELLOW;
        }
        if (clusterState.blocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE)) {
            computeStatus = Health.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        if (computeStatus.equals(Health.GREEN)) {
            this.activeShardsPercent = 100.0;
        } else {
            List<ShardRouting> shardRoutings = clusterState.routingTable().allShards();
            int activeShardCount = 0;
            int totalShardCount = 0;
            for (ShardRouting shardRouting : shardRoutings) {
                if (shardRouting.active()) {
                    ++activeShardCount;
                }
                ++totalShardCount;
            }
            this.activeShardsPercent = (double)activeShardCount / (double)totalShardCount * 100.0;
        }
    }

    public ClusterStateHealth(StreamInput in) throws IOException {
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.numberOfNodes = in.readVInt();
        this.numberOfDataNodes = in.readVInt();
        this.status = Health.fromValue(in.readByte());
        int size = in.readVInt();
        this.indices = new HashMap<String, ClusterIndexHealth>(size);
        for (int i = 0; i < size; ++i) {
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(in);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.activeShardsPercent = in.readDouble();
    }

    public ClusterStateHealth(int activePrimaryShards, int activeShards, int relocatingShards, int initializingShards, int unassignedShards, int numberOfNodes, int numberOfDataNodes, double activeShardsPercent, Health status, Map<String, ClusterIndexHealth> indices) {
        this.activePrimaryShards = activePrimaryShards;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.numberOfNodes = numberOfNodes;
        this.numberOfDataNodes = numberOfDataNodes;
        this.activeShardsPercent = activeShardsPercent;
        this.status = status;
        this.indices = indices;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public Health getStatus() {
        return this.status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return Collections.unmodifiableMap(this.indices);
    }

    public double getActiveShardsPercent() {
        return this.activeShardsPercent;
    }

    @Override
    public Iterator<ClusterIndexHealth> iterator() {
        return this.indices.values().iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.numberOfNodes);
        out.writeVInt(this.numberOfDataNodes);
        out.writeByte(this.status.value());
        out.writeVInt(this.indices.size());
        for (ClusterIndexHealth indexHealth : this) {
            indexHealth.writeTo(out);
        }
        out.writeDouble(this.activeShardsPercent);
    }

    public String toString() {
        return "ClusterStateHealth{numberOfNodes=" + this.numberOfNodes + ", numberOfDataNodes=" + this.numberOfDataNodes + ", activeShards=" + this.activeShards + ", relocatingShards=" + this.relocatingShards + ", activePrimaryShards=" + this.activePrimaryShards + ", initializingShards=" + this.initializingShards + ", unassignedShards=" + this.unassignedShards + ", activeShardsPercent=" + this.activeShardsPercent + ", status=" + String.valueOf(this.status) + ", indices.size=" + String.valueOf(this.indices == null ? "null" : Integer.valueOf(this.indices.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateHealth that = (ClusterStateHealth)o;
        return this.numberOfNodes == that.numberOfNodes && this.numberOfDataNodes == that.numberOfDataNodes && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.activePrimaryShards == that.activePrimaryShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && Double.compare(that.activeShardsPercent, this.activeShardsPercent) == 0 && this.status == that.status && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfNodes, this.numberOfDataNodes, this.activeShards, this.relocatingShards, this.activePrimaryShards, this.initializingShards, this.unassignedShards, this.activeShardsPercent, this.status, this.indices);
    }
}

