/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum Health implements Writeable
{
    GREEN,
    YELLOW,
    RED;


    public short severity() {
        return (short)(this.ordinal() + 1);
    }

    public byte value() {
        return (byte)this.ordinal();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.value());
    }

    public static Health readFrom(StreamInput in) throws IOException {
        return Health.fromValue(in.readByte());
    }

    public static Health fromValue(byte value) throws IOException {
        return switch (value) {
            case 0 -> GREEN;
            case 1 -> YELLOW;
            case 2 -> RED;
            default -> throw new IllegalArgumentException("No cluster health status for value [" + value + "]");
        };
    }

    public static Health fromString(String status) {
        if (status.equalsIgnoreCase("green")) {
            return GREEN;
        }
        if (status.equalsIgnoreCase("yellow")) {
            return YELLOW;
        }
        if (status.equalsIgnoreCase("red")) {
            return RED;
        }
        throw new IllegalArgumentException("unknown cluster health status [" + status + "]");
    }
}

