/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.collections.Lists;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.ddl.Templates;
import io.crate.expression.symbol.RefReplacer;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.ForeignTablesMetadata;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.view.ViewsMetadata;
import io.crate.sql.tree.ColumnPolicy;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.Diffs;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.metadata.SchemaMetadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class Metadata
implements Iterable<IndexMetadata>,
Diffable<Metadata> {
    private static final Logger LOGGER = LogManager.getLogger(Metadata.class);
    public static final long COLUMN_OID_UNASSIGNED = 0L;
    public static final String ALL = "_all";
    public static final String UNKNOWN_CLUSTER_UUID = "_na_";
    static final EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Metadata EMPTY_METADATA = Metadata.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private final String clusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long version;
    private final long columnOID;
    private final CoordinationMetadata coordinationMetadata;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final ImmutableOpenMap<String, IndexMetadata> indices;
    private final ImmutableOpenMap<String, IndexTemplateMetadata> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final ImmutableOpenMap<String, SchemaMetadata> schemas;
    private final transient ImmutableOpenMap<String, RelationMetadata> indexUUIDsRelations;
    private final transient int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final int numberOfShards;
    private final SortedMap<String, AliasOrIndex> aliasAndIndexLookup;
    public static final MetadataStateFormat<Metadata> FORMAT = Metadata.createMetadataStateFormat(false);
    public static final MetadataStateFormat<Metadata> FORMAT_PRESERVE_CUSTOMS = Metadata.createMetadataStateFormat(true);

    Metadata(String clusterUUID, boolean clusterUUIDCommitted, long version, long columnOID, CoordinationMetadata coordinationMetadata, Settings transientSettings, Settings persistentSettings, ImmutableOpenMap<String, IndexMetadata> indices, ImmutableOpenMap<String, IndexTemplateMetadata> templates, ImmutableOpenMap<String, Custom> customs, ImmutableOpenMap<String, SchemaMetadata> schemas, SortedMap<String, AliasOrIndex> aliasAndIndexLookup) {
        this.clusterUUID = clusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.version = version;
        this.columnOID = columnOID;
        this.coordinationMetadata = coordinationMetadata;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = Settings.builder().put(persistentSettings).put(transientSettings).build();
        this.indices = indices;
        this.customs = customs;
        this.schemas = schemas;
        this.templates = templates;
        int totalNumberOfShards = 0;
        int totalOpenIndexShards = 0;
        int numberOfShards = 0;
        for (ObjectCursor cursor : indices.values()) {
            IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
            totalNumberOfShards += indexMetadata.getTotalNumberOfShards();
            numberOfShards += indexMetadata.getNumberOfShards();
            if (!IndexMetadata.State.OPEN.equals((Object)indexMetadata.getState())) continue;
            totalOpenIndexShards += indexMetadata.getTotalNumberOfShards();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.numberOfShards = numberOfShards;
        this.aliasAndIndexLookup = aliasAndIndexLookup;
        ImmutableOpenMap.Builder<String, RelationMetadata> indexUUIDsRelationsBuilder = ImmutableOpenMap.builder(indices.size());
        for (ObjectObjectCursor<String, SchemaMetadata> cursor : schemas) {
            SchemaMetadata schema = (SchemaMetadata)cursor.value;
            for (ObjectObjectCursor<String, RelationMetadata> relCursor : schema.relations()) {
                RelationMetadata relationMetadata = (RelationMetadata)relCursor.value;
                for (String indexUUID : relationMetadata.indexUUIDs()) {
                    RelationMetadata old = indexUUIDsRelationsBuilder.put(indexUUID, relationMetadata);
                    assert (old == null) : "A index must not be referenced from multiple relations";
                }
            }
        }
        this.indexUUIDsRelations = indexUUIDsRelationsBuilder.build();
    }

    public long version() {
        return this.version;
    }

    public long columnOID() {
        return this.columnOID;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public boolean clusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.coordinationMetadata;
    }

    public boolean hasAlias(String alias) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)this.getAliasAndIndexLookup().get(alias);
        if (aliasOrIndex != null) {
            return aliasOrIndex.isAlias();
        }
        return false;
    }

    public SortedMap<String, AliasOrIndex> getAliasAndIndexLookup() {
        return this.aliasAndIndexLookup;
    }

    public boolean hasIndex(String indexUUID) {
        return this.indices.containsKey(indexUUID);
    }

    public boolean hasIndex(Index index) {
        return this.indices.containsKey(index.getUUID());
    }

    public boolean hasConcreteIndex(String indexUUID) {
        return this.getAliasAndIndexLookup().containsKey(indexUUID);
    }

    @Nullable
    public IndexMetadata index(String indexUUID) {
        return this.indices.get(indexUUID);
    }

    @Nullable
    public IndexMetadata index(Index index) {
        return this.indices.get(index.getUUID());
    }

    public boolean hasIndexMetadata(IndexMetadata indexMetadata) {
        return this.indices.get(indexMetadata.getIndex().getUUID()) == indexMetadata;
    }

    public IndexMetadata getIndexSafe(Index index) {
        IndexMetadata metadata = this.index(index);
        if (metadata != null) {
            return metadata;
        }
        throw new IndexNotFoundException(index);
    }

    @Nullable
    public IndexMetadata getIndexByName(String indexName) {
        for (ObjectCursor cursor : this.indices.values()) {
            IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
            if (!indexMetadata.getIndex().getName().equals(indexName)) continue;
            return indexMetadata;
        }
        return null;
    }

    public ImmutableOpenMap<String, IndexMetadata> indices() {
        return this.indices;
    }

    @Deprecated
    public ImmutableOpenMap<String, IndexTemplateMetadata> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, SchemaMetadata> schemas() {
        return this.schemas;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends Custom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault(type, defaultValue);
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(Metadata metadata1, Metadata metadata2) {
        if (!metadata1.coordinationMetadata.equals(metadata2.coordinationMetadata)) {
            return false;
        }
        if (!metadata1.persistentSettings.equals(metadata2.persistentSettings)) {
            return false;
        }
        if (!metadata1.templates.equals(metadata2.templates())) {
            return false;
        }
        if (!metadata1.clusterUUID.equals(metadata2.clusterUUID)) {
            return false;
        }
        if (metadata1.clusterUUIDCommitted != metadata2.clusterUUIDCommitted) {
            return false;
        }
        if (metadata1.columnOID != metadata2.columnOID) {
            return false;
        }
        if (!metadata1.schemas.equals(metadata2.schemas)) {
            return false;
        }
        int customCount1 = 0;
        for (ObjectObjectCursor<String, Custom> objectObjectCursor : metadata1.customs) {
            if (!((Custom)objectObjectCursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!((Custom)objectObjectCursor.value).equals(metadata2.custom((String)objectObjectCursor.key))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (ObjectCursor cursor : metadata2.customs.values()) {
            if (!((Custom)cursor.value).context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    @Override
    public Diff<Metadata> diff(Metadata previousState) {
        return new MetadataDiff(previousState, this);
    }

    public static Diff<Metadata> readDiffFrom(StreamInput in) throws IOException {
        return new MetadataDiff(in);
    }

    public static Metadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser, false);
    }

    public static Metadata readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder();
        builder.version = in.readLong();
        if (in.getVersion().onOrAfter(Version.V_5_5_0)) {
            builder.columnOID(in.readLong());
        } else {
            builder.columnOID(0L);
        }
        builder.clusterUUID = in.readString();
        builder.clusterUUIDCommitted = in.readBoolean();
        builder.coordinationMetadata(new CoordinationMetadata(in));
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        int size = in.readVInt();
        for (int i2 = 0; i2 < size; ++i2) {
            builder.put(IndexMetadata.readFrom(in), false);
        }
        if (in.getVersion().before(Version.V_6_0_0)) {
            int templatesSize = in.readVInt();
            for (i = 0; i < templatesSize; ++i) {
                builder.put(IndexTemplateMetadata.readFrom(in));
            }
        }
        int customSize = in.readVInt();
        for (i = 0; i < customSize; ++i) {
            Custom customIndexMetadata = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetadata.getWriteableName(), customIndexMetadata);
        }
        if (in.getVersion().onOrAfter(Version.V_6_0_0)) {
            int numSchemas = in.readVInt();
            for (int i3 = 0; i3 < numSchemas; ++i3) {
                String schemaName = in.readString();
                SchemaMetadata schemaMetadata = SchemaMetadata.of(in);
                builder.put(schemaName, schemaMetadata);
            }
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
            out.writeLong(this.columnOID);
        }
        out.writeString(this.clusterUUID);
        out.writeBoolean(this.clusterUUIDCommitted);
        this.coordinationMetadata.writeTo(out);
        Settings.writeSettingsToStream(out, this.transientSettings);
        Settings.writeSettingsToStream(out, this.persistentSettings);
        out.writeVInt(this.indices.size());
        for (IndexMetadata indexMetadata : this) {
            indexMetadata.writeTo(out);
        }
        if (out.getVersion().before(Version.V_6_0_0)) {
            List<RelationMetadata.Table> partitionedRelations = this.relations(RelationMetadata.Table.class).stream().filter(table -> !table.partitionedBy().isEmpty()).toList();
            out.writeVInt(partitionedRelations.size());
            for (RelationMetadata.Table table2 : partitionedRelations) {
                IndexTemplateMetadata templateMetadata = Templates.of(table2);
                templateMetadata.writeTo(out);
            }
        }
        int numberOfCustoms = 0;
        for (ObjectObjectCursor<String, SchemaMetadata> cursor : this.customs.values()) {
            if (!VersionedNamedWriteable.shouldSerialize(out, (Custom)cursor.value)) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (ObjectObjectCursor<String, SchemaMetadata> cursor : this.customs.values()) {
            if (!VersionedNamedWriteable.shouldSerialize(out, (Custom)cursor.value)) continue;
            out.writeNamedWriteable((NamedWriteable)cursor.value);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0)) {
            out.writeVInt(this.schemas.size());
            for (ObjectObjectCursor<String, SchemaMetadata> cursor : this.schemas) {
                String schemaName = (String)cursor.key;
                SchemaMetadata schema = (SchemaMetadata)cursor.value;
                out.writeString(schemaName);
                schema.writeTo(out);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Metadata metadata) {
        return new Builder(metadata);
    }

    private static MetadataStateFormat<Metadata> createMetadataStateFormat(final boolean preserveUnknownCustoms) {
        return new MetadataStateFormat<Metadata>(GLOBAL_STATE_FILE_PREFIX){

            @Override
            public Metadata fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser, preserveUnknownCustoms);
            }

            @Override
            public Metadata readFrom(StreamInput in) throws IOException {
                return Metadata.readFrom(in);
            }
        };
    }

    public boolean contains(RelationName tableName) {
        if (this.templates.containsKey(PartitionName.templateName(tableName.schema(), tableName.name()))) {
            return true;
        }
        ViewsMetadata views = (ViewsMetadata)this.custom("views");
        if (views != null && views.contains(tableName)) {
            return true;
        }
        ForeignTablesMetadata foreignTables = this.custom("foreign_tables", ForeignTablesMetadata.EMPTY);
        if (foreignTables.contains(tableName)) {
            return true;
        }
        SchemaMetadata schemaMetadata = this.schemas.get(tableName.schema());
        if (schemaMetadata != null && schemaMetadata.relations().containsKey(tableName.name())) {
            return true;
        }
        return this.getRelation(tableName) != null;
    }

    @Nullable
    public <T extends RelationMetadata> T getRelation(RelationName relation) {
        return Metadata.getRelation(relation, this.schemas::get);
    }

    @Nullable
    public RelationMetadata getRelation(String indexUUID) {
        return this.indexUUIDsRelations.get(indexUUID);
    }

    public PartitionName getPartitionName(String indexUUID) {
        RelationMetadata relationMetadata = this.getRelation(indexUUID);
        if (relationMetadata == null) {
            throw new RelationUnknown(String.format(Locale.ENGLISH, "Relation not found for indexUUID=%s", indexUUID));
        }
        return this.getPartitionName(relationMetadata.name(), indexUUID);
    }

    public PartitionName getPartitionName(RelationName relationName, String indexUUID) {
        IndexMetadata indexMetadata = this.index(indexUUID);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(String.format(Locale.ENGLISH, "Index metadata not found for indexUUID=%s", indexUUID));
        }
        return new PartitionName(relationName, indexMetadata.partitionValues());
    }

    public <T extends RelationMetadata> List<T> relations(Class<T> clazz) {
        return this.relations(clazz::isInstance, clazz::cast);
    }

    public <T extends RelationMetadata> List<T> relations(String schemaName, Class<T> clazz) {
        SchemaMetadata schemaMetadata = this.schemas.get(schemaName);
        if (schemaMetadata == null) {
            return List.of();
        }
        ArrayList<RelationMetadata> relations = new ArrayList<RelationMetadata>();
        for (ObjectCursor relationCursor : schemaMetadata.relations().values()) {
            RelationMetadata relationMetadata = (RelationMetadata)relationCursor.value;
            if (!clazz.isInstance(relationMetadata)) continue;
            relations.add((RelationMetadata)clazz.cast(relationMetadata));
        }
        return relations;
    }

    public <T> List<T> relations(Predicate<RelationMetadata> predicate, Function<RelationMetadata, T> as) {
        ArrayList<RelationMetadata> relations = new ArrayList<RelationMetadata>();
        for (ObjectCursor cursor : this.schemas.values()) {
            for (ObjectCursor relationCursor : ((SchemaMetadata)cursor.value).relations().values()) {
                if (!predicate.test((RelationMetadata)relationCursor.value)) continue;
                relations.add(as.apply((RelationMetadata)relationCursor.value));
            }
        }
        return relations;
    }

    public <T> List<T> getIndices(List<PartitionName> partitions, boolean strict, Function<IndexMetadata, T> as) {
        if (partitions.isEmpty()) {
            ArrayList allIndices = new ArrayList();
            this.indices.values().forEach(value -> allIndices.add(as.apply((IndexMetadata)value)));
            return allIndices;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (PartitionName r : partitions) {
            result.addAll(this.getIndices(r.relationName(), r.values(), strict, as));
        }
        return result;
    }

    public <T> List<T> getIndices(RelationName relationName, List<String> partitionValues, boolean strict, Function<IndexMetadata, T> as) {
        T relation;
        T t = relation = this.getRelation(relationName);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RelationMetadata.BlobTable.class, RelationMetadata.Table.class}, t, n)) {
            case -1: {
                if (strict) {
                    throw new RelationUnknown(relationName);
                }
                return List.of();
            }
            case 0: {
                RelationMetadata.BlobTable blobTable = (RelationMetadata.BlobTable)t;
                IndexMetadata imd = this.index(blobTable.indexUUID());
                if (imd == null) {
                    throw new RelationUnknown(relationName);
                }
                T item = as.apply(imd);
                if (item != null) {
                    return List.of(item);
                }
                return List.of();
            }
            case 1: {
                RelationMetadata.Table table = (RelationMetadata.Table)t;
                List<String> indexUUIDs = table.indexUUIDs();
                ArrayList<T> result = new ArrayList<T>(indexUUIDs.size());
                for (String indexUUID : indexUUIDs) {
                    T item;
                    IndexMetadata imd = this.index(indexUUID);
                    if (imd == null) {
                        if (!strict) continue;
                        throw new RelationUnknown(relationName);
                    }
                    if (!partitionValues.isEmpty() && !partitionValues.equals(imd.partitionValues()) || (item = as.apply(imd)) == null) continue;
                    result.add(item);
                }
                return result;
            }
        }
        throw new UnsupportedOperationException("Unsupported relation type: " + relation.getClass().getName());
    }

    @Nullable
    public <T> T getIndex(RelationName relationName, List<String> partitionValues, boolean strict, Function<IndexMetadata, T> as) {
        List<T> indices = this.getIndices(relationName, partitionValues, strict, as);
        if (indices.size() > 1) {
            throw new IllegalArgumentException("Expected a single index for " + String.valueOf(relationName) + " but got " + indices.size());
        }
        if (indices.size() == 1) {
            return indices.getFirst();
        }
        return null;
    }

    private static <T extends RelationMetadata> T getRelation(RelationName relation, Function<String, SchemaMetadata> schemaResolver) {
        SchemaMetadata schemaMetadata = schemaResolver.apply(relation.schema());
        if (schemaMetadata == null) {
            return null;
        }
        RelationMetadata relationMetadata = schemaMetadata.get(relation);
        if (relationMetadata == null) {
            return null;
        }
        try {
            return (T)relationMetadata;
        }
        catch (ClassCastException e) {
            throw new OperationOnInaccessibleRelationException(relation, "The relation " + relation.sqlFqn() + " doesn't support the operation");
        }
    }

    public static interface Custom
    extends NamedDiffable<Custom> {
        public EnumSet<XContentContext> context();
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }

    private static class MetadataDiff
    implements Diff<Metadata> {
        private final long version;
        private final long columnOID;
        private final String clusterUUID;
        private final boolean clusterUUIDCommitted;
        private final CoordinationMetadata coordinationMetadata;
        private final Settings transientSettings;
        private final Settings persistentSettings;
        private final Diff<ImmutableOpenMap<String, IndexMetadata>> indices;
        private final Diff<ImmutableOpenMap<String, IndexTemplateMetadata>> templates;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;
        private final Diff<ImmutableOpenMap<String, SchemaMetadata>> schemas;
        private static final Diffs.DiffableValueReader<String, IndexMetadata> INDEX_METADATA_DIFF_VALUE_READER = new Diffs.DiffableValueReader(IndexMetadata::readFrom, IndexMetadata::readDiffFrom);
        private static final Diffs.DiffableValueReader<String, IndexTemplateMetadata> TEMPLATES_DIFF_VALUE_READER = new Diffs.DiffableValueReader(IndexTemplateMetadata::readFrom, IndexTemplateMetadata::readDiffFrom);
        private static final Diffs.DiffableValueReader<String, SchemaMetadata> SCHEMA_DIFF_VALUE_READER = new Diffs.DiffableValueReader(SchemaMetadata::of, SchemaMetadata::readDiffFrom);

        MetadataDiff(Metadata before, Metadata after) {
            this.clusterUUID = after.clusterUUID;
            this.clusterUUIDCommitted = after.clusterUUIDCommitted;
            this.version = after.version;
            this.columnOID = after.columnOID;
            this.coordinationMetadata = after.coordinationMetadata;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            this.indices = Diffs.diff(before.indices, after.indices, Diffs.stringKeySerializer());
            this.templates = Diffs.diff(before.templates, after.templates, Diffs.stringKeySerializer());
            this.customs = Diffs.diff(before.customs, after.customs, Diffs.stringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
            this.schemas = Diffs.diff(before.schemas, after.schemas, Diffs.stringKeySerializer());
        }

        MetadataDiff(StreamInput in) throws IOException {
            this.clusterUUID = in.readString();
            this.clusterUUIDCommitted = in.readBoolean();
            this.version = in.readLong();
            this.columnOID = in.getVersion().onOrAfter(Version.V_5_5_0) ? in.readLong() : 0L;
            this.coordinationMetadata = new CoordinationMetadata(in);
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.indices = Diffs.readMapDiff(in, Diffs.stringKeySerializer(), INDEX_METADATA_DIFF_VALUE_READER);
            this.templates = Diffs.readMapDiff(in, Diffs.stringKeySerializer(), TEMPLATES_DIFF_VALUE_READER);
            this.customs = Diffs.readMapDiff(in, Diffs.stringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
            this.schemas = in.getVersion().onOrAfter(Version.V_6_0_0) ? Diffs.readMapDiff(in, Diffs.stringKeySerializer(), SCHEMA_DIFF_VALUE_READER) : Diffs.diff(ImmutableOpenMap.of(), ImmutableOpenMap.of(), Diffs.stringKeySerializer());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.clusterUUID);
            out.writeBoolean(this.clusterUUIDCommitted);
            out.writeLong(this.version);
            if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
                out.writeLong(this.columnOID);
            }
            this.coordinationMetadata.writeTo(out);
            Settings.writeSettingsToStream(out, this.transientSettings);
            Settings.writeSettingsToStream(out, this.persistentSettings);
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_0_0)) {
                this.schemas.writeTo(out);
            }
        }

        @Override
        public Metadata apply(Metadata part) {
            Builder builder = Metadata.builder();
            builder.clusterUUID(this.clusterUUID);
            builder.clusterUUIDCommitted(this.clusterUUIDCommitted);
            builder.version(this.version);
            builder.columnOID(this.columnOID);
            builder.coordinationMetadata(this.coordinationMetadata);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.indices(this.indices.apply(part.indices));
            builder.templates(this.templates.apply(part.templates));
            builder.customs(this.customs.apply(part.customs));
            builder.schemas.putAll((Iterable<ObjectObjectCursor<String, SchemaMetadata>>)this.schemas.apply(part.schemas));
            return builder.build();
        }
    }

    public static class Builder {
        public static final LongSupplier NO_OID_COLUMN_OID_SUPPLIER = () -> 0L;
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private long version;
        private ColumnOidSupplier columnOidSupplier;
        private CoordinationMetadata coordinationMetadata = CoordinationMetadata.EMPTY_METADATA;
        private Settings transientSettings = Settings.EMPTY;
        private Settings persistentSettings = Settings.EMPTY;
        private final ImmutableOpenMap.Builder<String, IndexMetadata> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetadata> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private final ImmutableOpenMap.Builder<String, SchemaMetadata> schemas;

        public Builder() {
            this.clusterUUID = Metadata.UNKNOWN_CLUSTER_UUID;
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.schemas = ImmutableOpenMap.builder();
            this.columnOidSupplier = new ColumnOidSupplier(0L);
            this.indexGraveyard(IndexGraveyard.builder().build());
        }

        public Builder(Metadata metadata) {
            this.clusterUUID = metadata.clusterUUID;
            this.clusterUUIDCommitted = metadata.clusterUUIDCommitted;
            this.coordinationMetadata = metadata.coordinationMetadata;
            this.transientSettings = metadata.transientSettings;
            this.persistentSettings = metadata.persistentSettings;
            this.version = metadata.version;
            this.columnOidSupplier = new ColumnOidSupplier(metadata.columnOID);
            this.indices = ImmutableOpenMap.builder(metadata.indices);
            this.templates = ImmutableOpenMap.builder(metadata.templates);
            this.customs = ImmutableOpenMap.builder(metadata.customs);
            this.schemas = ImmutableOpenMap.builder(metadata.schemas);
        }

        public Builder put(IndexMetadata.Builder indexMetadataBuilder) {
            indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
            IndexMetadata indexMetadata = indexMetadataBuilder.build();
            this.indices.put(indexMetadata.getIndex().getUUID(), indexMetadata);
            return this;
        }

        public Builder put(IndexMetadata indexMetadata, boolean incrementVersion) {
            if (this.indices.get(indexMetadata.getIndex().getUUID()) == indexMetadata) {
                return this;
            }
            if (incrementVersion) {
                indexMetadata = IndexMetadata.builder(indexMetadata).version(indexMetadata.getVersion() + 1L).build();
            }
            this.indices.put(indexMetadata.getIndex().getUUID(), indexMetadata);
            return this;
        }

        public Builder putWithIndexName(IndexMetadata indexMetadata) {
            this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            return this;
        }

        public IndexMetadata get(String indexUUID) {
            return this.indices.get(indexUUID);
        }

        public IndexMetadata getSafe(Index index) {
            IndexMetadata indexMetadata = this.get(index.getUUID());
            if (indexMetadata != null) {
                return indexMetadata;
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String indexUUID) {
            this.indices.remove(indexUUID);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder indices(ImmutableOpenMap<String, IndexMetadata> indices) {
            this.indices.putAll(indices);
            return this;
        }

        @Deprecated
        public Builder put(IndexTemplateMetadata template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder put(String schemaName, SchemaMetadata schemaMetadata) {
            this.schemas.put(schemaName, schemaMetadata);
            return this;
        }

        public Builder dropRelation(RelationName relationName) {
            SchemaMetadata schemaMetadata = this.schemas.get(relationName.schema());
            if (schemaMetadata == null) {
                return this;
            }
            ImmutableOpenMap<String, RelationMetadata> newRelations = ImmutableOpenMap.builder(schemaMetadata.relations()).fRemove(relationName.name()).build();
            if (newRelations.isEmpty()) {
                this.schemas.remove(relationName.schema());
            } else {
                this.schemas.put(relationName.schema(), new SchemaMetadata(newRelations));
            }
            return this;
        }

        @Nullable
        public <T extends RelationMetadata> T getRelation(RelationName relation) {
            return Metadata.getRelation(relation, this.schemas::get);
        }

        public Builder setBlobTable(RelationName name, String indexUUID, Settings settings, IndexMetadata.State state) {
            this.setRelation(new RelationMetadata.BlobTable(name, indexUUID, settings, state));
            return this;
        }

        public void setRelation(RelationMetadata relation) {
            RelationName relationName = relation.name();
            String schema = relationName.schema();
            SchemaMetadata schemaMetadata = this.schemas.get(schema);
            ImmutableOpenMap<String, RelationMetadata> relations = schemaMetadata == null ? ImmutableOpenMap.builder(1).fPut(relationName.name(), relation).build() : ImmutableOpenMap.builder(schemaMetadata.relations()).fPut(relationName.name(), relation).build();
            this.schemas.put(schema, new SchemaMetadata(relations));
        }

        @Deprecated
        public IndexTemplateMetadata getTemplate(String templateName) {
            return this.templates.get(templateName);
        }

        @Deprecated
        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        @Deprecated
        public Builder templates(ImmutableOpenMap<String, IndexTemplateMetadata> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            this.customs.putAll(customs);
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            this.putCustom("index-graveyard", indexGraveyard);
            return this;
        }

        public IndexGraveyard indexGraveyard() {
            IndexGraveyard graveyard = (IndexGraveyard)this.getCustom("index-graveyard");
            return graveyard;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indicesUUIDs) {
            for (String indexUUID : indicesUUIDs) {
                IndexMetadata indexMetadata = this.indices.get(indexUUID);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(indexUUID);
                }
                this.put(IndexMetadata.builder(indexMetadata).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public void updateNumberOfReplicas(int numberOfReplicas, List<IndexMetadata> indexes) {
            for (IndexMetadata im : indexes) {
                this.put(IndexMetadata.builder(im).numberOfReplicas(numberOfReplicas));
            }
        }

        public Builder coordinationMetadata(CoordinationMetadata coordinationMetadata) {
            this.coordinationMetadata = coordinationMetadata;
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder columnOID(long columnOID) {
            this.columnOidSupplier = new ColumnOidSupplier(columnOID);
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals(Metadata.UNKNOWN_CLUSTER_UUID)) {
                this.clusterUUID = UUIDs.randomBase64UUID();
            }
            return this;
        }

        public LongSupplier columnOidSupplier() {
            return this.columnOidSupplier;
        }

        public Metadata build() {
            HashSet<String> allIndices = new HashSet<String>(this.indices.size());
            HashSet duplicateAliasesIndices = new HashSet();
            for (ObjectCursor cursor : this.indices.values()) {
                IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                String uuid = indexMetadata.getIndex().getUUID();
                boolean added = allIndices.add(uuid);
                assert (added) : "double index named [" + uuid + "]";
                indexMetadata.getAliases().keysIt().forEachRemaining(duplicateAliasesIndices::add);
            }
            duplicateAliasesIndices.retainAll(allIndices);
            if (!duplicateAliasesIndices.isEmpty()) {
                ArrayList<CallSite> duplicates = new ArrayList<CallSite>();
                for (ObjectCursor cursor : this.indices.values()) {
                    for (String alias : duplicateAliasesIndices) {
                        if (!((IndexMetadata)cursor.value).getAliases().containsKey(alias)) continue;
                        duplicates.add((CallSite)((Object)(alias + " (alias of " + String.valueOf(((IndexMetadata)cursor.value).getIndex()) + ")")));
                    }
                }
                assert (duplicates.size() > 0);
                throw new IllegalStateException("index and alias names need to be unique, but the following duplicates were found [" + String.join((CharSequence)", ", duplicates) + "]");
            }
            SortedMap<String, AliasOrIndex> aliasAndIndexLookup = Collections.unmodifiableSortedMap(this.buildAliasAndIndexLookup());
            return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.columnOidSupplier.columnOID, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.indices.build(), this.templates.build(), this.customs.build(), this.schemas.build(), aliasAndIndexLookup);
        }

        private SortedMap<String, AliasOrIndex> buildAliasAndIndexLookup() {
            TreeMap<String, AliasOrIndex> aliasAndIndexLookup = new TreeMap<String, AliasOrIndex>();
            for (ObjectCursor cursor : this.indices.values()) {
                IndexMetadata indexMetadata = (IndexMetadata)cursor.value;
                if (indexMetadata.getCreationVersion().onOrAfter(Version.V_6_0_0)) continue;
                AliasOrIndex existing = aliasAndIndexLookup.put(indexMetadata.getIndex().getName(), new AliasOrIndex.Index(indexMetadata));
                assert (existing == null) : "duplicate for " + String.valueOf(indexMetadata.getIndex());
                for (ObjectObjectCursor<String, AliasMetadata> aliasCursor : indexMetadata.getAliases()) {
                    AliasMetadata aliasMetadata = (AliasMetadata)aliasCursor.value;
                    aliasAndIndexLookup.compute(aliasMetadata.getAlias(), (aliasName, alias) -> {
                        if (alias == null) {
                            return new AliasOrIndex.Alias(aliasMetadata, indexMetadata);
                        }
                        assert (alias instanceof AliasOrIndex.Alias) : alias.getClass().getName();
                        ((AliasOrIndex.Alias)alias).addIndex(indexMetadata);
                        return alias;
                    });
                }
            }
            return aliasAndIndexLookup;
        }

        public static Metadata fromXContent(XContentParser parser, boolean preserveUnknownCustoms) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    if (token != XContentParser.Token.FIELD_NAME) {
                        throw new IllegalArgumentException("Expected a field name but got " + String.valueOf(token));
                    }
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(parser.currentName())) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected a START_OBJECT but got " + String.valueOf(token));
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("cluster_coordination".equals(currentFieldName)) {
                        builder.coordinationMetadata(CoordinationMetadata.fromXContent(parser));
                        continue;
                    }
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.fromXContent(parser));
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetadata.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName()));
                        }
                        continue;
                    }
                    try {
                        Custom custom = (Custom)parser.namedObject(Custom.class, currentFieldName, null);
                        builder.putCustom(custom.getWriteableName(), custom);
                    }
                    catch (NamedObjectNotFoundException ex) {
                        if (preserveUnknownCustoms) {
                            LOGGER.warn("Adding unknown custom object with type {}", (Object)currentFieldName);
                            parser.mapOrdered();
                            builder.putCustom(currentFieldName, new UnknownGatewayOnlyCustom());
                            continue;
                        }
                        LOGGER.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("version".equals(currentFieldName)) {
                        builder.version = parser.longValue();
                        continue;
                    }
                    if ("column_oid".equals(currentFieldName)) {
                        builder.columnOidSupplier = new ColumnOidSupplier(parser.longValue());
                        continue;
                    }
                    if ("cluster_uuid".equals(currentFieldName) || "uuid".equals(currentFieldName)) {
                        builder.clusterUUID = parser.text();
                        continue;
                    }
                    if ("cluster_uuid_committed".equals(currentFieldName)) {
                        builder.clusterUUIDCommitted = parser.booleanValue();
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + String.valueOf(token));
            }
            return builder.build();
        }

        @VisibleForTesting
        public Builder setTable(LongSupplier oidSupplier, RelationName relationName, List<Reference> columns, Settings settings, @Nullable ColumnIdent routingColumn, ColumnPolicy columnPolicy, @Nullable String pkConstraintName, Map<String, String> checkConstraints, List<ColumnIdent> primaryKeys, List<ColumnIdent> partitionedBy, IndexMetadata.State state, List<String> indexUUIDs, long tableVersion) {
            AtomicInteger positions = new AtomicInteger(0);
            Map<ColumnIdent, Reference> columnMap = columns.stream().filter(ref -> !ref.isDropped()).map(ref -> ref.withOidAndPosition(oidSupplier, positions::incrementAndGet)).collect(Collectors.toMap(ref -> ref.column(), ref -> ref));
            ArrayList<Reference> finalColumns = new ArrayList<Reference>(columns.size());
            for (Reference column : columnMap.values()) {
                Reference newRef;
                if (column instanceof GeneratedReference) {
                    GeneratedReference genRef = (GeneratedReference)column;
                    newRef = new GeneratedReference(genRef.reference(), RefReplacer.replaceRefs(genRef.generatedExpression(), ref -> (Symbol)columnMap.get(ref.column())));
                } else if (column instanceof IndexReference) {
                    IndexReference indexRef = (IndexReference)column;
                    List newColumns = Lists.map(indexRef.columns(), x -> Objects.requireNonNull((Reference)columnMap.get(x.column())));
                    newRef = indexRef.withColumns(newColumns);
                } else {
                    newRef = column;
                }
                finalColumns.add(newRef);
            }
            columns.stream().filter(Reference::isDropped).forEach(ref -> finalColumns.add((Reference)ref));
            RelationMetadata.Table table = new RelationMetadata.Table(relationName, finalColumns, settings, routingColumn, columnPolicy, pkConstraintName, checkConstraints, primaryKeys, partitionedBy, state, indexUUIDs, tableVersion);
            this.setRelation(table);
            return this;
        }

        public Builder setTable(RelationName relationName, List<Reference> columns, Settings settings, @Nullable ColumnIdent routingColumn, ColumnPolicy columnPolicy, @Nullable String pkConstraintName, Map<String, String> checkConstraints, List<ColumnIdent> primaryKeys, List<ColumnIdent> partitionedBy, IndexMetadata.State state, List<String> indexUUIDs, long tableVersion) {
            return this.setTable(this.columnOidSupplier, relationName, columns, settings, routingColumn, columnPolicy, pkConstraintName, checkConstraints, primaryKeys, partitionedBy, state, indexUUIDs, tableVersion);
        }

        public Builder addIndexUUIDs(RelationMetadata.Table table, List<String> indexUUIDs) {
            RelationMetadata.Table updatedTable = new RelationMetadata.Table(table.name(), table.columns(), table.settings(), table.routingColumn(), table.columnPolicy(), table.pkConstraintName(), table.checkConstraints(), table.primaryKeys(), table.partitionedBy(), table.state(), Lists.concat(table.indexUUIDs(), indexUUIDs), table.tableVersion() + 1L);
            this.setRelation(updatedTable);
            return this;
        }
    }

    public static class UnknownGatewayOnlyCustom
    implements Custom {
        UnknownGatewayOnlyCustom() {
        }

        @Override
        public EnumSet<XContentContext> context() {
            return EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
        }

        @Override
        public Diff<Custom> diff(Custom previousState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWriteableName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Version getMinimalSupportedVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class ColumnOidSupplier
    implements LongSupplier {
        private long columnOID;

        @VisibleForTesting
        public ColumnOidSupplier(long columnOID) {
            this.columnOID = columnOID;
        }

        @Override
        public long getAsLong() {
            ++this.columnOID;
            return this.columnOID;
        }
    }
}

