/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.blob.v2.BlobIndex;
import io.crate.expression.udf.UserDefinedFunctionService;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoFactory;
import io.crate.metadata.upgrade.MetadataIndexUpgrader;
import io.crate.sql.tree.CheckConstraint;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MetadataUpgradeService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataUpgradeService.class);
    private final IndexScopedSettings indexScopedSettings;
    private final MetadataIndexUpgrader indexUpgrader;
    private final DocTableInfoFactory tableFactory;
    private final UserDefinedFunctionService userDefinedFunctionService;

    public MetadataUpgradeService(NodeContext nodeContext, IndexScopedSettings indexScopedSettings, UserDefinedFunctionService userDefinedFunctionService) {
        this.tableFactory = new DocTableInfoFactory(nodeContext);
        this.indexScopedSettings = indexScopedSettings;
        this.indexUpgrader = new MetadataIndexUpgrader();
        this.userDefinedFunctionService = userDefinedFunctionService;
    }

    public Metadata upgradeMetadata(Metadata metadata) {
        Object relation;
        Metadata.Builder newMetadata = Metadata.builder(metadata);
        UserDefinedFunctionsMetadata udfMetadata = (UserDefinedFunctionsMetadata)metadata.custom("user_defined_functions");
        if (udfMetadata != null) {
            this.userDefinedFunctionService.updateImplementations(udfMetadata.functionsMetadata());
        }
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : metadata.templates()) {
            String templateName = (String)objectObjectCursor.key;
            newMetadata.removeTemplate(templateName);
            if (templateName == "crate_defaults") continue;
            IndexTemplateMetadata template = (IndexTemplateMetadata)objectObjectCursor.value;
            RelationName relationName = IndexName.decode(template.name()).toRelationName();
            relation = metadata.getRelation(relationName);
            assert (relation == null) : "If there is still a template present there shouldn't be any RelationMetadata";
            DocTableInfo docTable = this.tableFactory.create(template, metadata);
            Version versionCreated = MetadataUpgradeService.getFixedVersionCreated(metadata, docTable);
            Settings settings = Settings.builder().put(MetadataUpgradeService.pruneArchived(template.settings())).put("index.version.created", versionCreated).put("index.version.upgraded", Version.CURRENT).build();
            newMetadata.setTable(versionCreated.before(DocTableInfo.COLUMN_OID_VERSION) ? Metadata.Builder.NO_OID_COLUMN_OID_SUPPLIER : newMetadata.columnOidSupplier(), relationName, docTable.allReferences(), settings, docTable.clusteredBy(), docTable.columnPolicy(), docTable.pkConstraintName(), docTable.checkConstraints().stream().collect(Collectors.toMap(CheckConstraint::name, CheckConstraint::expressionStr)), docTable.primaryKey(), docTable.partitionedBy(), docTable.isClosed() ? IndexMetadata.State.CLOSE : IndexMetadata.State.OPEN, List.of(), docTable.tableVersion());
        }
        Iterator<Object> iterator = metadata.iterator();
        while (iterator.hasNext()) {
            IndexMetadata indexMetadata;
            String indexName = (indexMetadata = (IndexMetadata)iterator.next()).getIndex().getName();
            IndexMetadata newIndexMetadata = this.upgradeIndexMetadata(indexMetadata, IndexName.isPartitioned(indexName) ? newMetadata.getTemplate(PartitionName.templateName(indexName)) : null, Version.CURRENT.minimumIndexCompatibilityVersion());
            newMetadata.remove(indexName);
            newMetadata.put(newIndexMetadata, false);
            String indexUUID = indexMetadata.getIndexUUID();
            relation = metadata.getRelation(indexUUID);
            DocTableInfo tableInfo = null;
            if (relation == null) {
                IndexParts indexParts = IndexName.decode(indexName);
                RelationName relationName = indexParts.toRelationName();
                relation = newMetadata.getRelation(relationName);
                if (!BlobIndex.isBlobIndex(indexName)) {
                    tableInfo = this.tableFactory.create(newIndexMetadata);
                }
            }
            if (relation == null) {
                if (tableInfo instanceof DocTableInfo) {
                    DocTableInfo docTable = tableInfo;
                    LongSupplier columnOidSupplier = docTable.versionCreated().before(DocTableInfo.COLUMN_OID_VERSION) ? Metadata.Builder.NO_OID_COLUMN_OID_SUPPLIER : newMetadata.columnOidSupplier();
                    newMetadata.setTable(columnOidSupplier, docTable.ident(), docTable.allReferences(), newIndexMetadata.getSettings(), docTable.clusteredBy(), docTable.columnPolicy(), docTable.pkConstraintName(), docTable.checkConstraints().stream().collect(Collectors.toMap(CheckConstraint::name, CheckConstraint::expressionStr)), docTable.primaryKey(), docTable.partitionedBy(), newIndexMetadata.getState(), List.of(newIndexMetadata.getIndexUUID()), docTable.tableVersion());
                    continue;
                }
                if (BlobIndex.isBlobIndex(indexName)) {
                    newMetadata.setBlobTable(RelationName.fromIndexName(indexName), indexUUID, newIndexMetadata.getSettings(), newIndexMetadata.getState());
                    continue;
                }
                throw new AssertionError((Object)"If the relation is missing we need a DocTableInfo instance or it must be a blob index");
            }
            if (relation instanceof RelationMetadata.Table) {
                RelationMetadata.Table table = (RelationMetadata.Table)relation;
                if (table.indexUUIDs().contains(indexUUID)) continue;
                newMetadata.addIndexUUIDs(table, List.of(indexUUID));
                continue;
            }
            if (!(relation instanceof RelationMetadata.BlobTable)) continue;
            RelationMetadata.BlobTable blobTable = (RelationMetadata.BlobTable)relation;
            assert (blobTable.indexUUID().equals(indexUUID)) : "If there exists a RelationMetadata.BlobTable entry the incoming IndexMetadata indexUUID must match";
        }
        return newMetadata.build();
    }

    private static Settings pruneArchived(Settings settings) {
        return IndexScopedSettings.DEFAULT_SCOPED_SETTINGS.archiveUnknownOrInvalidSettings(settings, entry -> {}, (entry, illegalArgumentException) -> {}).filter(k -> !k.startsWith("archived."));
    }

    private static Version getFixedVersionCreated(Metadata metadata, DocTableInfo docTable) {
        Index[] concreteIndices;
        Version versionCreated = docTable.versionCreated();
        RelationName relationName = docTable.ident();
        for (Index index : concreteIndices = IndexNameExpressionResolver.concreteIndices(metadata, IndicesOptions.LENIENT_EXPAND_OPEN, PartitionName.templatePrefix(relationName.schema(), relationName.name()))) {
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null) continue;
            versionCreated = Version.min(versionCreated, indexMetadata.getCreationVersion());
        }
        if (versionCreated.onOrAfter(DocTableInfo.COLUMN_OID_VERSION) && docTable.rootColumns().stream().anyMatch(ref -> ref.oid() == 0L)) {
            versionCreated = Version.V_5_4_0;
        }
        return versionCreated;
    }

    public IndexMetadata upgradeIndexMetadata(IndexMetadata indexMetadata, @Nullable IndexTemplateMetadata indexTemplateMetadata, Version minimumIndexCompatibilityVersion) {
        if (this.isUpgraded(indexMetadata)) {
            return indexMetadata;
        }
        this.checkSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion);
        IndexMetadata newMetadata = indexMetadata;
        newMetadata = this.archiveBrokenIndexSettings(newMetadata);
        newMetadata = this.indexUpgrader.upgrade(newMetadata, indexTemplateMetadata);
        this.checkMappingsCompatibility(newMetadata);
        return this.markAsUpgraded(newMetadata);
    }

    private boolean isUpgraded(IndexMetadata indexMetadata) {
        return indexMetadata.getCreationVersion().onOrAfter(Version.CURRENT) || indexMetadata.getUpgradedVersion().onOrAfter(Version.CURRENT);
    }

    private void checkSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        if (indexMetadata.getState() == IndexMetadata.State.OPEN && !MetadataUpgradeService.isSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion)) {
            throw new IllegalStateException("The index [" + String.valueOf(indexMetadata.getIndex()) + "] was created with version [" + String.valueOf(indexMetadata.getCreationVersion()) + "] but the minimum compatible version is [" + String.valueOf(minimumIndexCompatibilityVersion) + "].It should be re-indexed in the previous major version of CrateDB before upgrading to " + String.valueOf(Version.CURRENT) + ".");
        }
    }

    private static boolean isSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        return indexMetadata.getCreationVersion().onOrAfter(minimumIndexCompatibilityVersion);
    }

    @VisibleForTesting
    void checkMappingsCompatibility(IndexMetadata indexMetadata) {
        try {
            this.tableFactory.create(indexMetadata);
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + String.valueOf(indexMetadata.getIndex()) + "]", ex);
        }
    }

    private IndexMetadata markAsUpgraded(IndexMetadata indexMetadata) {
        Settings settings = Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetadata.builder(indexMetadata).settings(settings).build();
    }

    private IndexMetadata archiveBrokenIndexSettings(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        Settings upgrade = this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> LOGGER.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetadata.getIndex(), e.getKey(), e.getValue()), (e, ex) -> LOGGER.warn(() -> new ParameterizedMessage("{} ignoring invalid index setting: [{}] with value [{}]; archiving", new Object[]{indexMetadata.getIndex(), e.getKey(), e.getValue()}), (Throwable)ex));
        if (upgrade != settings) {
            return IndexMetadata.builder(indexMetadata).settings(upgrade).build();
        }
        return indexMetadata;
    }
}

