/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.ColumnPolicy;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public sealed interface RelationMetadata
extends Writeable {
    public short ord();

    public RelationName name();

    public static RelationMetadata of(StreamInput in) throws IOException {
        short ord = in.readShort();
        return switch (ord) {
            case 0 -> BlobTable.of(in);
            case 1 -> Table.of(in);
            default -> throw new IllegalArgumentException("Invalid RelationMetadata ord: " + ord);
        };
    }

    public List<String> indexUUIDs();

    public static void toStream(StreamOutput out, RelationMetadata v) throws IOException {
        out.writeShort(v.ord());
        v.writeTo(out);
    }

    public RelationMetadata withIndexUUIDs(List<String> var1);

    public record BlobTable(RelationName name, String indexUUID, Settings settings, IndexMetadata.State state) implements RelationMetadata
    {
        private static final short ORD = 0;

        static BlobTable of(StreamInput in) throws IOException {
            RelationName name = new RelationName(in);
            String indexUUID = in.readString();
            Settings settings = Settings.readSettingsFromStream(in);
            IndexMetadata.State state = in.readEnum(IndexMetadata.State.class);
            return new BlobTable(name, indexUUID, settings, state);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.name.writeTo(out);
            out.writeString(this.indexUUID);
            Settings.writeSettingsToStream(out, this.settings);
            out.writeEnum(this.state);
        }

        @Override
        public short ord() {
            return 0;
        }

        @Override
        public List<String> indexUUIDs() {
            return List.of(this.indexUUID);
        }

        @Override
        public RelationMetadata withIndexUUIDs(List<String> indexUUIDs) {
            assert (indexUUIDs.size() == 1) : "Must have exactly one index linked with blob table";
            return new BlobTable(this.name, indexUUIDs.getFirst(), this.settings, this.state);
        }
    }

    public record Table(RelationName name, List<Reference> columns, Settings settings, @Nullable ColumnIdent routingColumn, ColumnPolicy columnPolicy, @Nullable String pkConstraintName, Map<String, String> checkConstraints, List<ColumnIdent> primaryKeys, List<ColumnIdent> partitionedBy, IndexMetadata.State state, List<String> indexUUIDs, long tableVersion) implements RelationMetadata
    {
        private static final short ORD = 1;

        public Table(RelationName name, List<Reference> columns, Settings settings, @Nullable ColumnIdent routingColumn, ColumnPolicy columnPolicy, @Nullable String pkConstraintName, Map<String, String> checkConstraints, List<ColumnIdent> primaryKeys, List<ColumnIdent> partitionedBy, IndexMetadata.State state, List<String> indexUUIDs, long tableVersion) {
            assert (partitionedBy.isEmpty() && indexUUIDs.size() == 1 || !partitionedBy.isEmpty()) : "Non-Partitioned table " + String.valueOf(name) + " must have exactly one indexUUID: " + String.valueOf(indexUUIDs);
            assert (settings.hasValue("index.version.created")) : "Must have version created setting";
        }

        @Override
        public short ord() {
            return 1;
        }

        public static Table of(StreamInput in) throws IOException {
            RelationName name = new RelationName(in);
            List<Reference> columns = in.readList(Reference::fromStream);
            Settings settings = Settings.readSettingsFromStream(in);
            ColumnIdent routingColumn = in.readOptionalWriteable(ColumnIdent::of);
            ColumnPolicy columnPolicy = (ColumnPolicy)ColumnPolicy.VALUES.get(in.readVInt());
            String pkConstraintName = in.readOptionalString();
            Map<String, String> checkConstraints = in.readMap(LinkedHashMap::new, StreamInput::readString, StreamInput::readString);
            List<ColumnIdent> primaryKeys = in.readList(ColumnIdent::of);
            List<ColumnIdent> partitionedBy = in.readList(ColumnIdent::of);
            IndexMetadata.State state = in.readEnum(IndexMetadata.State.class);
            List<String> indexUUIDs = in.readStringList();
            long tableVersion = in.readLong();
            return new Table(name, columns, settings, routingColumn, columnPolicy, pkConstraintName, checkConstraints, primaryKeys, partitionedBy, state, indexUUIDs, tableVersion);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.name.writeTo(out);
            out.writeCollection(this.columns, Reference::toStream);
            Settings.writeSettingsToStream(out, this.settings);
            out.writeOptionalWriteable(this.routingColumn);
            out.writeVInt(this.columnPolicy.ordinal());
            out.writeOptionalString(this.pkConstraintName);
            out.writeMap(this.checkConstraints, StreamOutput::writeString, StreamOutput::writeString);
            out.writeList(this.primaryKeys);
            out.writeList(this.partitionedBy);
            out.writeEnum(this.state);
            out.writeStringCollection(this.indexUUIDs);
            out.writeLong(this.tableVersion);
        }

        @Override
        public RelationMetadata withIndexUUIDs(List<String> indexUUIDs) {
            return new Table(this.name, this.columns, this.settings, this.routingColumn, this.columnPolicy, this.pkConstraintName, this.checkConstraints, this.primaryKeys, this.partitionedBy, this.state, indexUUIDs, this.tableVersion);
        }
    }
}

