/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class SchemaMetadata
extends AbstractDiffable<SchemaMetadata> {
    private final ImmutableOpenMap<String, RelationMetadata> relations;

    public SchemaMetadata(ImmutableOpenMap<String, RelationMetadata> relations) {
        this.relations = relations;
    }

    public static SchemaMetadata of(StreamInput in) throws IOException {
        ImmutableOpenMap<String, RelationMetadata> relations = in.readImmutableMap(StreamInput::readString, RelationMetadata::of);
        return new SchemaMetadata(relations);
    }

    public static Diff<SchemaMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SchemaMetadata.readDiffFrom(SchemaMetadata::of, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.relations, StreamOutput::writeString, RelationMetadata::toStream);
    }

    public ImmutableOpenMap<String, RelationMetadata> relations() {
        return this.relations;
    }

    @Nullable
    public RelationMetadata get(RelationName relation) {
        return this.relations.get(relation.name());
    }

    public int hashCode() {
        return this.relations.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof SchemaMetadata)) return false;
        SchemaMetadata other = (SchemaMetadata)obj;
        if (!this.relations.equals(other.relations)) return false;
        return true;
    }
}

