/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import io.crate.common.collections.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardShuffler;

public class RotationShardShuffler
extends ShardShuffler {
    private final AtomicInteger seed;

    public RotationShardShuffler(int seed) {
        this.seed = new AtomicInteger(seed);
    }

    @Override
    public int nextSeed() {
        return this.seed.getAndIncrement();
    }

    @Override
    public List<ShardRouting> shuffle(List<ShardRouting> shards, int seed) {
        return Lists.rotate(shards, (int)seed);
    }
}

