/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import io.crate.common.unit.TimeValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public class ClusterApplierService
extends AbstractLifecycleComponent
implements ClusterApplier {
    private static final Logger LOGGER = LogManager.getLogger(ClusterApplierService.class);
    public static final Setting<TimeValue> CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.slow_task_logging_threshold", TimeValue.timeValueSeconds((long)30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String CLUSTER_UPDATE_THREAD_NAME = "clusterApplierService#updateTask";
    private final ClusterSettings clusterSettings;
    protected final ThreadPool threadPool;
    private volatile TimeValue slowTaskLoggingThreshold;
    private volatile PrioritizedEsThreadPoolExecutor threadPoolExecutor;
    private final Collection<ClusterStateApplier> highPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateApplier> normalPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateApplier> lowPriorityStateAppliers = new CopyOnWriteArrayList<ClusterStateApplier>();
    private final Collection<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Map<TimeoutClusterStateListener, NotifyTimeout> timeoutClusterStateListeners = new ConcurrentHashMap<TimeoutClusterStateListener, NotifyTimeout>();
    private final AtomicReference<ClusterState> state;
    private final String nodeName;
    private NodeConnectionsService nodeConnectionsService;

    public ClusterApplierService(String nodeName, Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        this.clusterSettings = clusterSettings;
        this.threadPool = threadPool;
        this.state = new AtomicReference();
        this.nodeName = nodeName;
        this.slowTaskLoggingThreshold = CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING.get(settings);
        this.clusterSettings.addSettingsUpdateConsumer(CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING, this::setSlowTaskLoggingThreshold);
    }

    private void setSlowTaskLoggingThreshold(TimeValue slowTaskLoggingThreshold) {
        this.slowTaskLoggingThreshold = slowTaskLoggingThreshold;
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        assert (this.nodeConnectionsService == null) : "nodeConnectionsService is already set";
        this.nodeConnectionsService = nodeConnectionsService;
    }

    @Override
    public void setInitialState(ClusterState initialState) {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial state when started");
        }
        assert (this.state.get() == null) : "state is already set";
        this.state.set(initialState);
    }

    @Override
    protected synchronized void doStart() {
        Objects.requireNonNull(this.nodeConnectionsService, "please set the node connection service before starting");
        Objects.requireNonNull(this.state.get(), "please set initial state before starting");
        this.threadPoolExecutor = this.createThreadPoolExecutor();
    }

    protected PrioritizedEsThreadPoolExecutor createThreadPoolExecutor() {
        return EsExecutors.newSinglePrioritizing(this.nodeName + "/clusterApplierService#updateTask", EsExecutors.daemonThreadFactory(this.nodeName, CLUSTER_UPDATE_THREAD_NAME), this.threadPool.scheduler());
    }

    @Override
    protected synchronized void doStop() {
        for (Map.Entry<TimeoutClusterStateListener, NotifyTimeout> onGoingTimeout : this.timeoutClusterStateListeners.entrySet()) {
            try {
                onGoingTimeout.getValue().cancel();
                onGoingTimeout.getKey().onClose();
            }
            catch (Exception ex) {
                LOGGER.debug("failed to notify listeners on shutdown", (Throwable)ex);
            }
        }
        ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected synchronized void doClose() {
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    public ClusterState state() {
        assert (ClusterApplierService.assertNotCalledFromClusterStateApplier("the applied cluster state is not yet available"));
        ClusterState clusterState = this.state.get();
        assert (clusterState != null) : "initial cluster state not set yet";
        return clusterState;
    }

    public void addHighPriorityApplier(ClusterStateApplier applier) {
        this.highPriorityStateAppliers.add(applier);
    }

    public void addLowPriorityApplier(ClusterStateApplier applier) {
        this.lowPriorityStateAppliers.add(applier);
    }

    public void addStateApplier(ClusterStateApplier applier) {
        this.normalPriorityStateAppliers.add(applier);
    }

    public void removeApplier(ClusterStateApplier applier) {
        this.normalPriorityStateAppliers.remove(applier);
        this.highPriorityStateAppliers.remove(applier);
        this.lowPriorityStateAppliers.remove(applier);
    }

    public void addListener(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    public void removeListener(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
    }

    public void removeTimeoutListener(TimeoutClusterStateListener listener) {
        NotifyTimeout timeout = this.timeoutClusterStateListeners.remove(listener);
        if (timeout != null) {
            timeout.cancel();
        }
    }

    public void addLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.addListener(listener);
    }

    public void addTimeoutListener(final @Nullable TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        try {
            this.threadPoolExecutor.execute(new PrioritizedRunnable(this, Priority.HIGH, "_add_listener_"){
                final /* synthetic */ ClusterApplierService this$0;
                {
                    this.this$0 = this$0;
                    super(priority, source);
                }

                @Override
                public void run() {
                    NotifyTimeout notifyTimeout = this.this$0.new NotifyTimeout(listener, timeout);
                    NotifyTimeout previous = this.this$0.timeoutClusterStateListeners.put(listener, notifyTimeout);
                    assert (previous == null) : "Added same listener [" + String.valueOf(listener) + "]";
                    if (this.this$0.lifecycle.stoppedOrClosed()) {
                        listener.onClose();
                        return;
                    }
                    if (timeout != null) {
                        notifyTimeout.cancellable = this.this$0.threadPool.schedule(notifyTimeout, timeout, "generic");
                    }
                    listener.postAdded();
                }
            });
        }
        catch (EsRejectedExecutionException e) {
            if (this.lifecycle.stoppedOrClosed()) {
                listener.onClose();
            }
            throw e;
        }
    }

    public void runOnApplierThread(String source, Consumer<ClusterState> clusterStateConsumer, ActionListener<Void> listener, Priority priority) {
        this.submitStateUpdateTask(source, ClusterStateTaskConfig.build(priority), clusterState -> {
            clusterStateConsumer.accept((ClusterState)clusterState);
            return clusterState;
        }, listener);
    }

    public void runOnApplierThread(String source, Consumer<ClusterState> clusterStateConsumer, ActionListener<Void> listener) {
        this.runOnApplierThread(source, clusterStateConsumer, listener, Priority.HIGH);
    }

    @Override
    public void onNewClusterState(String source, Supplier<ClusterState> clusterStateSupplier, ActionListener<Void> listener) {
        UnaryOperator applyFunction = currentState -> {
            ClusterState nextState = (ClusterState)clusterStateSupplier.get();
            if (nextState != null) {
                return nextState;
            }
            return currentState;
        };
        this.submitStateUpdateTask(source, ClusterStateTaskConfig.build(Priority.HIGH), applyFunction, listener);
    }

    private void submitStateUpdateTask(String source, ClusterStateTaskConfig config, UnaryOperator<ClusterState> executor, ActionListener<Void> listener) {
        block5: {
            if (!this.lifecycle.started()) {
                return;
            }
            try {
                UpdateTask updateTask = new UpdateTask(config.priority(), source, new SafeClusterApplyListener(source, listener, LOGGER), executor);
                if (config.timeout() != null) {
                    this.threadPoolExecutor.execute(updateTask, config.timeout(), () -> this.threadPool.generic().execute(() -> listener.onFailure(new ProcessClusterEventTimeoutException(config.timeout(), source))));
                } else {
                    this.threadPoolExecutor.execute(updateTask);
                }
            }
            catch (EsRejectedExecutionException e) {
                if (this.lifecycle.stoppedOrClosed()) break block5;
                throw e;
            }
        }
    }

    public static boolean assertNotClusterStateUpdateThread(String reason) {
        assert (!Thread.currentThread().getName().contains(CLUSTER_UPDATE_THREAD_NAME)) : "Expected current thread [" + String.valueOf(Thread.currentThread()) + "] to not be the cluster state update thread. Reason: [" + reason + "]";
        return true;
    }

    private static boolean assertNotCalledFromClusterStateApplier(String reason) {
        if (Thread.currentThread().getName().contains(CLUSTER_UPDATE_THREAD_NAME)) {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                String className = element.getClassName();
                String methodName = element.getMethodName();
                if (className.equals(ClusterStateObserver.class.getName())) {
                    return true;
                }
                if (className.equals(ClusterApplierService.class.getName()) && methodName.equals("callClusterStateAppliers")) {
                    throw new AssertionError((Object)("should not be called by a cluster state applier. reason [" + reason + "]"));
                }
            }
        }
        return true;
    }

    private void runTask(UpdateTask task) {
        ClusterState newClusterState;
        if (!this.lifecycle.started()) {
            LOGGER.debug("processing [{}]: ignoring, cluster applier service not started", (Object)task.source());
            return;
        }
        LOGGER.debug("processing [{}]: execute", (Object)task.source());
        ClusterState previousClusterState = this.state.get();
        long startTimeMS = this.currentTimeInMillis();
        StopWatch stopWatch = new StopWatch();
        try (Releasable ignored = stopWatch.timing("running task [" + String.valueOf(task) + "]");){
            newClusterState = task.apply(previousClusterState);
        }
        catch (Exception e) {
            TimeValue executionTime = TimeValue.timeValueMillis((long)Math.max(0L, this.currentTimeInMillis() - startTimeMS));
            LOGGER.trace(() -> new ParameterizedMessage("failed to execute cluster state applier in [{}], state:\nversion [{}], source [{}]\n{}", new Object[]{executionTime, previousClusterState.version(), task.source(), previousClusterState}), (Throwable)e);
            this.warnAboutSlowTaskIfNeeded(executionTime, task.source(), stopWatch);
            task.listener.onFailure(e);
            return;
        }
        if (previousClusterState == newClusterState) {
            executionTime = TimeValue.timeValueMillis((long)Math.max(0L, this.currentTimeInMillis() - startTimeMS));
            LOGGER.debug("processing [{}]: took [{}] no change in cluster state", (Object)task.source(), (Object)executionTime);
            this.warnAboutSlowTaskIfNeeded(executionTime, task.source(), stopWatch);
            task.listener.onResponse(null);
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.debug("cluster state updated, version [{}], source [{}]\n{}", (Object)newClusterState.version(), (Object)task.source(), (Object)newClusterState);
            } else {
                LOGGER.debug("cluster state updated, version [{}], source [{}]", (Object)newClusterState.version(), (Object)task.source());
            }
            try {
                this.applyChanges(task, previousClusterState, newClusterState, stopWatch);
                executionTime = TimeValue.timeValueMillis((long)Math.max(0L, this.currentTimeInMillis() - startTimeMS));
                LOGGER.debug("processing [{}]: took [{}] done applying updated cluster state (version: {}, uuid: {})", (Object)task.source(), (Object)executionTime, (Object)newClusterState.version(), (Object)newClusterState.stateUUID());
                this.warnAboutSlowTaskIfNeeded(executionTime, task.source(), stopWatch);
                task.listener.onResponse(null);
            }
            catch (Exception e) {
                TimeValue executionTime = TimeValue.timeValueMillis((long)Math.max(0L, this.currentTimeInMillis() - startTimeMS));
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.warn((Message)new ParameterizedMessage("failed to apply updated cluster state in [{}]:\nversion [{}], uuid [{}], source [{}]\n{}", new Object[]{executionTime, newClusterState.version(), newClusterState.stateUUID(), task.source(), newClusterState}), (Throwable)e);
                } else {
                    LOGGER.warn((Message)new ParameterizedMessage("failed to apply updated cluster state in [{}]:\nversion [{}], uuid [{}], source [{}]", new Object[]{executionTime, newClusterState.version(), newClusterState.stateUUID(), task.source()}), (Throwable)e);
                }
                assert (this.applicationMayFail());
                task.listener.onFailure(e);
            }
        }
    }

    private void applyChanges(UpdateTask task, ClusterState previousClusterState, ClusterState newClusterState, StopWatch stopWatch) {
        String summary;
        ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(task.source(), newClusterState, previousClusterState);
        DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
        if (nodesDelta.hasChanges() && LOGGER.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
            LOGGER.info("{}, term: {}, version: {}, reason: {}", (Object)summary, (Object)newClusterState.term(), (Object)newClusterState.version(), (Object)task.source());
        }
        LOGGER.trace("connecting to nodes of cluster state with version {}", (Object)newClusterState.version());
        try (Releasable ignored = stopWatch.timing("connecting to new nodes");){
            this.connectToNodesAndWait(newClusterState);
        }
        if (!clusterChangedEvent.state().blocks().disableStatePersistence() && clusterChangedEvent.metadataChanged()) {
            LOGGER.debug("applying settings from cluster state with version {}", (Object)newClusterState.version());
            Settings incomingSettings = clusterChangedEvent.state().metadata().settings();
            try (Releasable ignored = stopWatch.timing("applying settings");){
                this.clusterSettings.applySettings(incomingSettings);
            }
        }
        LOGGER.debug("apply cluster state with version {}", (Object)newClusterState.version());
        this.callClusterStateAppliers(clusterChangedEvent, stopWatch);
        this.nodeConnectionsService.disconnectFromNodesExcept(newClusterState.nodes());
        LOGGER.debug("set locally applied cluster state to version {}", (Object)newClusterState.version());
        this.state.set(newClusterState);
        this.callClusterStateListeners(clusterChangedEvent, stopWatch);
    }

    protected void connectToNodesAndWait(ClusterState newClusterState) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.nodeConnectionsService.connectToNodes(newClusterState.nodes(), countDownLatch::countDown);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.debug("interrupted while connecting to nodes, continuing", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void callClusterStateAppliers(ClusterChangedEvent clusterChangedEvent, StopWatch stopWatch) {
        ClusterApplierService.callClusterStateAppliers(clusterChangedEvent, stopWatch, this.highPriorityStateAppliers);
        ClusterApplierService.callClusterStateAppliers(clusterChangedEvent, stopWatch, this.normalPriorityStateAppliers);
        ClusterApplierService.callClusterStateAppliers(clusterChangedEvent, stopWatch, this.lowPriorityStateAppliers);
    }

    private static void callClusterStateAppliers(ClusterChangedEvent clusterChangedEvent, StopWatch stopWatch, Collection<ClusterStateApplier> clusterStateAppliers) {
        for (ClusterStateApplier applier : clusterStateAppliers) {
            LOGGER.trace("calling [{}] with change to version [{}]", (Object)applier, (Object)clusterChangedEvent.state().version());
            Releasable ignored = stopWatch.timing("running applier [" + String.valueOf(applier) + "]");
            try {
                applier.applyClusterState(clusterChangedEvent);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
    }

    private void callClusterStateListeners(ClusterChangedEvent clusterChangedEvent, StopWatch stopWatch) {
        this.callClusterStateListener(clusterChangedEvent, stopWatch, this.clusterStateListeners);
        this.callClusterStateListener(clusterChangedEvent, stopWatch, this.timeoutClusterStateListeners.keySet());
    }

    private void callClusterStateListener(ClusterChangedEvent clusterChangedEvent, StopWatch stopWatch, Collection<? extends ClusterStateListener> listeners) {
        for (ClusterStateListener clusterStateListener : listeners) {
            try {
                LOGGER.trace("calling [{}] with change to version [{}]", (Object)clusterStateListener, (Object)clusterChangedEvent.state().version());
                Releasable ignored = stopWatch.timing("notifying listener [" + String.valueOf(clusterStateListener) + "]");
                try {
                    clusterStateListener.clusterChanged(clusterChangedEvent);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("failed to notify ClusterStateListener", (Throwable)ex);
            }
        }
    }

    private void warnAboutSlowTaskIfNeeded(TimeValue executionTime, String source, StopWatch stopWatch) {
        if (executionTime.millis() > this.slowTaskLoggingThreshold.millis()) {
            LOGGER.warn("cluster state applier task [{}] took [{}] which is above the warn threshold of [{}]: {}", (Object)source, (Object)executionTime, (Object)this.slowTaskLoggingThreshold, (Object)Arrays.stream(stopWatch.taskInfo()).map(ti -> "[" + ti.getTaskName() + "] took [" + ti.getTime().millis() + "ms]").collect(Collectors.joining(", ")));
        }
    }

    protected long currentTimeInMillis() {
        return this.threadPool.relativeTimeInMillis();
    }

    protected boolean applicationMayFail() {
        return false;
    }

    private class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        @Nullable
        final TimeValue timeout;
        volatile Scheduler.Cancellable cancellable;

        NotifyTimeout(@Nullable TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
        }

        @Override
        public void run() {
            assert (this.timeout != null) : "This should only ever execute if there's an actual timeout set";
            if (this.cancellable != null && this.cancellable.isCancelled()) {
                return;
            }
            if (ClusterApplierService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }

    class UpdateTask
    extends PrioritizedRunnable
    implements UnaryOperator<ClusterState> {
        final ActionListener<Void> listener;
        final UnaryOperator<ClusterState> updateFunction;

        UpdateTask(Priority priority, String source, ActionListener<Void> listener, UnaryOperator<ClusterState> updateFunction) {
            super(priority, source);
            this.listener = listener;
            this.updateFunction = updateFunction;
        }

        @Override
        public ClusterState apply(ClusterState clusterState) {
            return (ClusterState)this.updateFunction.apply(clusterState);
        }

        @Override
        public void run() {
            ClusterApplierService.this.runTask(this);
        }
    }

    private static class SafeClusterApplyListener
    implements ActionListener<Void> {
        private final ActionListener<Void> listener;
        private final Logger logger;
        private final String source;

        SafeClusterApplyListener(String source, ActionListener<Void> listener, Logger logger) {
            this.listener = listener;
            this.logger = logger;
            this.source = source;
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.listener.onFailure(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.error((Message)new ParameterizedMessage("exception thrown by listener notifying of failure from [{}]", (Object)this.source), (Throwable)inner);
            }
        }

        @Override
        public void onResponse(Void response) {
            try {
                this.listener.onResponse(response);
            }
            catch (Exception e) {
                this.logger.error((Message)new ParameterizedMessage("exception thrown by listener while notifying of cluster state processed from [{}]", (Object)this.source), (Throwable)e);
            }
        }
    }
}

