/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.io.IOException;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record PendingClusterTask(long insertOrder, Priority priority, String source, long timeInQueue, boolean executing) implements Writeable
{
    public PendingClusterTask {
        assert (timeInQueue >= 0L) : "got a negative timeInQueue [" + timeInQueue + "]";
        assert (insertOrder >= 0L) : "got a negative insertOrder [" + insertOrder + "]";
    }

    public static PendingClusterTask of(StreamInput in) throws IOException {
        long insertOrder = in.readVLong();
        Priority priority = Priority.readFrom(in);
        String source = in.readString();
        long timeInQueue = in.readLong();
        boolean executing = in.readBoolean();
        return new PendingClusterTask(insertOrder, priority, source, timeInQueue, executing);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.insertOrder);
        Priority.writeTo(this.priority, out);
        out.writeString(this.source);
        out.writeLong(this.timeInQueue);
        out.writeBoolean(this.executing);
    }
}

