/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.ByteBufferReference;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.PagedBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface BytesReference
extends Comparable<BytesReference> {
    public static BytesReference bytes(XContentBuilder xContentBuilder) {
        OutputStream stream;
        xContentBuilder.close();
        OutputStream outputStream = stream = xContentBuilder.getOutputStream();
        Objects.requireNonNull(outputStream);
        OutputStream outputStream2 = outputStream;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteArrayOutputStream.class, ByteBufOutputStream.class, BytesStream.class}, (OutputStream)outputStream2, n)) {
            case 0 -> {
                ByteArrayOutputStream bos = (ByteArrayOutputStream)outputStream2;
                yield new BytesArray(bos.toByteArray());
            }
            case 1 -> {
                ByteBufOutputStream bos = (ByteBufOutputStream)outputStream2;
                ByteBuf buffer = bos.buffer();
                byte[] array = buffer.copy(0, buffer.writerIndex()).array();
                buffer.release();
                yield new BytesArray(array);
            }
            case 2 -> {
                BytesStream bos = (BytesStream)outputStream2;
                yield bos.bytes();
            }
            default -> throw new UnsupportedOperationException("Cannot convert OutputStream to BytesReference: " + String.valueOf(stream));
        };
    }

    public static byte[] toBytes(BytesReference reference) {
        BytesRef bytesRef = reference.toBytesRef();
        if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
            return bytesRef.bytes;
        }
        return BytesRef.deepCopyOf((BytesRef)bytesRef).bytes;
    }

    public static ByteBuffer[] toByteBuffers(BytesReference reference) {
        BytesRefIterator byteRefIterator = reference.iterator();
        try {
            BytesRef r;
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            while ((r = byteRefIterator.next()) != null) {
                buffers.add(ByteBuffer.wrap(r.bytes, r.offset, r.length));
            }
            return buffers.toArray(new ByteBuffer[buffers.size()]);
        }
        catch (IOException e) {
            throw new AssertionError("won't happen", e);
        }
    }

    public static BytesReference fromByteBuffers(ByteBuffer[] buffers) {
        int bufferCount = buffers.length;
        if (bufferCount == 0) {
            return BytesArray.EMPTY;
        }
        if (bufferCount == 1) {
            return BytesReference.fromByteBuffer(buffers[0]);
        }
        BytesReference[] references = new BytesReference[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            references[i] = BytesReference.fromByteBuffer(buffers[i]);
        }
        return CompositeBytesReference.of(references);
    }

    public static BytesReference fromByteBuffer(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return new BytesArray(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }
        return new ByteBufferReference(buffer);
    }

    public static BytesReference fromByteArray(ByteArray byteArray, int length) {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        if (byteArray.hasArray()) {
            return new BytesArray(byteArray.array(), 0, length);
        }
        return new PagedBytesReference(byteArray, 0, length);
    }

    public byte get(int var1);

    public int getInt(int var1);

    public int indexOf(byte var1, int var2);

    public int length();

    public BytesReference slice(int var1, int var2);

    public long ramBytesUsed();

    public StreamInput streamInput() throws IOException;

    public void writeTo(OutputStream var1) throws IOException;

    public String utf8ToString();

    public BytesRef toBytesRef();

    public BytesRefIterator iterator();
}

