/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.common.lucene.uid.PerThreadIDVersionAndSeqNoLookup;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public final class VersionsAndSeqNoResolver {
    static final ConcurrentMap<IndexReader.CacheKey, CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>> LOOKUP_STATES = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private static final IndexReader.ClosedListener REMOVE_LOOKUP_STATE = key -> {
        CloseableThreadLocal ctl = (CloseableThreadLocal)LOOKUP_STATES.remove(key);
        if (ctl != null) {
            ctl.close();
        }
    };

    private static PerThreadIDVersionAndSeqNoLookup[] getLookupState(IndexReader reader) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookupState;
        IndexReader.CacheHelper cacheHelper = reader.getReaderCacheHelper();
        CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> ctl = (CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]>)LOOKUP_STATES.get(cacheHelper.getKey());
        if (ctl == null) {
            ctl = new CloseableThreadLocal();
            CloseableThreadLocal<PerThreadIDVersionAndSeqNoLookup[]> other = LOOKUP_STATES.putIfAbsent(cacheHelper.getKey(), ctl);
            if (other == null) {
                cacheHelper.addClosedListener(REMOVE_LOOKUP_STATE);
            } else {
                ctl = other;
            }
        }
        if ((lookupState = (PerThreadIDVersionAndSeqNoLookup[])ctl.get()) == null) {
            lookupState = new PerThreadIDVersionAndSeqNoLookup[reader.leaves().size()];
            for (LeafReaderContext leaf : reader.leaves()) {
                lookupState[leaf.ord] = new PerThreadIDVersionAndSeqNoLookup(leaf.reader());
            }
            ctl.set((Object)lookupState);
        }
        if (lookupState.length != reader.leaves().size()) {
            throw new AssertionError((Object)("Mismatched numbers of leaves: " + lookupState.length + " != " + reader.leaves().size()));
        }
        return lookupState;
    }

    private VersionsAndSeqNoResolver() {
    }

    public static DocIdAndVersion loadDocIdAndVersion(IndexReader reader, BytesRef uid, boolean loadSeqNo) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader);
        List leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf;
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            leaf = (LeafReaderContext)leaves.get(i);
            DocIdAndVersion result = lookup.lookupVersion(uid, loadSeqNo, leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static DocIdAndSeqNo loadDocIdAndSeqNo(IndexReader reader, BytesRef uid) throws IOException {
        PerThreadIDVersionAndSeqNoLookup[] lookups = VersionsAndSeqNoResolver.getLookupState(reader);
        List leaves = reader.leaves();
        for (int i = leaves.size() - 1; i >= 0; --i) {
            LeafReaderContext leaf;
            PerThreadIDVersionAndSeqNoLookup lookup = lookups[leaf.ord];
            leaf = (LeafReaderContext)leaves.get(i);
            DocIdAndSeqNo result = lookup.lookupSeqNo(uid, leaf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static class DocIdAndVersion {
        public final int docId;
        public final long version;
        public final long seqNo;
        public final long primaryTerm;
        public final LeafReader reader;
        public final int docBase;

        public DocIdAndVersion(int docId, long version, long seqNo, long primaryTerm, LeafReader reader, int docBase) {
            this.docId = docId;
            this.version = version;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.reader = reader;
            this.docBase = docBase;
        }
    }

    public static class DocIdAndSeqNo {
        public final int docId;
        public final long seqNo;
        public final LeafReaderContext context;

        DocIdAndSeqNo(int docId, long seqNo, LeafReaderContext context) {
            this.docId = docId;
            this.seqNo = seqNo;
            this.context = context;
        }
    }
}

