/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import java.util.function.Function;
import org.elasticsearch.common.joda.Joda;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public enum DateTimeUnit {
    WEEK_OF_WEEKYEAR(tz -> ISOChronology.getInstance((DateTimeZone)tz).weekOfWeekyear()),
    YEAR_OF_CENTURY(tz -> ISOChronology.getInstance((DateTimeZone)tz).yearOfCentury()),
    QUARTER(tz -> Joda.QUARTER_OF_YEAR.getField((Chronology)ISOChronology.getInstance((DateTimeZone)tz))),
    MONTH_OF_YEAR(tz -> ISOChronology.getInstance((DateTimeZone)tz).monthOfYear()),
    DAY_OF_MONTH(tz -> ISOChronology.getInstance((DateTimeZone)tz).dayOfMonth()),
    HOUR_OF_DAY(tz -> ISOChronology.getInstance((DateTimeZone)tz).hourOfDay()),
    MINUTES_OF_HOUR(tz -> ISOChronology.getInstance((DateTimeZone)tz).minuteOfHour()),
    SECOND_OF_MINUTE(tz -> ISOChronology.getInstance((DateTimeZone)tz).secondOfMinute());

    private final Function<DateTimeZone, DateTimeField> fieldFunction;

    private DateTimeUnit(Function<DateTimeZone, DateTimeField> fieldFunction) {
        this.fieldFunction = fieldFunction;
    }

    public DateTimeField field(DateTimeZone tz) {
        return this.fieldFunction.apply(tz);
    }
}

