/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import io.crate.common.SuppressForbidden;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.WrappedRunnable;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;

public class EsThreadPoolExecutor
extends ThreadPoolExecutor {
    private final String name;

    final String getName() {
        return this.name;
    }

    public EsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new EsAbortPolicy());
    }

    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    public EsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, XRejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        command = this.wrapRunnable(command);
        try {
            super.execute(command);
        }
        catch (EsRejectedExecutionException ex) {
            if (command instanceof RejectableRunnable) {
                RejectableRunnable runnable = (RejectableRunnable)command;
                try {
                    runnable.onRejection(ex);
                }
                finally {
                    runnable.onAfter();
                }
            }
            throw ex;
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        EsExecutors.rethrowErrors(this.unwrap(r));
    }

    @Override
    public final String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append('[');
        b.append("name = ").append(this.name).append(", ");
        if (this.getQueue() instanceof SizeBlockingQueue) {
            SizeBlockingQueue queue = (SizeBlockingQueue)this.getQueue();
            b.append("queue capacity = ").append(queue.capacity()).append(", ");
        }
        b.append(super.toString()).append(']');
        return b.toString();
    }

    protected Runnable wrapRunnable(Runnable command) {
        return command;
    }

    protected Runnable unwrap(Runnable runnable) {
        while (runnable instanceof WrappedRunnable) {
            WrappedRunnable wrapped = (WrappedRunnable)runnable;
            runnable = wrapped.unwrap();
        }
        return runnable;
    }
}

